/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.baseadaptor.StateManager;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ResolverErrorImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class StateImpl
implements State {
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_NL = "osgi.nl";
    private static final String OSGI_ARCH = "osgi.arch";
    public static final String[] PROPS = new String[]{"osgi.os", "osgi.ws", "osgi.nl", "osgi.arch", "org.osgi.framework.system.packages", "osgi.resolverMode", "org.osgi.framework.executionenvironment", "osgi.resolveOptional", "osgi.genericAliases", "org.osgi.framework.os.name", "org.osgi.framework.os.version", "org.osgi.framework.processor", "org.osgi.framework.language", "osgi.system.bundle"};
    private static final DisabledInfo[] EMPTY_DISABLEDINFOS = new DisabledInfo[0];
    private transient Resolver resolver;
    private transient StateDeltaImpl changes;
    private transient boolean resolving = false;
    private transient HashSet removalPendings = new HashSet();
    private boolean resolved = true;
    private long timeStamp = System.currentTimeMillis();
    private KeyedHashSet bundleDescriptions = new KeyedHashSet(false);
    private HashMap resolverErrors = new HashMap();
    private StateObjectFactory factory;
    private KeyedHashSet resolvedBundles = new KeyedHashSet();
    private HashMap disabledBundles = new HashMap();
    boolean fullyLoaded = false;
    private boolean dynamicCacheChanged = false;
    private StateReader reader;
    private Dictionary[] platformProperties = new Dictionary[]{new Hashtable(PROPS.length)};
    private long highestBundleId = -1L;
    private HashSet platformPropertyKeys = new HashSet(PROPS.length);
    private static long cumulativeTime;

    protected StateImpl() {
        this.addPlatformPropertyKeys(PROPS);
    }

    public boolean addBundle(BundleDescription bundleDescription) {
        Object object;
        if (!this.basicAddBundle(bundleDescription)) {
            return false;
        }
        String string = bundleDescription.getPlatformFilter();
        if (string != null) {
            try {
                object = (FilterImpl)FrameworkUtil.createFilter(string);
                this.addPlatformPropertyKeys(((FilterImpl)object).getAttributes());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        if ((object = bundleDescription.getNativeCodeSpecification()) != null) {
            NativeCodeDescription[] nativeCodeDescriptionArray = object.getPossibleSuppliers();
            int n = 0;
            while (n < nativeCodeDescriptionArray.length) {
                FilterImpl filterImpl = (FilterImpl)nativeCodeDescriptionArray[n].getFilter();
                if (filterImpl != null) {
                    this.addPlatformPropertyKeys(filterImpl.getAttributes());
                }
                ++n;
            }
        }
        this.resolved = false;
        this.getDelta().recordBundleAdded((BundleDescriptionImpl)bundleDescription);
        if (this.getSystemBundle().equals(bundleDescription.getSymbolicName())) {
            this.resetSystemExports();
        }
        if (this.resolver != null) {
            this.resolver.bundleAdded(bundleDescription);
        }
        this.updateTimeStamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateBundle(BundleDescription bundleDescription) {
        ArrayList<DisabledInfo> arrayList;
        Object object;
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)this.bundleDescriptions.get((BundleDescriptionImpl)bundleDescription);
        if (bundleDescriptionImpl == null) {
            return false;
        }
        if (!this.bundleDescriptions.remove(bundleDescriptionImpl)) {
            return false;
        }
        this.resolvedBundles.remove(bundleDescriptionImpl);
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            object = (ArrayList)this.disabledBundles.remove(bundleDescriptionImpl);
            if (object != null) {
                arrayList = new ArrayList<DisabledInfo>(((ArrayList)object).size());
                Iterator iterator = ((ArrayList)object).iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.disabledBundles.put(bundleDescription, arrayList);
                        break;
                    }
                    DisabledInfo disabledInfo = (DisabledInfo)iterator.next();
                    arrayList.add(new DisabledInfo(disabledInfo.getPolicyName(), disabledInfo.getMessage(), bundleDescription));
                }
            }
        }
        bundleDescriptionImpl.setStateBit(4, true);
        if (!this.basicAddBundle(bundleDescription)) {
            return false;
        }
        this.resolved = false;
        this.getDelta().recordBundleUpdated((BundleDescriptionImpl)bundleDescription);
        if (this.getSystemBundle().equals(bundleDescription.getSymbolicName())) {
            this.resetSystemExports();
        }
        if (this.resolver != null) {
            boolean bl = bundleDescriptionImpl.getDependents().length > 0;
            this.resolver.bundleUpdated(bundleDescription, bundleDescriptionImpl, bl);
            if (bl) {
                this.getDelta().recordBundleRemovalPending(bundleDescriptionImpl);
                this.removalPendings.add(bundleDescriptionImpl);
            } else {
                object = this;
                synchronized (object) {
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(bundleDescriptionImpl);
                        this.resolveBundle(bundleDescriptionImpl, false, null, null, null, null, null);
                        arrayList = null;
                        this.resolving = false;
                    }
                    catch (Throwable throwable) {
                        arrayList = null;
                        this.resolving = false;
                        throw throwable;
                    }
                }
            }
        }
        this.updateTimeStamp();
        return true;
    }

    public BundleDescription removeBundle(long l) {
        BundleDescription bundleDescription = this.getBundle(l);
        if (bundleDescription == null || !this.removeBundle(bundleDescription)) {
            return null;
        }
        return bundleDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeBundle(BundleDescription bundleDescription) {
        if (!this.bundleDescriptions.remove((KeyedElement)((Object)bundleDescription))) {
            return false;
        }
        this.resolvedBundles.remove((KeyedElement)((Object)bundleDescription));
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            this.disabledBundles.remove(bundleDescription);
        }
        this.resolved = false;
        this.getDelta().recordBundleRemoved((BundleDescriptionImpl)bundleDescription);
        ((BundleDescriptionImpl)bundleDescription).setStateBit(4, true);
        if (this.resolver != null) {
            boolean bl = bundleDescription.getDependents().length > 0;
            this.resolver.bundleRemoved(bundleDescription, bl);
            if (bl) {
                this.getDelta().recordBundleRemovalPending((BundleDescriptionImpl)bundleDescription);
                this.removalPendings.add(bundleDescription);
            } else {
                StateImpl stateImpl = this;
                synchronized (stateImpl) {
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(bundleDescription);
                        this.resolveBundle(bundleDescription, false, null, null, null, null, null);
                        Object var4_7 = null;
                        this.resolving = false;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        this.resolving = false;
                        throw throwable;
                    }
                }
            }
        }
        this.updateTimeStamp();
        return true;
    }

    public StateDelta getChanges() {
        return this.getDelta();
    }

    private StateDeltaImpl getDelta() {
        if (this.changes == null) {
            this.changes = new StateDeltaImpl(this);
        }
        return this.changes;
    }

    public BundleDescription[] getBundles(String string) {
        if ("system.bundle".equals(string)) {
            string = this.getSystemBundle();
        }
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>();
        Iterator iterator = this.bundleDescriptions.iterator();
        while (iterator.hasNext()) {
            BundleDescription bundleDescription = (BundleDescription)iterator.next();
            if (!string.equals(bundleDescription.getSymbolicName())) continue;
            arrayList.add(bundleDescription);
        }
        return arrayList.toArray(new BundleDescription[arrayList.size()]);
    }

    public BundleDescription[] getBundles() {
        return (BundleDescription[])this.bundleDescriptions.elements(new BundleDescription[this.bundleDescriptions.size()]);
    }

    public BundleDescription getBundle(long l) {
        BundleDescription bundleDescription = (BundleDescription)((Object)this.bundleDescriptions.getByKey(new Long(l)));
        if (bundleDescription != null) {
            return bundleDescription;
        }
        Iterator iterator = this.removalPendings.iterator();
        while (iterator.hasNext()) {
            BundleDescription bundleDescription2 = (BundleDescription)iterator.next();
            if (bundleDescription2.getBundleId() != l) continue;
            return bundleDescription2;
        }
        return null;
    }

    public BundleDescription getBundle(String string, Version version) {
        BundleDescription[] bundleDescriptionArray = this.getBundles(string);
        if (bundleDescriptionArray.length == 1) {
            return version == null || bundleDescriptionArray[0].getVersion().equals(version) ? bundleDescriptionArray[0] : null;
        }
        if (bundleDescriptionArray.length == 0) {
            return null;
        }
        BaseDescription baseDescription = null;
        BaseDescription baseDescription2 = null;
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            BundleDescription bundleDescription = bundleDescriptionArray[n];
            BaseDescription baseDescription3 = bundleDescription.isResolved() ? baseDescription2 : baseDescription;
            if (version == null || bundleDescription.getVersion().equals(version)) {
                if (baseDescription3 != null && (baseDescription3.getVersion().compareTo(bundleDescription.getVersion()) <= 0 || baseDescription3.getBundleId() > bundleDescription.getBundleId())) {
                    if (baseDescription3 == baseDescription2) {
                        baseDescription2 = bundleDescription;
                    } else {
                        baseDescription = bundleDescription;
                    }
                } else if (bundleDescription.isResolved()) {
                    baseDescription2 = bundleDescription;
                } else {
                    baseDescription = bundleDescription;
                }
            }
            ++n;
        }
        if (baseDescription2 != null) {
            return baseDescription2;
        }
        return baseDescription;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isResolved() {
        return this.resolved || this.isEmpty();
    }

    public void resolveConstraint(VersionConstraint versionConstraint, BaseDescription baseDescription) {
        ((VersionConstraintImpl)versionConstraint).setSupplier(baseDescription);
    }

    public void resolveBundle(BundleDescription bundleDescription, boolean bl, BundleDescription[] bundleDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray, BundleDescription[] bundleDescriptionArray2, ExportPackageDescription[] exportPackageDescriptionArray2) {
        this.resolveBundle(bundleDescription, bl, bundleDescriptionArray, exportPackageDescriptionArray, null, bundleDescriptionArray2, exportPackageDescriptionArray2);
    }

    public synchronized void resolveBundle(BundleDescription bundleDescription, boolean bl, BundleDescription[] bundleDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray2, BundleDescription[] bundleDescriptionArray2, ExportPackageDescription[] exportPackageDescriptionArray3) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescription;
        this.getDelta().recordBundleResolved(bundleDescriptionImpl, bl);
        bundleDescriptionImpl.setLazyLoaded(false);
        bundleDescriptionImpl.setStateBit(1, bl);
        if (bl) {
            this.resolverErrors.remove(bundleDescriptionImpl);
            this.resolvedBundles.add(bundleDescriptionImpl);
        } else {
            this.resolvedBundles.remove(bundleDescriptionImpl);
            bundleDescriptionImpl.removeDependencies();
        }
        if (exportPackageDescriptionArray == null || bundleDescriptionArray2 == null || exportPackageDescriptionArray3 == null) {
            this.unresolveConstraints(bundleDescriptionImpl);
        } else {
            this.resolveConstraints(bundleDescriptionImpl, bundleDescriptionArray, exportPackageDescriptionArray, exportPackageDescriptionArray2, bundleDescriptionArray2, exportPackageDescriptionArray3);
        }
    }

    public synchronized void removeBundleComplete(BundleDescription bundleDescription) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        this.getDelta().recordBundleRemovalComplete((BundleDescriptionImpl)bundleDescription);
        this.removalPendings.remove(bundleDescription);
    }

    private void resolveConstraints(BundleDescriptionImpl bundleDescriptionImpl, BundleDescription[] bundleDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray, ExportPackageDescription[] exportPackageDescriptionArray2, BundleDescription[] bundleDescriptionArray2, ExportPackageDescription[] exportPackageDescriptionArray3) {
        HostSpecificationImpl hostSpecificationImpl = (HostSpecificationImpl)bundleDescriptionImpl.getHost();
        if (hostSpecificationImpl != null && bundleDescriptionArray != null) {
            hostSpecificationImpl.setHosts(bundleDescriptionArray);
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                ((BundleDescriptionImpl)bundleDescriptionArray[n]).addDependency(bundleDescriptionImpl, true);
                this.checkHostForSubstitutedExports((BundleDescriptionImpl)bundleDescriptionArray[n], bundleDescriptionImpl);
                ++n;
            }
        }
        bundleDescriptionImpl.setSelectedExports(exportPackageDescriptionArray);
        bundleDescriptionImpl.setResolvedRequires(bundleDescriptionArray2);
        bundleDescriptionImpl.setResolvedImports(exportPackageDescriptionArray3);
        bundleDescriptionImpl.setSubstitutedExports(exportPackageDescriptionArray2);
        bundleDescriptionImpl.addDependencies(bundleDescriptionArray, true);
        bundleDescriptionImpl.addDependencies(bundleDescriptionArray2, true);
        bundleDescriptionImpl.addDependencies(exportPackageDescriptionArray3, true);
        GenericSpecification[] genericSpecificationArray = bundleDescriptionImpl.getGenericRequires();
        if (genericSpecificationArray.length > 0) {
            ArrayList<GenericDescription> arrayList = new ArrayList<GenericDescription>(genericSpecificationArray.length);
            int n = 0;
            while (n < genericSpecificationArray.length) {
                GenericDescription[] genericDescriptionArray = genericSpecificationArray[n].getSuppliers();
                if (genericDescriptionArray != null) {
                    int n2 = 0;
                    while (n2 < genericDescriptionArray.length) {
                        arrayList.add(genericDescriptionArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
            bundleDescriptionImpl.addDependencies(arrayList.toArray(new BaseDescription[arrayList.size()]), true);
        }
    }

    private void checkHostForSubstitutedExports(BundleDescriptionImpl bundleDescriptionImpl, BundleDescriptionImpl bundleDescriptionImpl2) {
    }

    private void unresolveConstraints(BundleDescriptionImpl bundleDescriptionImpl) {
        HostSpecificationImpl hostSpecificationImpl = (HostSpecificationImpl)bundleDescriptionImpl.getHost();
        if (hostSpecificationImpl != null) {
            hostSpecificationImpl.setHosts(null);
        }
        bundleDescriptionImpl.setSelectedExports(null);
        bundleDescriptionImpl.setResolvedImports(null);
        bundleDescriptionImpl.setResolvedRequires(null);
        bundleDescriptionImpl.setSubstitutedExports(null);
        GenericSpecification[] genericSpecificationArray = bundleDescriptionImpl.getGenericRequires();
        if (genericSpecificationArray.length > 0) {
            int n = 0;
            while (n < genericSpecificationArray.length) {
                ((GenericSpecificationImpl)genericSpecificationArray[n]).setSupplers(null);
                ++n;
            }
        }
        bundleDescriptionImpl.removeDependencies();
    }

    private synchronized StateDelta resolve(boolean bl, BundleDescription[] bundleDescriptionArray) {
        Object[] objectArray;
        long l;
        block12: {
            this.resolving = true;
            if (this.resolver == null) {
                throw new IllegalStateException("no resolver set");
            }
            this.fullyLoad();
            l = 0L;
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                l = System.currentTimeMillis();
            }
            if (!bl) {
                this.resolved = false;
                bundleDescriptionArray = this.getBundles();
                if (this.removalPendings.size() > 0) {
                    objectArray = this.getRemovalPendings();
                    bundleDescriptionArray = this.mergeBundles(bundleDescriptionArray, (BundleDescription[])objectArray);
                }
                this.flush(bundleDescriptionArray);
            }
            if (!this.resolved || bundleDescriptionArray != null) break block12;
            StateDeltaImpl stateDeltaImpl = new StateDeltaImpl(this);
            Object var9_7 = null;
            this.resolving = false;
            return stateDeltaImpl;
        }
        try {
            if (this.removalPendings.size() > 0) {
                objectArray = this.getRemovalPendings();
                bundleDescriptionArray = this.mergeBundles(bundleDescriptionArray, (BundleDescription[])objectArray);
            }
            objectArray = new Headers[this.platformProperties.length];
            int n = 0;
            while (n < this.platformProperties.length) {
                objectArray[n] = new Headers(this.platformProperties[n].size());
                Enumeration enumeration = this.platformProperties[n].keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    ((Headers)objectArray[n]).put(k, this.platformProperties[n].get(k));
                }
                ++n;
            }
            this.resolver.resolve(bundleDescriptionArray, (Dictionary[])objectArray);
            this.resolved = this.removalPendings.size() == 0;
            StateDeltaImpl stateDeltaImpl = this.changes == null ? new StateDeltaImpl(this) : this.changes;
            this.changes = new StateDeltaImpl(this);
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                long l2 = System.currentTimeMillis() - l;
                Debug.println("Time spent resolving: " + l2);
                FrameworkDebugOptions.getDefault().setOption("org.eclipse.core.runtime.adaptor/resolver/timing/value", Long.toString(cumulativeTime += l2));
            }
            if (stateDeltaImpl.getChanges().length > 0) {
                this.updateTimeStamp();
            }
            StateDeltaImpl stateDeltaImpl2 = stateDeltaImpl;
            Object var9_8 = null;
            this.resolving = false;
            return stateDeltaImpl2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.resolving = false;
            throw throwable;
        }
    }

    private BundleDescription[] mergeBundles(BundleDescription[] bundleDescriptionArray, BundleDescription[] bundleDescriptionArray2) {
        if (bundleDescriptionArray == null) {
            return bundleDescriptionArray2;
        }
        if (bundleDescriptionArray.length == 0) {
            return bundleDescriptionArray;
        }
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(bundleDescriptionArray.length + bundleDescriptionArray2.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            arrayList.add(bundleDescriptionArray[n]);
            ++n;
        }
        n = 0;
        while (n < bundleDescriptionArray2.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < bundleDescriptionArray.length) {
                if (bundleDescriptionArray2[n] == bundleDescriptionArray[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                arrayList.add(bundleDescriptionArray2[n]);
            }
            ++n;
        }
        return arrayList.toArray(new BundleDescription[arrayList.size()]);
    }

    private void flush(BundleDescription[] bundleDescriptionArray) {
        this.resolver.flush();
        this.resolved = false;
        this.resolverErrors.clear();
        if (this.resolvedBundles.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.resolveBundle(bundleDescriptionArray[n], false, null, null, null, null, null);
            ++n;
        }
        this.resolvedBundles.clear();
    }

    public StateDelta resolve() {
        return this.resolve(true, null);
    }

    public StateDelta resolve(boolean bl) {
        return this.resolve(bl, null);
    }

    public StateDelta resolve(BundleDescription[] bundleDescriptionArray) {
        return this.resolve(true, bundleDescriptionArray);
    }

    public void setOverrides(Object object) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription[] getResolvedBundles() {
        return (BundleDescription[])this.resolvedBundles.elements(new BundleDescription[this.resolvedBundles.size()]);
    }

    public boolean isEmpty() {
        return this.bundleDescriptions.isEmpty();
    }

    void setResolved(boolean bl) {
        this.resolved = bl;
    }

    boolean basicAddBundle(BundleDescription bundleDescription) {
        StateImpl stateImpl = (StateImpl)bundleDescription.getContainingState();
        if (stateImpl != null && stateImpl != this) {
            if (stateImpl.removalPendings.contains(bundleDescription)) {
                throw new IllegalStateException(NLS.bind(StateMsg.BUNDLE_PENDING_REMOVE_STATE, bundleDescription.toString()));
            }
            if (stateImpl.getBundle(bundleDescription.getBundleId()) == bundleDescription) {
                throw new IllegalStateException(NLS.bind(StateMsg.BUNDLE_IN_OTHER_STATE, bundleDescription.toString()));
            }
        }
        ((BundleDescriptionImpl)bundleDescription).setContainingState(this);
        ((BundleDescriptionImpl)bundleDescription).setStateBit(4, false);
        if (this.bundleDescriptions.add((BundleDescriptionImpl)bundleDescription)) {
            if (bundleDescription.getBundleId() > this.getHighestBundleId()) {
                this.highestBundleId = bundleDescription.getBundleId();
            }
            return true;
        }
        return false;
    }

    void addResolvedBundle(BundleDescriptionImpl bundleDescriptionImpl) {
        this.resolvedBundles.add(bundleDescriptionImpl);
    }

    public ExportPackageDescription[] getExportedPackages() {
        int n;
        ExportPackageDescription[] exportPackageDescriptionArray;
        BundleDescription bundleDescription;
        this.fullyLoad();
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>();
        Iterator iterator = this.resolvedBundles.iterator();
        while (iterator.hasNext()) {
            bundleDescription = (BundleDescription)iterator.next();
            exportPackageDescriptionArray = bundleDescription.getSelectedExports();
            if (exportPackageDescriptionArray == null) continue;
            n = 0;
            while (n < exportPackageDescriptionArray.length) {
                arrayList.add(exportPackageDescriptionArray[n]);
                ++n;
            }
        }
        iterator = this.removalPendings.iterator();
        while (iterator.hasNext()) {
            bundleDescription = (BundleDescription)iterator.next();
            exportPackageDescriptionArray = bundleDescription.getSelectedExports();
            if (exportPackageDescriptionArray == null) continue;
            n = 0;
            while (n < exportPackageDescriptionArray.length) {
                arrayList.add(exportPackageDescriptionArray[n]);
                ++n;
            }
        }
        return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
    }

    BundleDescription[] getFragments(BundleDescription bundleDescription) {
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>();
        Iterator iterator = this.bundleDescriptions.iterator();
        block0: while (iterator.hasNext()) {
            BundleDescription[] bundleDescriptionArray;
            BundleDescription bundleDescription2 = (BundleDescription)iterator.next();
            HostSpecification hostSpecification = bundleDescription2.getHost();
            if (hostSpecification == null || (bundleDescriptionArray = hostSpecification.getHosts()) == null) continue;
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                if (bundleDescriptionArray[n] == bundleDescription) {
                    arrayList.add(bundleDescription2);
                    continue block0;
                }
                ++n;
            }
        }
        return arrayList.toArray(new BundleDescription[arrayList.size()]);
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    private void updateTimeStamp() {
        if (this.getTimeStamp() == Long.MAX_VALUE) {
            this.setTimeStamp(0L);
        }
        this.setTimeStamp(this.getTimeStamp() + 1L);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    void setFactory(StateObjectFactory stateObjectFactory) {
        this.factory = stateObjectFactory;
    }

    public BundleDescription getBundleByLocation(String string) {
        Iterator iterator = this.bundleDescriptions.iterator();
        while (iterator.hasNext()) {
            BundleDescription bundleDescription = (BundleDescription)iterator.next();
            if (!string.equals(bundleDescription.getLocation())) continue;
            return bundleDescription;
        }
        return null;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        if (this.resolver == resolver) {
            return;
        }
        if (this.resolver != null) {
            Resolver resolver2 = this.resolver;
            this.resolver = null;
            resolver2.setState(null);
        }
        this.resolver = resolver;
        if (this.resolver == null) {
            return;
        }
        this.resolver.setState(this);
    }

    public boolean setPlatformProperties(Dictionary dictionary) {
        return this.setPlatformProperties(new Dictionary[]{dictionary});
    }

    public boolean setPlatformProperties(Dictionary[] dictionaryArray) {
        return this.setPlatformProperties(dictionaryArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean setPlatformProperties(Dictionary[] dictionaryArray, boolean bl) {
        Object object;
        if (dictionaryArray.length == 0) {
            throw new IllegalArgumentException();
        }
        Dictionary[] dictionaryArray2 = new Dictionary[dictionaryArray.length];
        int n = 0;
        while (n < dictionaryArray.length) {
            dictionaryArray2[n] = new Hashtable(dictionaryArray[n].size());
            Object object2 = dictionaryArray[n];
            synchronized (object2) {
                object = dictionaryArray[n].keys();
                while (object.hasMoreElements()) {
                    Object e = object.nextElement();
                    Object v = dictionaryArray[n].get(e);
                    dictionaryArray2[n].put(e, v);
                }
            }
            if (dictionaryArray2[n].get("org.osgi.framework.os.name") == null && dictionaryArray2[n].get(OSGI_OS) != null) {
                dictionaryArray2[n].put("org.osgi.framework.os.name", dictionaryArray2[n].get(OSGI_OS));
            }
            if (dictionaryArray2[n].get("org.osgi.framework.processor") == null && dictionaryArray2[n].get(OSGI_ARCH) != null) {
                dictionaryArray2[n].put("org.osgi.framework.processor", dictionaryArray2[n].get(OSGI_ARCH));
            }
            if (dictionaryArray2[n].get("org.osgi.framework.language") == null && dictionaryArray2[n].get(OSGI_NL) instanceof String) {
                object2 = (String)dictionaryArray2[n].get(OSGI_NL);
                int n2 = ((String)object2).indexOf(95);
                if (n2 >= 0) {
                    object2 = ((String)object2).substring(0, n2);
                }
                dictionaryArray2[n].put("org.osgi.framework.language", object2);
            }
            ++n;
        }
        n = 0;
        boolean bl2 = false;
        if (this.platformProperties.length != dictionaryArray2.length) {
            n = 1;
            bl2 = true;
        } else {
            object = this.getPlatformPropertyKeys();
            int n3 = 0;
            while (n3 < dictionaryArray2.length && n == 0) {
                n |= this.changedProps(this.platformProperties[n3], dictionaryArray2[n3], (String[])object);
                if (bl) {
                    bl2 |= this.checkProp(this.platformProperties[n3].get("org.osgi.framework.system.packages"), dictionaryArray2[n3].get("org.osgi.framework.system.packages"));
                    bl2 |= this.checkProp(this.platformProperties[n3].get("system.bundle"), dictionaryArray2[n3].get("system.bundle"));
                }
                ++n3;
            }
        }
        this.platformProperties = dictionaryArray2;
        if (bl2) {
            this.resetSystemExports();
        }
        return n != 0;
    }

    private void resetSystemExports() {
        BundleDescription[] bundleDescriptionArray = this.getBundles("system.bundle");
        if (bundleDescriptionArray.length > 0) {
            BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescriptionArray[0];
            ExportPackageDescription[] exportPackageDescriptionArray = bundleDescriptionImpl.getExportPackages();
            ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>(exportPackageDescriptionArray.length);
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                if ((Integer)exportPackageDescriptionArray[n].getDirective("x-equinox-ee") < 0) {
                    arrayList.add(exportPackageDescriptionArray[n]);
                }
                ++n;
            }
            this.addSystemExports(arrayList);
            bundleDescriptionImpl.setExportPackages(arrayList.toArray(new ExportPackageDescription[arrayList.size()]));
        }
    }

    private void addSystemExports(ArrayList arrayList) {
        int n = 0;
        while (n < this.platformProperties.length) {
            try {
                ManifestElement[] manifestElementArray = ManifestElement.parseHeader("Export-Package", (String)this.platformProperties[n].get("org.osgi.framework.system.packages"));
                if (manifestElementArray != null) {
                    ExportPackageDescription[] exportPackageDescriptionArray = StateBuilder.createExportPackages(manifestElementArray, null, null, 2, false);
                    Integer n2 = new Integer(n);
                    int n3 = 0;
                    while (n3 < exportPackageDescriptionArray.length) {
                        ((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n3]).setDirective("x-equinox-ee", n2);
                        arrayList.add(exportPackageDescriptionArray[n3]);
                        ++n3;
                    }
                }
            }
            catch (BundleException bundleException) {}
            ++n;
        }
    }

    public Dictionary[] getPlatformProperties() {
        return this.platformProperties;
    }

    private boolean checkProp(Object object, Object object2) {
        if (object == null && object2 != null || object != null && object2 == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != object2.getClass()) {
            return true;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            String[] stringArray2 = (String[])object2;
            if (stringArray.length != stringArray2.length) {
                return true;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].equals(stringArray2[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return !object.equals(object2);
    }

    private boolean changedProps(Dictionary dictionary, Dictionary dictionary2, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Object v;
            Object v2 = dictionary.get(stringArray[n]);
            if (this.checkProp(v2, v = dictionary2.get(stringArray[n]))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getSystemBundle() {
        String string = null;
        if (this.platformProperties != null && this.platformProperties.length > 0) {
            string = (String)this.platformProperties[0].get("osgi.system.bundle");
        }
        return string != null ? string : Constants.getInternalSymbolicName();
    }

    public BundleDescription[] getRemovalPendings() {
        return this.removalPendings.toArray(new BundleDescription[this.removalPendings.size()]);
    }

    public synchronized ExportPackageDescription linkDynamicImport(BundleDescription bundleDescription, String string) {
        if (this.resolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescription;
        if (bundleDescriptionImpl.getDynamicStamp(string) == this.getTimeStamp()) {
            return null;
        }
        try {
            this.resolving = true;
            this.fullyLoad();
            ExportPackageDescriptionImpl exportPackageDescriptionImpl = (ExportPackageDescriptionImpl)this.resolver.resolveDynamicImport(bundleDescription, string);
            if (exportPackageDescriptionImpl == null) {
                bundleDescriptionImpl.setDynamicStamp(string, new Long(this.getTimeStamp()));
            } else {
                bundleDescriptionImpl.setDynamicStamp(string, null);
                bundleDescriptionImpl.addDynamicResolvedImport(exportPackageDescriptionImpl);
            }
            this.setDynamicCacheChanged(true);
            ExportPackageDescriptionImpl exportPackageDescriptionImpl2 = exportPackageDescriptionImpl;
            Object var5_6 = null;
            this.resolving = false;
            return exportPackageDescriptionImpl2;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.resolving = false;
            throw throwable;
        }
    }

    void setReader(StateReader stateReader) {
        this.reader = stateReader;
    }

    StateReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyLoad() {
        if (this.reader == null) {
            return;
        }
        StateReader stateReader = this.reader;
        synchronized (stateReader) {
            if (this.fullyLoaded) {
                return;
            }
            if (this.reader.isLazyLoaded()) {
                this.reader.fullyLoad();
            }
            this.fullyLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadLazyData(long l) {
        StateReader stateReader = this.reader;
        synchronized (stateReader) {
            if (this.reader.getAccessedFlag()) {
                this.reader.setAccessedFlag(false);
                return;
            }
            this.fullyLoaded = false;
            BundleDescription[] bundleDescriptionArray = this.getBundles();
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                ((BundleDescriptionImpl)bundleDescriptionArray[n]).unload();
                ++n;
            }
        }
    }

    public ExportPackageDescription[] getSystemPackages() {
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>();
        BundleDescription[] bundleDescriptionArray = this.getBundles("system.bundle");
        if (bundleDescriptionArray.length > 0) {
            BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)bundleDescriptionArray[0];
            ExportPackageDescription[] exportPackageDescriptionArray = bundleDescriptionImpl.getExportPackages();
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                if ((Integer)exportPackageDescriptionArray[n].getDirective("x-equinox-ee") >= 0) {
                    arrayList.add(exportPackageDescriptionArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
    }

    boolean inStrictMode() {
        return "strict".equals(this.getPlatformProperties()[0].get("osgi.resolverMode"));
    }

    public synchronized ResolverError[] getResolverErrors(BundleDescription bundleDescription) {
        if (bundleDescription.isResolved()) {
            return new ResolverError[0];
        }
        ArrayList arrayList = (ArrayList)this.resolverErrors.get(bundleDescription);
        return arrayList == null ? new ResolverError[]{} : arrayList.toArray(new ResolverError[arrayList.size()]);
    }

    public synchronized void addResolverError(BundleDescription bundleDescription, int n, String string, VersionConstraint versionConstraint) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        ArrayList<ResolverErrorImpl> arrayList = (ArrayList<ResolverErrorImpl>)this.resolverErrors.get(bundleDescription);
        if (arrayList == null) {
            arrayList = new ArrayList<ResolverErrorImpl>(1);
            this.resolverErrors.put(bundleDescription, arrayList);
        }
        arrayList.add(new ResolverErrorImpl((BundleDescriptionImpl)bundleDescription, n, string, versionConstraint));
    }

    public synchronized void removeResolverErrors(BundleDescription bundleDescription) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        this.resolverErrors.remove(bundleDescription);
    }

    public boolean dynamicCacheChanged() {
        return this.dynamicCacheChanged;
    }

    void setDynamicCacheChanged(boolean bl) {
        this.dynamicCacheChanged = bl;
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPlatformPropertyKeys(String[] stringArray) {
        HashSet hashSet = this.platformPropertyKeys;
        synchronized (hashSet) {
            int n = 0;
            while (n < stringArray.length) {
                if (!this.platformPropertyKeys.contains(stringArray[n])) {
                    this.platformPropertyKeys.add(stringArray[n]);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPlatformPropertyKeys() {
        HashSet hashSet = this.platformPropertyKeys;
        synchronized (hashSet) {
            return this.platformPropertyKeys.toArray(new String[this.platformPropertyKeys.size()]);
        }
    }

    public long getHighestBundleId() {
        return this.highestBundleId;
    }

    public void setNativePathsInvalid(NativeCodeDescription nativeCodeDescription, boolean bl) {
        ((NativeCodeDescriptionImpl)nativeCodeDescription).setInvalidNativePaths(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDescription[] getDisabledBundles() {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            return this.disabledBundles.keySet().toArray(new BundleDescription[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisabledInfo(DisabledInfo disabledInfo) {
        if (this.getBundle(disabledInfo.getBundle().getBundleId()) != disabledInfo.getBundle()) {
            throw new IllegalArgumentException(NLS.bind(StateMsg.BUNDLE_NOT_IN_STATE, disabledInfo.getBundle()));
        }
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList<DisabledInfo> arrayList = (ArrayList<DisabledInfo>)this.disabledBundles.get(disabledInfo.getBundle());
            if (arrayList == null) {
                arrayList = new ArrayList<DisabledInfo>(1);
                arrayList.add(disabledInfo);
                this.disabledBundles.put(disabledInfo.getBundle(), arrayList);
            } else {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    DisabledInfo disabledInfo2 = (DisabledInfo)iterator.next();
                    if (!disabledInfo.getPolicyName().equals(disabledInfo2.getPolicyName())) continue;
                    arrayList.remove(disabledInfo2);
                    break;
                }
                arrayList.add(disabledInfo);
            }
        }
        this.updateTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisabledInfo(DisabledInfo disabledInfo) {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)this.disabledBundles.get(disabledInfo.getBundle());
            if (arrayList != null && arrayList.contains(disabledInfo)) {
                arrayList.remove(disabledInfo);
                if (arrayList.isEmpty()) {
                    this.disabledBundles.remove(disabledInfo.getBundle());
                }
            }
        }
        this.updateTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisabledInfo getDisabledInfo(BundleDescription bundleDescription, String string) {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList arrayList;
            block5: {
                arrayList = (ArrayList)this.disabledBundles.get(bundleDescription);
                if (arrayList != null) break block5;
                return null;
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DisabledInfo disabledInfo = (DisabledInfo)iterator.next();
                if (!disabledInfo.getPolicyName().equals(string)) continue;
                return disabledInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisabledInfo[] getDisabledInfos(BundleDescription bundleDescription) {
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)this.disabledBundles.get(bundleDescription);
            return arrayList == null ? EMPTY_DISABLEDINFOS : arrayList.toArray(new DisabledInfo[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisabledInfo[] getDisabledInfos() {
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.disabledBundles;
        synchronized (hashMap) {
            Iterator iterator = this.disabledBundles.values().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll((Collection)iterator.next());
            }
        }
        return arrayList.toArray(new DisabledInfo[arrayList.size()]);
    }
}

