/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.jobs.ImplicitJobs;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobChangeEvent;
import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.internal.jobs.JobOSGiUtils;
import org.eclipse.core.internal.jobs.JobQueue;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.jobs.WorkerPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.osgi.util.NLS;

public class JobManager
implements IJobManager {
    public static final String PI_JOBS = "org.eclipse.core.jobs";
    public static final int PLUGIN_ERROR = 2;
    private static final String OPTION_DEADLOCK_ERROR = "org.eclipse.core.jobs/jobs/errorondeadlock";
    private static final String OPTION_DEBUG_BEGIN_END = "org.eclipse.core.jobs/jobs/beginend";
    private static final String OPTION_DEBUG_JOBS = "org.eclipse.core.jobs/jobs";
    private static final String OPTION_DEBUG_JOBS_TIMING = "org.eclipse.core.jobs/jobs/timing";
    private static final String OPTION_LOCKS = "org.eclipse.core.jobs/jobs/locks";
    private static final String OPTION_SHUTDOWN = "org.eclipse.core.jobs/jobs/shutdown";
    static boolean DEBUG = false;
    static boolean DEBUG_BEGIN_END = false;
    static boolean DEBUG_DEADLOCK = false;
    static boolean DEBUG_LOCKS = false;
    static boolean DEBUG_TIMING = false;
    static boolean DEBUG_SHUTDOWN = false;
    private static DateFormat DEBUG_FORMAT;
    private static JobManager instance;
    private static final ISchedulingRule nullRule;
    private volatile boolean active = true;
    final ImplicitJobs implicitJobs = new ImplicitJobs(this);
    private final JobListeners jobListeners = new JobListeners();
    private final Object lock = new Object();
    private final LockManager lockManager = new LockManager();
    private WorkerPool pool;
    private ProgressProvider progressProvider = null;
    private final HashSet running;
    private final JobQueue sleeping;
    private boolean suspended = false;
    private final JobQueue waiting;
    private long waitQueueCounter;

    static {
        nullRule = new ISchedulingRule(){

            public boolean contains(ISchedulingRule iSchedulingRule) {
                return iSchedulingRule == this;
            }

            public boolean isConflicting(ISchedulingRule iSchedulingRule) {
                return iSchedulingRule == this;
            }
        };
    }

    public static void debug(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 40);
        if (DEBUG_TIMING) {
            if (DEBUG_FORMAT == null) {
                DEBUG_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
            }
            DEBUG_FORMAT.format(new Date(), stringBuffer, new FieldPosition(0));
            stringBuffer.append('-');
        }
        stringBuffer.append('[').append(Thread.currentThread()).append(']').append(string);
        System.out.println(stringBuffer.toString());
    }

    static synchronized JobManager getInstance() {
        if (instance == null) {
            new JobManager();
        }
        return instance;
    }

    private static String printJobName(Job job) {
        if (job instanceof ThreadJob) {
            Job job2 = ((ThreadJob)job).realJob;
            if (job2 != null) {
                return job2.getClass().getName();
            }
            return "ThreadJob on rule: " + job.getRule();
        }
        return job.getClass().getName();
    }

    public static String printState(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "WAITING";
            }
            case 1: {
                return "SLEEPING";
            }
            case 4: {
                return "RUNNING";
            }
            case 8: {
                return "BLOCKED";
            }
            case 16: {
                return "ABOUT_TO_RUN";
            }
            case 32: {
                return "ABOUT_TO_SCHEDULE";
            }
        }
        return "UNKNOWN";
    }

    public static void shutdown() {
        if (instance != null) {
            instance.doShutdown();
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobManager() {
        instance = this;
        this.initDebugOptions();
        Object object = this.lock;
        synchronized (object) {
            this.waiting = new JobQueue(false);
            this.sleeping = new JobQueue(true);
            this.running = new HashSet(10);
            this.pool = new WorkerPool(this);
        }
        this.pool.setDaemon(JobOSGiUtils.getDefault().useDaemonThreads());
    }

    public void addJobChangeListener(IJobChangeListener iJobChangeListener) {
        this.jobListeners.add(iJobChangeListener);
    }

    public void beginRule(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) {
        this.validateRule(iSchedulingRule);
        this.implicitJobs.begin(iSchedulingRule, this.monitorFor(iProgressMonitor), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean cancel(InternalJob internalJob) {
        IProgressMonitor iProgressMonitor = null;
        Object object = this.lock;
        synchronized (object) {
            switch (internalJob.getState()) {
                case 0: {
                    return true;
                }
                case 4: {
                    if (internalJob.internalGetState() != 4) {
                        internalJob.setAboutToRunCanceled(true);
                        return true;
                    }
                    iProgressMonitor = internalJob.getProgressMonitor();
                    break;
                }
                default: {
                    this.changeState(internalJob, 0);
                }
            }
        }
        if (iProgressMonitor == null) {
            this.jobListeners.done((Job)internalJob, Status.CANCEL_STATUS, false);
            return true;
        }
        if (!iProgressMonitor.isCanceled()) {
            iProgressMonitor.setCanceled(true);
            internalJob.canceling();
        }
        return false;
    }

    public void cancel(Object object) {
        Iterator iterator = this.select(object).iterator();
        while (iterator.hasNext()) {
            this.cancel((Job)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(InternalJob internalJob, int n) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            int n2 = internalJob.internalGetState();
            switch (n2) {
                case 0: 
                case 32: {
                    break;
                }
                case 8: {
                    internalJob.remove();
                    break;
                }
                case 2: {
                    try {
                        this.waiting.remove(internalJob);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal((boolean)false, (String)"Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 1: {
                    try {
                        this.sleeping.remove(internalJob);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal((boolean)false, (String)"Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 4: 
                case 16: {
                    this.running.remove(internalJob);
                    InternalJob internalJob2 = internalJob.previous();
                    internalJob.remove();
                    bl = internalJob2 != null;
                    while (internalJob2 != null) {
                        InternalJob internalJob3 = internalJob2.previous();
                        this.changeState(internalJob2, 2);
                        internalJob2 = internalJob3;
                    }
                    break;
                }
                default: {
                    Assert.isLegal((boolean)false, (String)("Invalid job state: " + internalJob + ", state: " + n2));
                }
            }
            internalJob.internalSetState(n);
            switch (n) {
                case 0: {
                    internalJob.setStartTime(-1L);
                    internalJob.setWaitQueueStamp(-1L);
                }
                case 8: {
                    break;
                }
                case 2: {
                    this.waiting.enqueue(internalJob);
                    break;
                }
                case 1: {
                    try {
                        this.sleeping.enqueue(internalJob);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        throw new RuntimeException("Error changing from state: " + n2);
                    }
                }
                case 4: 
                case 16: {
                    internalJob.setStartTime(-1L);
                    internalJob.setWaitQueueStamp(-1L);
                    this.running.add(internalJob);
                    break;
                }
                case 32: {
                    break;
                }
                default: {
                    Assert.isLegal((boolean)false, (String)("Invalid job state: " + internalJob + ", state: " + n));
                }
            }
        }
        if (bl) {
            this.pool.jobQueued();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProgressMonitor createMonitor(InternalJob internalJob, IProgressMonitor iProgressMonitor, int n) {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                if (internalJob.getState() == 0) break block6;
                return null;
            }
            NullProgressMonitor nullProgressMonitor = null;
            if (this.progressProvider != null) {
                nullProgressMonitor = this.progressProvider.createMonitor((Job)internalJob, iProgressMonitor, n);
            }
            if (nullProgressMonitor == null) {
                nullProgressMonitor = new NullProgressMonitor();
            }
            return nullProgressMonitor;
        }
    }

    private IProgressMonitor createMonitor(Job job) {
        IProgressMonitor iProgressMonitor = null;
        if (this.progressProvider != null) {
            iProgressMonitor = this.progressProvider.createMonitor(job);
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        return iProgressMonitor;
    }

    public IProgressMonitor createProgressGroup() {
        if (this.progressProvider != null) {
            return this.progressProvider.createProgressGroup();
        }
        return new NullProgressMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job currentJob() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Worker) {
            return ((Worker)thread).currentJob();
        }
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.running.iterator();
            while (iterator.hasNext()) {
                Job job = (Job)iterator.next();
                if (job.getThread() != thread) continue;
                return job;
            }
        }
        return null;
    }

    private long delayFor(int n) {
        switch (n) {
            case 10: {
                return 0L;
            }
            case 20: {
                return 50L;
            }
            case 30: {
                return 100L;
            }
            case 40: {
                return 500L;
            }
            case 50: {
                return 1000L;
            }
        }
        Assert.isTrue((boolean)false, (String)("Job has invalid priority: " + n));
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSchedule(InternalJob internalJob, long l) {
        Object object = this.lock;
        synchronized (object) {
            if (internalJob.getPriority() == 50 && internalJob.getRule() == null) {
                long l2 = this.running.size() * 100;
                l = Math.max(l, l2);
            }
            if (l > 0L) {
                internalJob.setStartTime(System.currentTimeMillis() + l);
                this.changeState(internalJob, 1);
            } else {
                internalJob.setStartTime(System.currentTimeMillis() + this.delayFor(internalJob.getPriority()));
                internalJob.setWaitQueueStamp(this.waitQueueCounter++);
                this.changeState(internalJob, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() {
        Job[] jobArray;
        Job[] jobArray2 = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                jobArray2 = this.running.toArray(new Job[this.running.size()]);
                this.sleeping.clear();
                this.waiting.clear();
                this.running.clear();
            }
        }
        if (jobArray2 != null && jobArray2.length > 0) {
            int n = 0;
            while (n < jobArray2.length) {
                this.cancel(jobArray2[n]);
                ++n;
            }
            n = 0;
            while (n < 3) {
                Thread.yield();
                jobArray = this.lock;
                synchronized (jobArray) {
                    if (this.running.isEmpty()) {
                        break;
                    }
                }
                if (DEBUG_SHUTDOWN) {
                    JobManager.debug("Shutdown - job wait cycle #" + (n + 1));
                    jobArray = null;
                    Object object2 = this.lock;
                    synchronized (object2) {
                        jobArray = this.running.toArray(new Job[this.running.size()]);
                    }
                    if (jobArray != null) {
                        int n2 = 0;
                        while (n2 < jobArray.length) {
                            JobManager.debug("\tJob: " + JobManager.printJobName(jobArray[n2]));
                            ++n2;
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                Thread.yield();
                ++n;
            }
            object = this.lock;
            synchronized (object) {
                jobArray2 = this.running.toArray(new Job[this.running.size()]);
            }
        }
        if (jobArray2 != null) {
            int n = 0;
            while (n < jobArray2.length) {
                jobArray = JobManager.printJobName(jobArray2[n]);
                String string = "Job found still running after platform shutdown.  Jobs should be canceled by the plugin that scheduled them during shutdown: " + (String)jobArray;
                RuntimeLog.log((IStatus)new Status(2, PI_JOBS, 2, string, null));
                System.err.println(string);
                ++n;
            }
        }
        this.pool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endJob(InternalJob internalJob, IStatus iStatus, boolean bl) {
        boolean bl2;
        long l = -1L;
        Object object = this.lock;
        synchronized (object) {
            if (iStatus == Job.ASYNC_FINISH) {
                return;
            }
            if (internalJob.getState() == 0) {
                return;
            }
            if (DEBUG && bl) {
                JobManager.debug("Ending job: " + internalJob);
            }
            internalJob.setResult(iStatus);
            internalJob.setProgressMonitor(null);
            internalJob.setThread(null);
            l = internalJob.getStartTime();
            this.changeState(internalJob, 0);
        }
        boolean bl3 = bl2 = this.active && l > -1L && internalJob.shouldSchedule();
        if (bl) {
            this.jobListeners.done((Job)internalJob, iStatus, bl2);
        }
        if (bl2) {
            this.schedule(internalJob, l, bl2);
        }
    }

    public void endRule(ISchedulingRule iSchedulingRule) {
        this.implicitJobs.end(iSchedulingRule, false);
    }

    public Job[] find(Object object) {
        List list = this.select(object);
        return list.toArray(new Job[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalJob findBlockingJob(InternalJob internalJob) {
        if (internalJob.getRule() == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            InternalJob internalJob2;
            Iterator iterator;
            block11: {
                block10: {
                    if (!this.running.isEmpty()) break block10;
                    return null;
                }
                boolean bl = false;
                iterator = this.running.iterator();
                while (iterator.hasNext()) {
                    internalJob2 = (InternalJob)iterator.next();
                    if (internalJob.isConflicting(internalJob2)) {
                        return internalJob2;
                    }
                    if (bl) continue;
                    boolean bl2 = bl = internalJob2.previous() != null;
                }
                if (bl) break block11;
                return null;
            }
            iterator = this.running.iterator();
            while (iterator.hasNext()) {
                internalJob2 = (InternalJob)iterator.next();
                while ((internalJob2 = internalJob2.previous()) != null) {
                    if (!internalJob.isConflicting(internalJob2)) continue;
                    return internalJob2;
                }
            }
        }
        return null;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    private void initDebugOptions() {
        DEBUG = JobOSGiUtils.getDefault().getBooleanDebugOption(OPTION_DEBUG_JOBS, false);
        DEBUG_BEGIN_END = JobOSGiUtils.getDefault().getBooleanDebugOption(OPTION_DEBUG_BEGIN_END, false);
        DEBUG_DEADLOCK = JobOSGiUtils.getDefault().getBooleanDebugOption(OPTION_DEADLOCK_ERROR, false);
        DEBUG_LOCKS = JobOSGiUtils.getDefault().getBooleanDebugOption(OPTION_LOCKS, false);
        DEBUG_TIMING = JobOSGiUtils.getDefault().getBooleanDebugOption(OPTION_DEBUG_JOBS_TIMING, false);
        DEBUG_SHUTDOWN = JobOSGiUtils.getDefault().getBooleanDebugOption(OPTION_SHUTDOWN, false);
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isBlocking(InternalJob internalJob) {
        Object object = this.lock;
        synchronized (object) {
            if (internalJob.getState() != 4) {
                return false;
            }
            InternalJob internalJob2 = internalJob.previous();
            while (true) {
                if (internalJob2 == null) {
                    return false;
                }
                if (internalJob2.getPriority() < internalJob.getPriority()) {
                    if (!internalJob2.isSystem()) {
                        return true;
                    }
                    if (internalJob2 instanceof ThreadJob && ((ThreadJob)internalJob2).shouldInterrupt()) {
                        return true;
                    }
                }
                internalJob2 = internalJob2.previous();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Object object = this.lock;
        synchronized (object) {
            return this.running.isEmpty() && this.waiting.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        Object object = this.lock;
        synchronized (object) {
            return this.suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void join(InternalJob internalJob) {
        JobChangeAdapter jobChangeAdapter;
        Semaphore semaphore;
        Object object = this.lock;
        synchronized (object) {
            int n = internalJob.getState();
            if (n == 0) {
                return;
            }
            if (this.suspended && n != 4) {
                return;
            }
            if (n == 4 && internalJob.getThread() == Thread.currentThread()) {
                throw new IllegalStateException("Job attempted to join itself");
            }
            semaphore = new Semaphore(null);
            jobChangeAdapter = new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    semaphore.release();
                }
            };
            internalJob.addJobChangeListener(jobChangeAdapter);
        }
        try {
            while (true) {
                this.lockManager.aboutToWait(internalJob.getThread());
                try {
                    if (!semaphore.acquire(Long.MAX_VALUE)) continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            object = null;
            this.lockManager.aboutToRelease();
            internalJob.removeJobChangeListener(jobChangeAdapter);
            throw throwable;
        }
        {
            object = null;
            this.lockManager.aboutToRelease();
            internalJob.removeJobChangeListener(jobChangeAdapter);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void join(final Object object, IProgressMonitor iProgressMonitor) throws InterruptedException, OperationCanceledException {
        int n;
        Set set;
        int n2;
        iProgressMonitor = this.monitorFor(iProgressMonitor);
        JobChangeAdapter jobChangeAdapter = null;
        Job job = null;
        Object object2 = this.lock;
        synchronized (object2) {
            n2 = this.suspended ? 4 : 7;
            set = Collections.synchronizedSet(new HashSet(this.select(object, n2)));
            n = set.size();
            if (n > 0) {
                if (n == 1) {
                    job = (Job)set.iterator().next();
                }
                jobChangeAdapter = new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        if (!((JobChangeEvent)iJobChangeEvent).reschedule) {
                            set.remove(iJobChangeEvent.getJob());
                        }
                    }

                    public void scheduled(IJobChangeEvent iJobChangeEvent) {
                        if (((JobChangeEvent)iJobChangeEvent).reschedule) {
                            return;
                        }
                        Job job = iJobChangeEvent.getJob();
                        if (job.belongsTo(object)) {
                            set.add(job);
                        }
                    }
                };
                this.addJobChangeListener(jobChangeAdapter);
            }
        }
        if (n == 0) {
            iProgressMonitor.beginTask(JobMessages.jobs_blocked0, 1);
            iProgressMonitor.done();
            return;
        }
        try {
            int n3;
            iProgressMonitor.beginTask(JobMessages.jobs_blocked0, n);
            iProgressMonitor.subTask(NLS.bind((String)JobMessages.jobs_waitFamSub, (Object)Integer.toString(n)));
            this.reportBlocked(iProgressMonitor, job);
            n2 = 0;
            while ((n3 = set.size()) > 0) {
                int n4 = Math.max(0, n - n3);
                if (n2 < n4) {
                    iProgressMonitor.worked(n4 - n2);
                    n2 = n4;
                    iProgressMonitor.subTask(NLS.bind((String)JobMessages.jobs_waitFamSub, (Object)Integer.toString(n3)));
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.lockManager.aboutToWait(null);
                Thread.sleep(100L);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.lockManager.aboutToRelease();
            this.removeJobChangeListener(jobChangeAdapter);
            this.reportUnblocked(iProgressMonitor);
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.lockManager.aboutToRelease();
            this.removeJobChangeListener(jobChangeAdapter);
            this.reportUnblocked(iProgressMonitor);
        }
        iProgressMonitor.done();
    }

    private IProgressMonitor monitorFor(IProgressMonitor iProgressMonitor) {
        if ((iProgressMonitor == null || iProgressMonitor instanceof NullProgressMonitor) && this.progressProvider != null) {
            try {
                iProgressMonitor = this.progressProvider.getDefaultMonitor();
            }
            catch (Exception exception) {
                String string = NLS.bind((String)JobMessages.meta_pluginProblems, (Object)PI_JOBS);
                RuntimeLog.log((IStatus)new Status(4, PI_JOBS, 2, string, (Throwable)exception));
            }
        }
        if (iProgressMonitor == null) {
            return new NullProgressMonitor();
        }
        return iProgressMonitor;
    }

    public ILock newLock() {
        return this.lockManager.newLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job nextJob() {
        Object object = this.lock;
        synchronized (object) {
            block8: {
                if (!this.suspended) break block8;
                return null;
            }
            long l = System.currentTimeMillis();
            InternalJob internalJob = this.sleeping.peek();
            while (internalJob != null && internalJob.getStartTime() < l) {
                internalJob.setStartTime(l + this.delayFor(internalJob.getPriority()));
                internalJob.setWaitQueueStamp(this.waitQueueCounter++);
                this.changeState(internalJob, 2);
                internalJob = this.sleeping.peek();
            }
            while ((internalJob = this.waiting.peek()) != null) {
                InternalJob internalJob2 = this.findBlockingJob(internalJob);
                if (internalJob2 == null) break;
                this.changeState(internalJob, 8);
                Assert.isTrue((internalJob.next() == null ? 1 : 0) != 0);
                Assert.isTrue((internalJob.previous() == null ? 1 : 0) != 0);
                internalJob2.addLast(internalJob);
            }
            if (internalJob != null) {
                this.changeState(internalJob, 16);
                if (DEBUG) {
                    JobManager.debug("Starting job: " + internalJob);
                }
            }
            return (Job)internalJob;
        }
    }

    public void removeJobChangeListener(IJobChangeListener iJobChangeListener) {
        this.jobListeners.remove(iJobChangeListener);
    }

    final void reportBlocked(IProgressMonitor iProgressMonitor, InternalJob internalJob) {
        Status status;
        if (!(iProgressMonitor instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        if (internalJob == null || internalJob instanceof ThreadJob || internalJob.isSystem()) {
            status = new Status(1, PI_JOBS, 1, JobMessages.jobs_blocked0, null);
        } else {
            String string = NLS.bind((String)JobMessages.jobs_blocked1, (Object)internalJob.getName());
            status = new JobStatus(1, (Job)internalJob, string);
        }
        ((IProgressMonitorWithBlocking)iProgressMonitor).setBlocked((IStatus)status);
    }

    final void reportUnblocked(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor instanceof IProgressMonitorWithBlocking) {
            ((IProgressMonitorWithBlocking)iProgressMonitor).clearBlocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.suspended = false;
            this.pool.jobQueued();
        }
    }

    public final void resume(ISchedulingRule iSchedulingRule) {
        this.implicitJobs.resume(iSchedulingRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runNow(InternalJob internalJob) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.findBlockingJob(internalJob) == null) break block4;
                return false;
            }
            this.changeState(internalJob, 4);
            internalJob.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            internalJob.run(null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(InternalJob internalJob, long l, boolean bl) {
        if (!this.active) {
            throw new IllegalStateException("Job manager has been shut down.");
        }
        Assert.isNotNull((Object)internalJob, (String)"Job is null");
        Assert.isLegal((l >= 0L ? 1 : 0) != 0, (String)"Scheduling delay is negative");
        Object object = this.lock;
        synchronized (object) {
            if (internalJob.getState() == 4) {
                internalJob.setStartTime(l);
                return;
            }
            if (internalJob.internalGetState() != 0) {
                return;
            }
            if (DEBUG) {
                JobManager.debug("Scheduling job: " + internalJob);
            }
            this.changeState(internalJob, 32);
        }
        this.jobListeners.scheduled((Job)internalJob, l, bl);
        this.doSchedule(internalJob, l);
        this.pool.jobQueued();
    }

    private void select(List list, Object object, InternalJob internalJob, int n) {
        if (internalJob == null) {
            return;
        }
        InternalJob internalJob2 = internalJob;
        do {
            if (object != null && !internalJob2.belongsTo(object) || (internalJob2.getState() & n) == 0) continue;
            list.add(internalJob2);
        } while ((internalJob2 = internalJob2.previous()) != null && internalJob2 != internalJob);
    }

    private List select(Object object) {
        return this.select(object, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List select(Object object, int n) {
        ArrayList arrayList = new ArrayList();
        Object object2 = this.lock;
        synchronized (object2) {
            if ((n & 4) != 0) {
                Iterator iterator = this.running.iterator();
                while (iterator.hasNext()) {
                    this.select(arrayList, object, (InternalJob)iterator.next(), n);
                }
            }
            if ((n & 2) != 0) {
                this.select(arrayList, object, this.waiting.peek(), n);
            }
            if ((n & 1) != 0) {
                this.select(arrayList, object, this.sleeping.peek(), n);
            }
        }
        return arrayList;
    }

    public void setLockListener(LockListener lockListener) {
        this.lockManager.setLockListener(lockListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPriority(InternalJob internalJob, int n) {
        Object object = this.lock;
        synchronized (object) {
            int n2 = internalJob.getPriority();
            if (n2 == n) {
                return;
            }
            internalJob.internalSetPriority(n);
            if (internalJob.getState() == 2) {
                long l = internalJob.getStartTime();
                internalJob.setStartTime(l + (this.delayFor(n) - this.delayFor(n2)));
                this.waiting.resort(internalJob);
            }
        }
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRule(InternalJob internalJob, ISchedulingRule iSchedulingRule) {
        Object object = this.lock;
        synchronized (object) {
            Assert.isLegal((internalJob.getState() == 0 ? 1 : 0) != 0);
            this.validateRule(iSchedulingRule);
            internalJob.internalSetRule(iSchedulingRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sleep(InternalJob internalJob) {
        Object object = this.lock;
        synchronized (object) {
            switch (internalJob.getState()) {
                case 4: {
                    if (internalJob.internalGetState() != 4) break;
                    return false;
                }
                case 1: {
                    internalJob.setStartTime(Long.MAX_VALUE);
                    this.changeState(internalJob, 1);
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            internalJob.setStartTime(Long.MAX_VALUE);
            this.changeState(internalJob, 1);
        }
        this.jobListeners.sleeping((Job)internalJob);
        return true;
    }

    public void sleep(Object object) {
        Iterator iterator = this.select(object).iterator();
        while (iterator.hasNext()) {
            this.sleep((InternalJob)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sleepHint() {
        Object object = this.lock;
        synchronized (object) {
            InternalJob internalJob;
            block8: {
                block7: {
                    block6: {
                        if (!this.suspended) break block6;
                        return Long.MAX_VALUE;
                    }
                    if (this.waiting.isEmpty()) break block7;
                    return 0L;
                }
                internalJob = this.sleeping.peek();
                if (internalJob != null) break block8;
                return Long.MAX_VALUE;
            }
            return internalJob.getStartTime() - System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Job startJob() {
        Job job = null;
        while (true) {
            if ((job = this.nextJob()) == null) {
                return null;
            }
            if (job.shouldRun()) {
                this.jobListeners.aboutToRun(job);
                Object object = this.lock;
                synchronized (object) {
                    if (job.getState() == 4) {
                        Job job2 = job;
                        if (job2.isAboutToRunCanceled()) {
                            job2.setAboutToRunCanceled(false);
                        } else {
                            job2.setProgressMonitor(this.createMonitor(job));
                            job2.internalSetState(4);
                            break;
                        }
                    }
                }
            }
            if (job.getState() == 1) continue;
            this.endJob(job, Status.CANCEL_STATUS, true);
        }
        this.jobListeners.running(job);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        Object object = this.lock;
        synchronized (object) {
            this.suspended = true;
        }
    }

    public final void suspend(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) {
        Assert.isNotNull((Object)iSchedulingRule);
        this.implicitJobs.suspend(iSchedulingRule, this.monitorFor(iProgressMonitor));
    }

    public void transferRule(ISchedulingRule iSchedulingRule, Thread thread) {
        this.implicitJobs.transfer(iSchedulingRule, thread);
    }

    private void validateRule(ISchedulingRule iSchedulingRule) {
        if (iSchedulingRule == null) {
            return;
        }
        Assert.isLegal((boolean)iSchedulingRule.contains(iSchedulingRule));
        Assert.isLegal((!iSchedulingRule.contains(nullRule) ? 1 : 0) != 0);
        Assert.isLegal((boolean)iSchedulingRule.isConflicting(iSchedulingRule));
        Assert.isLegal((!iSchedulingRule.isConflicting(nullRule) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeUp(InternalJob internalJob, long l) {
        Assert.isLegal((l >= 0L ? 1 : 0) != 0, (String)"Scheduling delay is negative");
        Object object = this.lock;
        synchronized (object) {
            if (internalJob.getState() != 1) {
                return;
            }
            this.doSchedule(internalJob, l);
        }
        this.pool.jobQueued();
        if (l == 0L) {
            this.jobListeners.awake((Job)internalJob);
        }
    }

    public void wakeUp(Object object) {
        Iterator iterator = this.select(object).iterator();
        while (iterator.hasNext()) {
            this.wakeUp((InternalJob)iterator.next(), 0L);
        }
    }
}

