/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.internal.commands.util.Util;

public final class ParameterizedCommand
implements Comparable {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    public static final int INDEX_PARAMETER_ID = 0;
    public static final int INDEX_PARAMETER_NAME = 1;
    public static final int INDEX_PARAMETER_VALUE_NAME = 2;
    public static final int INDEX_PARAMETER_VALUE_VALUE = 3;
    private final Command command;
    private transient int hashCode = -1;
    private final Parameterization[] parameterizations;
    private String name;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.ParameterizedCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    private static final String escape(String string) {
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '%': 
                case '(': 
                case ')': 
                case ',': 
                case '=': {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.substring(0, n));
                    }
                    stringBuffer.append('%');
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    private static final Collection expandParameters(int n, IParameter[] iParameterArray) {
        Object object;
        int n2 = n + 1;
        boolean bl = n2 >= iParameterArray.length;
        IParameter iParameter = iParameterArray[n];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iParameter.isOptional()) {
            arrayList.add(null);
        }
        IParameterValues iParameterValues = null;
        try {
            iParameterValues = iParameter.getValues();
        }
        catch (ParameterValuesException parameterValuesException) {
            if (bl) {
                return arrayList;
            }
            return ParameterizedCommand.expandParameters(n2, iParameterArray);
        }
        Map map = iParameterValues.getParameterValues();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            object = new Parameterization(iParameter, (String)entry.getValue());
            arrayList.add(object);
        }
        int n3 = arrayList.size();
        if (bl) {
            int n4 = 0;
            while (n4 < n3) {
                Parameterization parameterization = (Parameterization)arrayList.get(n4);
                ArrayList<Parameterization> arrayList2 = new ArrayList<Parameterization>(1);
                arrayList2.add(parameterization);
                arrayList.set(n4, arrayList2);
                ++n4;
            }
            return arrayList;
        }
        object = ParameterizedCommand.expandParameters(n2, iParameterArray);
        while (object.remove(null)) {
        }
        if (object.isEmpty()) {
            int n5 = 0;
            while (n5 < n3) {
                Parameterization parameterization = (Parameterization)arrayList.get(n5);
                ArrayList<Parameterization> arrayList3 = new ArrayList<Parameterization>(1);
                arrayList3.add(parameterization);
                arrayList.set(n5, arrayList3);
                ++n5;
            }
            return arrayList;
        }
        ArrayList arrayList4 = new ArrayList();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            List list = (List)iterator2.next();
            int n6 = list.size();
            int n7 = 0;
            while (n7 < n3) {
                Parameterization parameterization = (Parameterization)arrayList.get(n7);
                ArrayList<Parameterization> arrayList5 = new ArrayList<Parameterization>(n6 + 1);
                arrayList5.add(parameterization);
                arrayList5.addAll(list);
                arrayList4.add(arrayList5);
                ++n7;
            }
        }
        return arrayList4;
    }

    public static final Collection generateCombinations(Command command) throws NotDefinedException {
        IParameter[] iParameterArray = command.getParameters();
        if (iParameterArray == null) {
            return Collections.singleton(new ParameterizedCommand(command, null));
        }
        Collection collection = ParameterizedCommand.expandParameters(0, iParameterArray);
        ArrayList<ParameterizedCommand> arrayList = new ArrayList<ParameterizedCommand>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            if (list == null) {
                arrayList.add(new ParameterizedCommand(command, null));
                continue;
            }
            while (list.remove(null)) {
            }
            if (list.isEmpty()) {
                arrayList.add(new ParameterizedCommand(command, null));
                continue;
            }
            Parameterization[] parameterizationArray = list.toArray(new Parameterization[list.size()]);
            arrayList.add(new ParameterizedCommand(command, parameterizationArray));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final ParameterizedCommand generateCommand(Command command, Map map) {
        if (map == null) return new ParameterizedCommand(command, null);
        if (map.isEmpty()) {
            return new ParameterizedCommand(command, null);
        }
        try {
            ArrayList<Parameterization> arrayList = new ArrayList<Parameterization>();
            Iterator iterator = map.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return new ParameterizedCommand(command, arrayList.toArray(new Parameterization[arrayList.size()]));
                }
                String string = (String)iterator.next();
                IParameter iParameter = null;
                iParameter = command.getParameter(string);
                if (iParameter == null) {
                    return null;
                }
                ParameterType parameterType = command.getParameterType(string);
                if (parameterType == null) {
                    arrayList.add(new Parameterization(iParameter, (String)map.get(string)));
                    continue;
                }
                AbstractParameterValueConverter abstractParameterValueConverter = parameterType.getValueConverter();
                if (abstractParameterValueConverter != null) {
                    String string2 = abstractParameterValueConverter.convertToString(map.get(string));
                    arrayList.add(new Parameterization(iParameter, string2));
                    continue;
                }
                arrayList.add(new Parameterization(iParameter, (String)map.get(string)));
            }
        }
        catch (NotDefinedException notDefinedException) {
            return null;
        }
        catch (ParameterValueConversionException parameterValueConversionException) {}
        return null;
    }

    public ParameterizedCommand(Command command, Parameterization[] parameterizationArray) {
        if (command == null) {
            throw new NullPointerException("A parameterized command cannot have a null command");
        }
        this.command = command;
        IParameter[] iParameterArray = null;
        try {
            iParameterArray = command.getParameters();
        }
        catch (NotDefinedException notDefinedException) {}
        if (parameterizationArray != null && parameterizationArray.length > 0 && iParameterArray != null) {
            int n = 0;
            Parameterization[] parameterizationArray2 = new Parameterization[parameterizationArray.length];
            int n2 = 0;
            while (n2 < iParameterArray.length) {
                int n3 = 0;
                while (n3 < parameterizationArray.length) {
                    Parameterization parameterization = parameterizationArray[n3];
                    if (iParameterArray[n2].equals(parameterization.getParameter())) {
                        parameterizationArray2[n++] = parameterization;
                    }
                    ++n3;
                }
                ++n2;
            }
            this.parameterizations = parameterizationArray2;
        } else {
            this.parameterizations = null;
        }
    }

    public final int compareTo(Object object) {
        ParameterizedCommand parameterizedCommand = (ParameterizedCommand)object;
        boolean bl = this.command.isDefined();
        boolean bl2 = parameterizedCommand.command.isDefined();
        if (!bl || !bl2) {
            return Util.compare(bl, bl2);
        }
        try {
            int n = this.getName().compareTo(parameterizedCommand.getName());
            if (n == 0) {
                return this.getId().compareTo(parameterizedCommand.getId());
            }
            return n;
        }
        catch (NotDefinedException notDefinedException) {
            throw new Error("Concurrent modification of a command's defined state");
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParameterizedCommand)) {
            return false;
        }
        ParameterizedCommand parameterizedCommand = (ParameterizedCommand)object;
        if (!Util.equals(this.command, parameterizedCommand.command)) {
            return false;
        }
        return Util.equals(this.parameterizations, parameterizedCommand.parameterizations);
    }

    public final Object execute(Object object, Object object2) throws ExecutionException, NotHandledException {
        return this.command.execute(new ExecutionEvent(this.command, this.getParameterMap(), object, object2));
    }

    public final Object executeWithChecks(Object object, Object object2) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return this.command.executeWithChecks(new ExecutionEvent(this.command, this.getParameterMap(), object, object2));
    }

    public final Command getCommand() {
        return this.command;
    }

    public final String getId() {
        return this.command.getId();
    }

    public final String getName() throws NotDefinedException {
        if (this.name == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.command.getName());
            if (this.parameterizations != null) {
                stringBuffer.append(" (");
                int n = this.parameterizations.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameterization parameterization = this.parameterizations[n2];
                    stringBuffer.append(parameterization.getParameter().getName());
                    stringBuffer.append(": ");
                    try {
                        stringBuffer.append(parameterization.getValueName());
                    }
                    catch (ParameterValuesException parameterValuesException) {}
                    if (n2 + 1 < n) {
                        stringBuffer.append(", ");
                    }
                    ++n2;
                }
                stringBuffer.append(')');
            }
            this.name = stringBuffer.toString();
        }
        return this.name;
    }

    public final Map getParameterMap() {
        if (this.parameterizations == null || this.parameterizations.length == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < this.parameterizations.length) {
            Parameterization parameterization = this.parameterizations[n];
            hashMap.put(parameterization.getParameter().getId(), parameterization.getValue());
            ++n;
        }
        return hashMap;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL * 89 + Util.hashCode(this.command);
            this.hashCode *= 89;
            if (this.parameterizations != null) {
                int n = 0;
                while (n < this.parameterizations.length) {
                    this.hashCode += Util.hashCode(this.parameterizations[n]);
                    ++n;
                }
            }
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public final String serialize() {
        String string = ParameterizedCommand.escape(this.getId());
        if (this.parameterizations == null || this.parameterizations.length == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('(');
        int n = 0;
        while (n < this.parameterizations.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            Parameterization parameterization = this.parameterizations[n];
            String string2 = parameterization.getParameter().getId();
            String string3 = ParameterizedCommand.escape(string2);
            stringBuffer.append(string3);
            String string4 = parameterization.getValue();
            if (string4 != null) {
                String string5 = ParameterizedCommand.escape(string4);
                stringBuffer.append('=');
                stringBuffer.append(string5);
            }
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ParameterizedCommand(");
        stringBuffer.append(this.command);
        stringBuffer.append(',');
        stringBuffer.append(this.parameterizations);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

