/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionSet;
import org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;

public class ConditionalPermissions
extends PermissionCollection {
    private static final long serialVersionUID = 3907215965749000496L;
    private AbstractBundle bundle;
    private Vector satisfiedCPIs = new Vector();
    private ConditionalPermissionSet satisfiedCPS;
    private Vector satisfiableCPSs = new Vector();
    private boolean empty;

    public ConditionalPermissions(AbstractBundle abstractBundle, ConditionalPermissionAdmin conditionalPermissionAdmin) {
        this.bundle = abstractBundle;
        this.satisfiedCPS = new ConditionalPermissionSet(abstractBundle, ConditionalPermissionAdminImpl.EMPTY_COND_PERM_INFO, ConditionalPermissionAdminImpl.EMPTY_COND);
        Enumeration enumeration = conditionalPermissionAdmin.getConditionalPermissionInfos();
        while (enumeration.hasMoreElements()) {
            ConditionalPermissionInfoImpl conditionalPermissionInfoImpl = (ConditionalPermissionInfoImpl)enumeration.nextElement();
            this.checkConditionalPermissionInfo(conditionalPermissionInfoImpl);
        }
    }

    void checkConditionalPermissionInfo(ConditionalPermissionInfoImpl conditionalPermissionInfoImpl) {
        try {
            this.removeCPI(conditionalPermissionInfoImpl);
            Condition[] conditionArray = conditionalPermissionInfoImpl.getConditions(this.bundle);
            if (conditionArray == null) {
                return;
            }
            boolean bl = true;
            int n = 0;
            while (n < conditionArray.length) {
                Condition condition = conditionArray[n];
                if (condition.isMutable()) {
                    bl = false;
                } else {
                    if (!condition.isSatisfied()) {
                        return;
                    }
                    conditionArray[n] = null;
                }
                ++n;
            }
            if (bl) {
                this.satisfiedCPIs.add(conditionalPermissionInfoImpl);
            } else {
                this.satisfiableCPSs.add(new ConditionalPermissionSet(this.bundle, new ConditionalPermissionInfoImpl[]{conditionalPermissionInfoImpl}, conditionArray));
            }
        }
        catch (Exception exception) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, exception);
        }
    }

    private void removeCPI(ConditionalPermissionInfoImpl conditionalPermissionInfoImpl) {
        this.satisfiedCPIs.remove(conditionalPermissionInfoImpl);
        this.satisfiedCPS.remove(conditionalPermissionInfoImpl);
        ConditionalPermissionSet[] conditionalPermissionSetArray = this.satisfiableCPSs.toArray(new ConditionalPermissionSet[0]);
        int n = 0;
        while (n < conditionalPermissionSetArray.length) {
            if (conditionalPermissionSetArray[n].remove(conditionalPermissionInfoImpl)) {
                this.satisfiableCPSs.remove(conditionalPermissionSetArray[n]);
            }
            ++n;
        }
    }

    public void add(Permission permission) {
    }

    public boolean implies(Permission permission) {
        boolean bl;
        this.processPending();
        boolean bl2 = bl = !this.satisfiedCPS.isNonEmpty();
        if (!bl && this.satisfiedCPS.implies(permission)) {
            this.empty = false;
            return true;
        }
        boolean bl3 = false;
        Vector<Condition[]> vector = null;
        SecurityManager securityManager = System.getSecurityManager();
        FrameworkSecurityManager frameworkSecurityManager = null;
        if (securityManager instanceof FrameworkSecurityManager) {
            frameworkSecurityManager = (FrameworkSecurityManager)securityManager;
        }
        ConditionalPermissionSet[] conditionalPermissionSetArray = this.satisfiableCPSs.toArray(new ConditionalPermissionSet[0]);
        int n = 0;
        while (n < conditionalPermissionSetArray.length) {
            block15: {
                block16: {
                    if (!conditionalPermissionSetArray[n].isNonEmpty()) break block16;
                    bl = false;
                    Condition[] conditionArray = conditionalPermissionSetArray[n].getNeededConditions();
                    if (conditionArray == null) break block15;
                    int n2 = 0;
                    while (n2 < conditionArray.length) {
                        if (conditionArray[n2] == null || conditionArray[n2].isPostponed() || conditionArray[n2].isSatisfied()) {
                            ++n2;
                            continue;
                        }
                        break block15;
                    }
                    if (!conditionalPermissionSetArray[n].implies(permission)) break block15;
                    Vector<Condition> vector2 = null;
                    int n3 = 0;
                    while (n3 < conditionArray.length) {
                        if (conditionArray[n3] != null && conditionArray[n3].isPostponed()) {
                            if (frameworkSecurityManager == null) {
                                if (!conditionArray[n3].isSatisfied()) {
                                    break block15;
                                }
                            } else {
                                if (vector2 == null) {
                                    vector2 = new Vector<Condition>();
                                }
                                vector2.add(conditionArray[n3]);
                            }
                        }
                        ++n3;
                    }
                    if (vector2 == null) {
                        this.empty = false;
                        return true;
                    }
                    if (vector == null) {
                        vector = new Vector<Condition[]>(2);
                    }
                    vector.add(vector2.toArray(new Condition[vector2.size()]));
                    bl3 = true;
                    break block15;
                }
                this.satisfiableCPSs.remove(conditionalPermissionSetArray[n]);
            }
            ++n;
        }
        this.empty = bl;
        if (bl3 && frameworkSecurityManager != null) {
            Condition[][] conditionArray = (Condition[][])vector.toArray((T[])new Condition[vector.size()][]);
            bl3 = frameworkSecurityManager.addConditionsForDomain(conditionArray);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPending() {
        if (this.satisfiedCPIs.size() > 0) {
            Vector vector = this.satisfiedCPIs;
            synchronized (vector) {
                int n = 0;
                while (n < this.satisfiedCPIs.size()) {
                    ConditionalPermissionInfoImpl conditionalPermissionInfoImpl = (ConditionalPermissionInfoImpl)this.satisfiedCPIs.get(n);
                    if (!conditionalPermissionInfoImpl.isDeleted()) {
                        this.satisfiedCPS.addConditionalPermissionInfo(conditionalPermissionInfoImpl);
                    }
                    ++n;
                }
                this.satisfiedCPIs.clear();
            }
        }
    }

    public Enumeration elements() {
        return null;
    }

    boolean isEmpty() {
        return this.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unresolvePermissions() {
        this.satisfiedCPS.unresolvePermissions();
        Vector vector = this.satisfiableCPSs;
        synchronized (vector) {
            Enumeration enumeration = this.satisfiableCPSs.elements();
            while (enumeration.hasMoreElements()) {
                ConditionalPermissionSet conditionalPermissionSet = (ConditionalPermissionSet)enumeration.nextElement();
                conditionalPermissionSet.unresolvePermissions();
            }
        }
    }
}

