/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComputeNodeOrder {
    private ComputeNodeOrder() {
    }

    public static Object[][] computeNodeOrder(Object[] objectArray, Object[][] objectArray2) {
        Object[][] objectArray3;
        Digraph digraph = new Digraph();
        int n = 0;
        while (n < objectArray.length) {
            digraph.addVertex(objectArray[n]);
            ++n;
        }
        n = 0;
        while (n < objectArray2.length) {
            digraph.addEdge(objectArray2[n][1], objectArray2[n][0]);
            ++n;
        }
        digraph.freeze();
        Digraph digraph2 = new Digraph();
        List list = digraph.idsByDFSFinishTime(false);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            digraph2.addVertex(iterator.next());
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            digraph2.addEdge(objectArray2[n2][0], objectArray2[n2][1]);
            ++n2;
        }
        digraph2.freeze();
        List list2 = digraph2.idsByDFSFinishTime(true);
        Object[] objectArray4 = new Object[list2.size()];
        list2.toArray(objectArray4);
        boolean bl = digraph2.containsCycles();
        if (bl) {
            List list3 = digraph2.nonTrivialComponents();
            objectArray3 = (Object[][])list3.toArray((T[])new Object[list3.size()][]);
        } else {
            objectArray3 = new Object[][]{};
        }
        int n3 = 0;
        while (n3 < objectArray4.length) {
            objectArray[n3] = objectArray4[n3];
            ++n3;
        }
        return objectArray3;
    }

    private static class Digraph {
        private List vertexList = new ArrayList(100);
        private Map vertexMap = new HashMap(100);
        private int time;
        private boolean initialized = false;
        private boolean cycles = false;

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public void addVertex(Object object) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = new Vertex(object);
            Vertex vertex2 = this.vertexMap.put(object, vertex);
            if (vertex2 != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public void addEdge(Object object, Object object2) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = (Vertex)this.vertexMap.get(object);
            Vertex vertex2 = (Vertex)this.vertexMap.get(object2);
            if (vertex == null || vertex2 == null) {
                return;
            }
            vertex.adjacent.add(vertex2);
        }

        public List idsByDFSFinishTime(boolean bl) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int n = this.vertexList.size();
            Object[] objectArray = new Object[n];
            Iterator iterator = this.vertexList.iterator();
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                int n2 = vertex.finishTime;
                if (bl) {
                    objectArray[n2 - 1] = vertex.id;
                    continue;
                }
                objectArray[n - n2] = vertex.id;
            }
            return Arrays.asList(objectArray);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        public List nonTrivialComponents() {
            Object object;
            Object object2;
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
            Object object3 = this.vertexList.iterator();
            while (object3.hasNext()) {
                object2 = (Vertex)object3.next();
                if (((Vertex)object2).predecessor == null) continue;
                object = object2;
                while (((Vertex)object).predecessor != null) {
                    object = ((Vertex)object).predecessor;
                }
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>(2);
                    arrayList.add(((Vertex)object).id);
                    hashMap.put(object, arrayList);
                }
                arrayList.add(((Vertex)object2).id);
            }
            object3 = new ArrayList(hashMap.size());
            object2 = hashMap.values().iterator();
            while (object2.hasNext()) {
                object = (List)object2.next();
                if (object.size() <= 1) continue;
                object3.add(object.toArray());
            }
            return object3;
        }

        private void DFS() {
            Integer n = new Integer(1);
            Integer n2 = new Integer(4);
            this.time = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Iterator iterator = null;
            Vertex vertex = null;
            Iterator iterator2 = this.vertexList.iterator();
            int n3 = 1;
            block6: while (true) {
                switch (n3) {
                    case 1: {
                        if (!iterator2.hasNext()) break block6;
                        Vertex vertex2 = (Vertex)iterator2.next();
                        if (vertex2.color == "white") {
                            arrayList.add(n);
                            vertex = vertex2;
                            n3 = 2;
                            continue block6;
                        }
                        n3 = 1;
                        continue block6;
                    }
                    case 2: {
                        vertex.color = "grey";
                        iterator = vertex.adjacent.iterator();
                        n3 = 3;
                        continue block6;
                    }
                    case 3: {
                        if (iterator.hasNext()) {
                            Vertex vertex3 = (Vertex)iterator.next();
                            if (vertex3.color == "white") {
                                vertex3.predecessor = vertex;
                                arrayList.add(iterator);
                                arrayList.add(vertex);
                                arrayList.add(n2);
                                vertex = vertex3;
                                n3 = 2;
                                continue block6;
                            }
                            if (vertex3.color == "grey") {
                                this.cycles = true;
                            }
                            n3 = 3;
                            continue block6;
                        }
                        vertex.color = "black";
                        vertex.finishTime = ++this.time;
                        n3 = (Integer)arrayList.remove(arrayList.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        vertex = (Vertex)arrayList.remove(arrayList.size() - 1);
                        iterator = (Iterator)arrayList.remove(arrayList.size() - 1);
                        n3 = 3;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public static class Vertex {
            public static final String WHITE = "white";
            public static final String GREY = "grey";
            public static final String BLACK = "black";
            public String color = "white";
            public Vertex predecessor = null;
            public int finishTime;
            public Object id;
            public List adjacent = new ArrayList(3);

            public Vertex(Object object) {
                this.id = object;
            }
        }
    }
}

