/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.JarContentReference;

public class JarEntryContentReference
extends ContentReference {
    private JarContentReference jarContentReference;
    private JarEntry entry;

    public JarEntryContentReference(String string, JarContentReference jarContentReference, JarEntry jarEntry) {
        super(string, (File)null);
        this.jarContentReference = jarContentReference;
        this.entry = jarEntry;
    }

    public InputStream getInputStream() throws IOException {
        return this.jarContentReference.asJarFile().getInputStream(this.entry);
    }

    public long getInputSize() {
        return this.entry.getSize();
    }

    public boolean isLocalReference() {
        return this.jarContentReference.isLocalReference();
    }

    public URL asURL() throws IOException {
        String string = this.jarContentReference.asFile().getAbsolutePath().replace(File.separatorChar, '/');
        return new URL("jar:file:" + string + "!/" + this.entry.getName());
    }

    public String toString() {
        URL uRL;
        try {
            uRL = this.asURL();
        }
        catch (IOException iOException) {
            uRL = null;
        }
        if (uRL != null) {
            return uRL.toExternalForm();
        }
        return String.valueOf(this.getClass().getName()) + "@" + this.hashCode();
    }
}

