/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class FeatureExecutableContentProvider
extends FeatureContentProvider {
    public FeatureExecutableContentProvider(URL uRL) {
        super(uRL);
    }

    private String getPath(IPluginEntry iPluginEntry) throws IOException, CoreException {
        File file;
        ISiteContentProvider iSiteContentProvider = this.getFeature().getSite().getSiteContentProvider();
        URL uRL = iSiteContentProvider.getArchiveReference(this.getPathID(iPluginEntry));
        String string = uRL.getFile();
        if (!(string.endsWith(".jar") || string.endsWith("/") || string.endsWith(File.separator))) {
            string = String.valueOf(string) + File.separator;
        }
        if (!(file = new File(string)).exists()) {
            throw new IOException(NLS.bind((String)Messages.FeatureExecutableContentProvider_FileDoesNotExist, (Object[])new String[]{string}));
        }
        return string;
    }

    private String getFeaturePath() throws IOException {
        File file;
        String string = this.getFeature().getURL().getFile();
        if (!string.endsWith(File.separator) && !string.endsWith("/")) {
            string = String.valueOf(string) + File.separator;
        }
        if (!(file = new File(string)).exists()) {
            throw new IOException(NLS.bind((String)Messages.FeatureExecutableContentProvider_FileDoesNotExist, (Object[])new String[]{string}));
        }
        return string;
    }

    private List getFiles(File file) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            String string = NLS.bind((String)Messages.FeatureExecutableContentProvider_InvalidDirectory, (Object[])new String[]{file.getAbsolutePath()});
            throw new IOException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    arrayList.addAll(this.getFiles(fileArray[n]));
                } else {
                    arrayList.add(fileArray[n]);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public IVerifier getVerifier() throws CoreException {
        return null;
    }

    public ContentReference getFeatureManifestReference(InstallMonitor installMonitor) throws CoreException {
        ContentReference contentReference = null;
        try {
            contentReference = new ContentReference("feature.xml", new URL(this.getURL(), "feature.xml"));
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableContentProvider_UnableToCreateURLFor, (Object[])new String[]{String.valueOf(this.getURL().toExternalForm()) + " " + "feature.xml"}), malformedURLException);
        }
        return contentReference;
    }

    public ContentReference[] getArchiveReferences(InstallMonitor installMonitor) throws CoreException {
        return new ContentReference[0];
    }

    public ContentReference[] getPluginEntryArchiveReferences(IPluginEntry iPluginEntry, InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = new ContentReference[1];
        String string = this.getPathID(iPluginEntry);
        try {
            File file = new File(this.getPath(iPluginEntry));
            contentReferenceArray[0] = !file.isDirectory() && file.getName().endsWith(".jar") ? new JarContentReference(string, file) : new ContentReference(string, file);
        }
        catch (IOException iOException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableContentProvider_UnableToRetrievePluginEntry, (Object[])new String[]{iPluginEntry.getVersionedIdentifier().toString()}), iOException);
        }
        return contentReferenceArray;
    }

    public ContentReference[] getNonPluginEntryArchiveReferences(INonPluginEntry iNonPluginEntry, InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = new ContentReference[1];
        ISiteContentProvider iSiteContentProvider = this.getFeature().getSite().getSiteContentProvider();
        URL uRL = iSiteContentProvider.getArchiveReference(this.getPathID(iNonPluginEntry));
        String string = uRL.getFile();
        File file = new File(string);
        if (!file.exists()) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableContentProvider_FileDoesNotExist, (Object[])new String[]{string}), null);
        }
        try {
            contentReferenceArray[0] = new ContentReference(iNonPluginEntry.getIdentifier(), file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableContentProvider_UnableToRetrieveNonPluginEntry, (Object[])new String[]{iNonPluginEntry.getIdentifier().toString()}), malformedURLException);
        }
        return contentReferenceArray;
    }

    public ContentReference[] getFeatureEntryArchiveReferences(InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = new ContentReference[]{new ContentReference(null, this.getURL())};
        return contentReferenceArray;
    }

    public ContentReference[] getFeatureEntryContentReferences(InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = new ContentReference[]{};
        try {
            File file = new File(this.getFeaturePath());
            List list = this.getFiles(file);
            contentReferenceArray = new ContentReference[list.size()];
            int n = 0;
            while (n < contentReferenceArray.length) {
                File file2 = (File)list.get(n);
                contentReferenceArray[n] = new ContentReference(file2.getName(), file2.toURL());
                ++n;
            }
        }
        catch (IOException iOException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableContentProvider_UnableToRetrieveFeatureEntry, (Object[])new String[]{this.getFeature().getVersionedIdentifier().toString()}), iOException);
        }
        return contentReferenceArray;
    }

    public ContentReference[] getPluginEntryContentReferences(IPluginEntry iPluginEntry, InstallMonitor installMonitor) throws CoreException {
        ContentReference[] contentReferenceArray = this.getPluginEntryArchiveReferences(iPluginEntry, installMonitor);
        ContentReference[] contentReferenceArray2 = new ContentReference[]{};
        try {
            if (contentReferenceArray[0] instanceof JarContentReference) {
                contentReferenceArray2 = ((JarContentReference)contentReferenceArray[0]).peek(null, installMonitor);
            } else {
                File file = new File(this.getPath(iPluginEntry));
                URL uRL = file.toURL();
                List list = this.getFiles(file);
                contentReferenceArray2 = new ContentReference[list.size()];
                int n = 0;
                while (n < contentReferenceArray2.length) {
                    File file2 = (File)list.get(n);
                    String string = UpdateManagerUtils.getURLAsString(uRL, file2.toURL());
                    contentReferenceArray2[n] = new ContentReference(string, file2.toURL());
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureExecutableContentProvider_UnableToRetriveArchiveContentRef, (Object[])new String[]{iPluginEntry.getVersionedIdentifier().toString()}), iOException);
        }
        this.validatePermissions(contentReferenceArray2);
        return contentReferenceArray2;
    }
}

