/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.eclipse.osgi.internal.signedcontent.BERProcessor;
import org.eclipse.osgi.internal.signedcontent.PKCS7DateParser;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentConstants;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.util.NLS;

public class PKCS7Processor
implements SignedContentConstants {
    static CertificateFactory certFact;
    private final String signer;
    private final String file;
    private Certificate[] certificates;
    private Certificate[] tsaCertificates;
    private Map signedAttrs;
    private Map unsignedAttrs;
    private byte[] signature;
    private String digestAlgorithm;
    private String signatureAlgorithm;
    private Certificate signerCert;
    private Date signingTime;

    static {
        try {
            certFact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            SignedBundleHook.log(certificateException.getMessage(), 4, certificateException);
        }
    }

    private static String oid2String(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        return ((Object)stringBuffer).toString();
    }

    private static String findEncryption(int[] nArray) throws NoSuchAlgorithmException {
        if (Arrays.equals(DSA_OID, nArray)) {
            return "DSA";
        }
        if (Arrays.equals(RSA_OID, nArray)) {
            return "RSA";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + PKCS7Processor.oid2String(nArray));
    }

    private static String findDigest(int[] nArray) throws NoSuchAlgorithmException {
        if (Arrays.equals(SHA1_OID, nArray)) {
            return "SHA1";
        }
        if (Arrays.equals(MD5_OID, nArray)) {
            return "MD5";
        }
        if (Arrays.equals(MD2_OID, nArray)) {
            return "MD2";
        }
        throw new NoSuchAlgorithmException("No algorithm found for " + PKCS7Processor.oid2String(nArray));
    }

    public PKCS7Processor(byte[] byArray, int n, int n2, String string, String string2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        this.signer = string;
        this.file = string2;
        List list = null;
        BERProcessor bERProcessor = new BERProcessor(byArray, n, n2);
        bERProcessor = bERProcessor.stepInto();
        if (!Arrays.equals(bERProcessor.getObjId(), SIGNEDDATA_OID)) {
            throw new SignatureException(NLS.bind(SignedContentMessages.PKCS7_Invalid_File, string, string2));
        }
        bERProcessor.stepOver();
        bERProcessor = bERProcessor.stepInto();
        bERProcessor = bERProcessor.stepInto();
        bERProcessor.stepOver();
        bERProcessor.stepOver();
        this.processEncapContentInfo(bERProcessor);
        bERProcessor.stepOver();
        if (bERProcessor.classOfTag == 2 && bERProcessor.tag == 0) {
            list = this.processCertificates(bERProcessor);
        }
        if (list == null || list.size() < 1) {
            throw new SecurityException("There are no certificates in the .RSA/.DSA file!");
        }
        bERProcessor.stepOver();
        if (bERProcessor.classOfTag == 0 && bERProcessor.tag == 1) {
            bERProcessor.stepOver();
        }
        this.processSignerInfos(bERProcessor, list);
        list = this.constructCertPath(list, this.signerCert);
        this.certificates = list.toArray(new Certificate[list.size()]);
        this.verifyCerts();
        if (this.signingTime == null) {
            this.signingTime = PKCS7DateParser.parseDate(this, string, string2);
        }
    }

    private void processEncapContentInfo(BERProcessor bERProcessor) throws SignatureException {
        BERProcessor bERProcessor2 = bERProcessor.stepInto();
        if (Arrays.equals(bERProcessor2.getObjId(), TIMESTAMP_TST_OID)) {
            bERProcessor2.stepOver();
            BERProcessor bERProcessor3 = bERProcessor2.stepInto();
            byte[] byArray = bERProcessor3.getBytes();
            BERProcessor bERProcessor4 = new BERProcessor(byArray, 0, byArray.length);
            BERProcessor bERProcessor5 = bERProcessor4.stepInto();
            int n = bERProcessor5.getIntValue().intValue();
            if (n != 1) {
                throw new SignatureException("Not a version 1 time-stamp token");
            }
            bERProcessor5.stepOver();
            bERProcessor5.stepOver();
            bERProcessor5.stepOver();
            bERProcessor5.stepOver();
            String string = new String(bERProcessor5.getBytes());
            if (!string.endsWith("Z")) {
                throw new SignatureException("Wrong dateformat used in time-stamp token");
            }
            int n2 = string.indexOf(46);
            StringBuffer stringBuffer = new StringBuffer("yyyyMMddHHmmss");
            if (n2 != -1) {
                int n3 = string.indexOf(90) - 1 - n2;
                stringBuffer.append('.');
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append('s');
                    ++n4;
                }
            }
            stringBuffer.append("'Z'");
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(((Object)stringBuffer).toString());
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.signingTime = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new SignatureException(SignedContentMessages.PKCS7_Parse_Signing_Time);
            }
        }
    }

    private List constructCertPath(List list, Certificate certificate) {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add(certificate);
        X509Certificate x509Certificate = (X509Certificate)certificate;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
            if (x500Principal2.equals(x500Principal = x509Certificate.getIssuerX500Principal())) break;
            x509Certificate = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                if (!x509Certificate2.getSubjectX500Principal().equals(x500Principal)) continue;
                arrayList.add(x509Certificate2);
                x509Certificate = x509Certificate2;
            }
            ++n2;
        }
        return arrayList;
    }

    public void verifyCerts() throws InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        if (this.certificates == null || this.certificates.length == 0) {
            throw new CertificateException("There are no certificates in the signature block file!");
        }
        int n = this.certificates.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate x509Certificate = (X509Certificate)this.certificates[n2];
            if (n2 == n - 1) {
                if (x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
                    x509Certificate.verify(x509Certificate.getPublicKey());
                }
            } else {
                X509Certificate x509Certificate2 = (X509Certificate)this.certificates[n2 + 1];
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            ++n2;
        }
    }

    private Certificate processSignerInfos(BERProcessor bERProcessor, List list) throws CertificateException, NoSuchAlgorithmException, SignatureException {
        Object object;
        bERProcessor = bERProcessor.stepInto();
        BigInteger bigInteger = (bERProcessor = bERProcessor.stepInto()).getIntValue();
        if (bigInteger.intValue() != 1) {
            throw new CertificateException(SignedContentMessages.PKCS7_SignerInfo_Version_Not_Supported);
        }
        bERProcessor.stepOver();
        BERProcessor bERProcessor2 = bERProcessor.stepInto();
        X500Principal x500Principal = new X500Principal(new ByteArrayInputStream(bERProcessor2.buffer, bERProcessor2.offset, bERProcessor2.endOffset - bERProcessor2.offset));
        bERProcessor2.stepOver();
        BigInteger bigInteger2 = bERProcessor2.getIntValue();
        Object object2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (X509Certificate)iterator.next();
            if (!((X509Certificate)object).getIssuerX500Principal().equals(x500Principal) || !((X509Certificate)object).getSerialNumber().equals(bigInteger2)) continue;
            object2 = object;
            break;
        }
        if (object2 == null) {
            throw new CertificateException("Signer certificate not in pkcs7block");
        }
        this.signerCert = object2;
        bERProcessor.stepOver();
        object = bERProcessor.stepInto();
        this.digestAlgorithm = PKCS7Processor.findDigest(((BERProcessor)object).getObjId());
        bERProcessor.stepOver();
        this.processSignedAttributes(bERProcessor);
        BERProcessor bERProcessor3 = bERProcessor.stepInto();
        this.signatureAlgorithm = PKCS7Processor.findEncryption(bERProcessor3.getObjId());
        bERProcessor.stepOver();
        this.signature = bERProcessor.getBytes();
        bERProcessor.stepOver();
        this.processUnsignedAttributes(bERProcessor);
        return object2;
    }

    private void processUnsignedAttributes(BERProcessor bERProcessor) throws SignatureException {
        if (bERProcessor.classOfTag == 2 && bERProcessor.tag == 1) {
            this.unsignedAttrs = new HashMap();
            BERProcessor bERProcessor2 = bERProcessor.stepInto();
            do {
                BERProcessor bERProcessor3 = bERProcessor2.stepInto();
                int[] nArray = bERProcessor3.getObjId();
                bERProcessor3.stepOver();
                byte[] byArray = bERProcessor3.getBytes();
                this.unsignedAttrs.put(nArray, byArray);
                bERProcessor2.stepOver();
            } while (!bERProcessor2.endOfSequence());
        }
    }

    private void processSignedAttributes(BERProcessor bERProcessor) throws SignatureException {
        if (bERProcessor.classOfTag == 2) {
            this.signedAttrs = new HashMap();
            BERProcessor bERProcessor2 = bERProcessor.stepInto();
            do {
                BERProcessor bERProcessor3 = bERProcessor2.stepInto();
                int[] nArray = bERProcessor3.getObjId();
                bERProcessor3.stepOver();
                byte[] byArray = bERProcessor3.getBytes();
                this.signedAttrs.put(nArray, byArray);
                bERProcessor2.stepOver();
            } while (!bERProcessor2.endOfSequence());
            bERProcessor.stepOver();
        }
    }

    public Certificate[] getCertificates() {
        return this.certificates == null ? new Certificate[]{} : this.certificates;
    }

    public void verifySFSignature(byte[] byArray, int n, int n2) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature signature = Signature.getInstance(String.valueOf(this.digestAlgorithm) + "with" + this.signatureAlgorithm);
        signature.initVerify(this.signerCert.getPublicKey());
        signature.update(byArray, n, n2);
        if (!signature.verify(this.signature)) {
            throw new SignatureException(NLS.bind(SignedContentMessages.Signature_Not_Verify, this.signer, this.file));
        }
    }

    public Map getUnsignedAttrs() {
        return this.unsignedAttrs;
    }

    public Map getSignedAttrs() {
        return this.signedAttrs;
    }

    private List processCertificates(BERProcessor bERProcessor) throws CertificateException, SignatureException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(3);
        BERProcessor bERProcessor2 = bERProcessor.stepInto();
        do {
            X509Certificate x509Certificate;
            if ((x509Certificate = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(bERProcessor2.buffer, bERProcessor2.offset, bERProcessor2.endOffset - bERProcessor2.offset))) != null) {
                arrayList.add(x509Certificate);
            }
            bERProcessor2.stepOver();
        } while (!bERProcessor2.endOfSequence());
        return arrayList;
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    void setTSACertificates(Certificate[] certificateArray) {
        this.tsaCertificates = certificateArray;
    }

    public Certificate[] getTSACertificates() {
        return this.tsaCertificates == null ? new Certificate[]{} : this.tsaCertificates;
    }
}

