/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CheckboxTableViewer
extends TableViewer
implements ICheckable {
    private ListenerList checkStateListeners = new ListenerList(3);

    public CheckboxTableViewer(Composite composite) {
        this(composite, 2048);
    }

    public CheckboxTableViewer(Composite composite, int n) {
        this(CheckboxTableViewer.createTable(composite, n));
    }

    public static CheckboxTableViewer newCheckList(Composite composite, int n) {
        Table table = new Table(composite, 0x20 | n);
        return new CheckboxTableViewer(table);
    }

    public CheckboxTableViewer(Table table) {
        super(table);
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListeners.add(iCheckStateListener);
    }

    protected static Table createTable(Composite composite, int n) {
        Table table = new Table(composite, 0x20 | n);
        new TableColumn(table, 0);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData(new ColumnWeightData(100));
        table.setLayout((Layout)tableLayout);
        return table;
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        Object[] objectArray = this.checkStateListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICheckStateListener iCheckStateListener = (ICheckStateListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iCheckStateListener.checkStateChanged(checkStateChangedEvent);
                }
            });
            ++n;
        }
    }

    public boolean getChecked(Object object) {
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getChecked();
        }
        return false;
    }

    public Object[] getCheckedElements() {
        TableItem[] tableItemArray = this.getTable().getItems();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            if (tableItem.getChecked()) {
                arrayList.add(tableItem.getData());
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public boolean getGrayed(Object object) {
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getGrayed();
        }
        return false;
    }

    public Object[] getGrayedElements() {
        TableItem[] tableItemArray = this.getTable().getItems();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            if (tableItem.getGrayed()) {
                arrayList.add(tableItem.getData());
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public void handleSelect(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 32) {
            super.handleSelect(selectionEvent);
            TableItem tableItem = (TableItem)selectionEvent.item;
            Object object = tableItem.getData();
            if (object != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent(this, object, tableItem.getChecked()));
            }
        } else {
            super.handleSelect(selectionEvent);
        }
    }

    protected void preservingSelection(Runnable runnable) {
        Object object;
        TableItem tableItem;
        TableItem[] tableItemArray = this.getTable().getItems();
        CustomHashtable customHashtable = this.newHashtable(tableItemArray.length * 2 + 1);
        CustomHashtable customHashtable2 = this.newHashtable(tableItemArray.length * 2 + 1);
        int n = 0;
        while (n < tableItemArray.length) {
            tableItem = tableItemArray[n];
            object = tableItem.getData();
            if (object != null) {
                if (tableItem.getChecked()) {
                    customHashtable.put(object, object);
                }
                if (tableItem.getGrayed()) {
                    customHashtable2.put(object, object);
                }
            }
            ++n;
        }
        super.preservingSelection(runnable);
        tableItemArray = this.getTable().getItems();
        n = 0;
        while (n < tableItemArray.length) {
            tableItem = tableItemArray[n];
            object = tableItem.getData();
            if (object != null) {
                tableItem.setChecked(customHashtable.containsKey(object));
                tableItem.setGrayed(customHashtable2.containsKey(object));
            }
            ++n;
        }
    }

    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkStateListeners.remove(iCheckStateListener);
    }

    public void setAllChecked(boolean bl) {
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            tableItem.setChecked(bl);
            ++n;
        }
    }

    public void setAllGrayed(boolean bl) {
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            tableItem.setGrayed(bl);
            ++n;
        }
    }

    public boolean setChecked(Object object, boolean bl) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setChecked(bl);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        int n = 0;
        while (n < objectArray.length) {
            customHashtable.put(objectArray[n], objectArray[n]);
            ++n;
        }
        TableItem[] tableItemArray = this.getTable().getItems();
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object != null) {
                boolean bl = customHashtable.containsKey(object);
                if (tableItem.getChecked() != bl) {
                    tableItem.setChecked(bl);
                }
            }
            ++n2;
        }
    }

    public boolean setGrayed(Object object, boolean bl) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setGrayed(bl);
            return true;
        }
        return false;
    }

    public void setGrayedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        int n = 0;
        while (n < objectArray.length) {
            customHashtable.put(objectArray[n], objectArray[n]);
            ++n;
        }
        TableItem[] tableItemArray = this.getTable().getItems();
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object != null) {
                boolean bl = customHashtable.containsKey(object);
                if (tableItem.getGrayed() != bl) {
                    tableItem.setGrayed(bl);
                }
            }
            ++n2;
        }
    }
}

