/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.CategoryEvent;
import org.eclipse.core.commands.ICategoryListener;
import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.internal.commands.util.Util;

public final class Category
extends NamedHandleObject {
    private Collection categoryListeners;

    Category(String string) {
        super(string);
    }

    public final void addCategoryListener(ICategoryListener iCategoryListener) {
        if (iCategoryListener == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners == null) {
            this.categoryListeners = new ArrayList();
        }
        if (!this.categoryListeners.contains(iCategoryListener)) {
            this.categoryListeners.add(iCategoryListener);
        }
    }

    public final void define(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("The name of a command cannot be null");
        }
        boolean bl = !this.defined;
        this.defined = true;
        boolean bl2 = !Util.equals(this.name, string);
        this.name = string;
        boolean bl3 = !Util.equals(this.description, string2);
        this.description = string2;
        this.fireCategoryChanged(new CategoryEvent(this, bl, bl3, bl2));
    }

    private final void fireCategoryChanged(CategoryEvent categoryEvent) {
        if (categoryEvent == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners != null) {
            Iterator iterator = this.categoryListeners.iterator();
            while (iterator.hasNext()) {
                ICategoryListener iCategoryListener = (ICategoryListener)iterator.next();
                iCategoryListener.categoryChanged(categoryEvent);
            }
        }
    }

    public final void removeCategoryListener(ICategoryListener iCategoryListener) {
        if (iCategoryListener == null) {
            throw new NullPointerException();
        }
        if (this.categoryListeners != null) {
            this.categoryListeners.remove(iCategoryListener);
        }
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Category(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public void undefine() {
        this.string = null;
        boolean bl = this.defined;
        this.defined = false;
        boolean bl2 = this.name != null;
        this.name = null;
        boolean bl3 = this.description != null;
        this.description = null;
        this.fireCategoryChanged(new CategoryEvent(this, bl, bl3, bl2));
    }
}

