/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ViewerLabel {
    private String newText = null;
    private Image newImage = null;
    private boolean imageUpdated = false;
    private boolean textUpdated = false;
    private Color background = null;
    private Color foreground = null;
    private Font font = null;
    private String startText;
    private Image startImage;

    public ViewerLabel(String string, Image image) {
        this.startText = string;
        this.startImage = image;
    }

    public final Image getImage() {
        if (this.imageUpdated) {
            return this.newImage;
        }
        return this.startImage;
    }

    public final void setImage(Image image) {
        this.imageUpdated = true;
        this.newImage = image;
    }

    public final String getText() {
        if (this.textUpdated) {
            return this.newText;
        }
        return this.startText;
    }

    public final void setText(String string) {
        this.newText = string;
        this.textUpdated = true;
    }

    public boolean hasNewImage() {
        if (this.startImage == null) {
            return this.newImage != null;
        }
        if (this.imageUpdated) {
            return !this.startImage.equals((Object)this.newImage);
        }
        return false;
    }

    public boolean hasNewText() {
        if (this.startText == null) {
            return this.newText != null;
        }
        if (this.textUpdated) {
            return !this.startText.equals(this.newText);
        }
        return false;
    }

    public boolean hasNewBackground() {
        return this.background != null;
    }

    public boolean hasNewForeground() {
        return this.foreground != null;
    }

    public boolean hasNewFont() {
        return this.font != null;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }
}

