/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

public class EventListeners {
    private static final ListElement[] emptyArray = new ListElement[0];
    private final int initialCapacity;
    private ListElement[] list = null;
    private int size = 0;
    private boolean copyOnWrite = false;

    public EventListeners() {
        this(10);
    }

    public EventListeners(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.initialCapacity = n;
    }

    public synchronized void addListener(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.size == 0) {
            this.list = new ListElement[this.initialCapacity];
        } else {
            if (this.copyOnWrite) {
                this.copyList(this.size);
                this.copyOnWrite = false;
            }
            int n = 0;
            while (n < this.size) {
                if (this.list[n].primary == object) {
                    this.list[n] = new ListElement(object, object2);
                    return;
                }
                ++n;
            }
            if (this.size == this.list.length) {
                this.copyList(this.size);
            }
        }
        this.list[this.size] = new ListElement(object, object2);
        ++this.size;
    }

    public synchronized void removeListener(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < this.size) {
            if (this.list[n].primary == object) {
                --this.size;
                if (this.size == 0) {
                    this.list = null;
                    return;
                }
                if (this.copyOnWrite) {
                    this.copyList(n);
                    this.copyOnWrite = false;
                } else {
                    System.arraycopy(this.list, n + 1, this.list, n, this.size - n);
                    this.list[this.size] = null;
                }
                return;
            }
            ++n;
        }
    }

    public synchronized void removeAllListeners() {
        this.list = null;
        this.size = 0;
    }

    synchronized ListElement[] getListeners() {
        if (this.size == 0) {
            return emptyArray;
        }
        this.copyOnWrite = true;
        return this.list;
    }

    private void copyList(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.size * 3 / 2 + 1;
        if (n2 < this.initialCapacity) {
            n2 = this.initialCapacity;
        }
        ListElement[] listElementArray = new ListElement[n2];
        System.arraycopy(this.list, 0, listElementArray, 0, n);
        if (n < this.size) {
            System.arraycopy(this.list, n + 1, listElementArray, n, this.size - n);
        }
        this.list = listElementArray;
    }

    static class ListElement {
        final Object primary;
        final Object companion;

        ListElement(Object object, Object object2) {
            this.primary = object;
            this.companion = object2;
        }
    }
}

