/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleException;

public class SystemBundle
extends BundleHost {
    ProtectionDomain systemDomain;

    protected SystemBundle(Framework framework) throws BundleException {
        super(framework.adaptor.createSystemBundleData(), framework);
        Constants.setInternalSymbolicName(this.bundledata.getSymbolicName());
        this.state = 4;
        this.context = this.createContext();
    }

    protected void load() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.systemDomain = this.getClass().getProtectionDomain();
        }
    }

    protected boolean reload(AbstractBundle abstractBundle) {
        return false;
    }

    protected void refresh() {
    }

    protected boolean unload() {
        return false;
    }

    protected void close() {
        this.context.close();
        this.context = null;
        this.state = 1;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (bl) {
            this.framework.checkAdminPermission(this, "class");
            this.checkValid();
        }
        return Class.forName(string);
    }

    public URL getResource(String string) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    public void start() {
        this.framework.checkAdminPermission(this, "execute");
    }

    protected void resume() {
        this.framework.startLevelManager.initialize();
        this.framework.startLevelManager.launch(this.framework.startLevelManager.getFrameworkStartLevel());
    }

    public void stop() {
        this.framework.checkAdminPermission(this, "execute");
        if (this.state == 32) {
            Thread thread = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    try {
                        SystemBundle.this.framework.shutdown();
                    }
                    catch (Throwable throwable) {
                        SystemBundle.this.framework.adaptor.handleRuntimeError(throwable);
                    }
                }
            }, "System Bundle Shutdown");
            thread.start();
        }
    }

    protected void suspend() {
        this.framework.startLevelManager.shutdown();
        this.framework.startLevelManager.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
        this.framework.publishBundleEvent(4, this);
    }

    protected void suspend(boolean bl) {
    }

    public void update() {
        this.framework.checkAdminPermission(this, "lifecycle");
        if (this.state == 32) {
            Thread thread = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    String string = FrameworkProperties.getProperty("osgi.framework.beginningstartlevel");
                    String string2 = String.valueOf(SystemBundle.this.framework.startLevelManager.getStartLevel());
                    FrameworkProperties.setProperty("osgi.framework.beginningstartlevel", string2);
                    FrameworkProperties.setProperty("osgi.framework.relaunch", "");
                    SystemBundle.this.framework.shutdown();
                    SystemBundle.this.framework.launch();
                    FrameworkProperties.clearProperty("osgi.framework.relaunch");
                    if (string == null) {
                        FrameworkProperties.clearProperty("osgi.framework.beginningstartlevel");
                    } else {
                        FrameworkProperties.setProperty("osgi.framework.beginningstartlevel", string);
                    }
                }
            }, "System Bundle Update");
            thread.start();
        }
    }

    public void update(InputStream inputStream) {
        this.update();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public void uninstall() throws BundleException {
        this.framework.checkAdminPermission(this, "lifecycle");
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION);
    }

    public boolean hasPermission(Object object) {
        if (this.systemDomain != null) {
            if (object instanceof Permission) {
                return this.systemDomain.implies((Permission)object);
            }
            return false;
        }
        return true;
    }

    protected void unresolvePermissions(AbstractBundle[] abstractBundleArray) {
    }

    public Dictionary getHeaders(String string) {
        return new SystemBundleHeaders(super.getHeaders(string));
    }

    class SystemBundleHeaders
    extends Dictionary {
        private final Dictionary headers;

        public SystemBundleHeaders(Dictionary dictionary) {
            this.headers = dictionary;
        }

        public Enumeration elements() {
            return this.headers.elements();
        }

        public Object get(Object object) {
            if (!"Export-Package".equals(object)) {
                return this.headers.get(object);
            }
            String string = FrameworkProperties.getProperty("org.osgi.framework.system.packages");
            String string2 = (String)this.headers.get("Export-Package");
            if (string != null) {
                string2 = string2 != null ? String.valueOf(string2) + ", " + string : string;
            }
            return string2;
        }

        public boolean isEmpty() {
            return this.headers.isEmpty();
        }

        public Enumeration keys() {
            return this.headers.keys();
        }

        public Object put(Object object, Object object2) {
            return this.headers.put(object, object2);
        }

        public Object remove(Object object) {
            return this.headers.remove(object);
        }

        public int size() {
            return this.headers.size();
        }
    }
}

