/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.internal.Semaphore;
import org.eclipse.ui.internal.UILockListener;

public class UISynchronizer
extends Synchronizer {
    protected UILockListener lockListener;

    public UISynchronizer(Display display, UILockListener uILockListener) {
        super(display);
        this.lockListener = uILockListener;
    }

    public void syncExec(Runnable runnable) {
        if (runnable == null || this.lockListener.isUI() || !this.lockListener.isLockOwner()) {
            super.syncExec(runnable);
            return;
        }
        Semaphore semaphore = new Semaphore(runnable);
        semaphore.setOperationThread(Thread.currentThread());
        this.lockListener.addPendingWork(semaphore);
        this.asyncExec(new Runnable(){

            public void run() {
                UISynchronizer.this.lockListener.doPendingWork();
            }
        });
        try {
            do {
                if (!this.lockListener.isUIWaiting()) continue;
                this.lockListener.interruptUI();
            } while (!semaphore.acquire(1000L));
        }
        catch (InterruptedException interruptedException) {}
    }
}

