/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ViewPane
extends PartPane
implements IPropertyListener {
    private boolean busy = false;
    private boolean fast = false;
    private boolean showFocus = false;
    Composite toolbarWrapper;
    boolean hasFocus;
    private boolean hadViewMenu = false;

    public ViewPane(IViewReference iViewReference, WorkbenchPage workbenchPage) {
        super(iViewReference, workbenchPage);
        this.fast = iViewReference.isFastView();
    }

    public void createControl(Composite composite) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            return;
        }
        super.createControl(composite);
    }

    private void recreateToolbars() {
        this.updateActionBars();
    }

    protected void createTitleBar() {
        this.updateTitles();
        this.getPartReference().addPropertyListener(this);
    }

    public void dispose() {
        super.dispose();
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.dispose();
            this.toolbarWrapper = null;
        }
    }

    public void doHide() {
        this.getPage().hideView(this.getViewReference());
    }

    Rectangle getParentBounds() {
        LayoutPart layoutPart;
        Control control = this.getControl();
        if (this.getContainer() != null && this.getContainer() instanceof LayoutPart && (layoutPart = (LayoutPart)((Object)this.getContainer())).getControl() != null) {
            control = layoutPart.getControl();
        }
        return control.getBounds();
    }

    public void doMakeFast() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getPage().getWorkbenchWindow();
        workbenchWindow.getShell();
        this.getPage().addFastView(this.getViewReference());
    }

    public void doRemoveFast() {
        this.getControl().getShell();
        this.getParentBounds();
        this.getPage().removeFastView(this.getViewReference());
        IWorkbenchPart iWorkbenchPart = this.getViewReference().getPart(true);
        if (iWorkbenchPart != null) {
            this.getPage().activate(iWorkbenchPart);
        }
        this.getParentBounds();
    }

    protected void doDock() {
        this.getPage().removeFastView(this.getViewReference());
    }

    public void doDetach() {
        this.getPage().detachView(this.getViewReference());
    }

    public void doAttach() {
        this.getPage().attachView(this.getViewReference());
    }

    public String getCompoundId() {
        IViewReference iViewReference = this.getViewReference();
        if (iViewReference != null) {
            return ViewFactory.getKey(iViewReference);
        }
        return super.getCompoundId();
    }

    public Control getDragHandle() {
        return this.control;
    }

    public Control[] getTabList() {
        Control control = this.getControl();
        if (this.getContainer() instanceof ViewStack) {
            ViewStack viewStack = (ViewStack)this.getContainer();
            return viewStack.getTabList(this);
        }
        return new Control[]{control};
    }

    public IViewReference getViewReference() {
        return (IViewReference)this.getPartReference();
    }

    public void propertyChanged(Object object, int n) {
        if (n == 1) {
            this.updateTitles();
        }
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    void shellActivated() {
    }

    void shellDeactivated() {
    }

    void setActive(boolean bl) {
        this.hasFocus = bl;
        if (this.getContainer() instanceof PartStack) {
            ((PartStack)this.getContainer()).setActive(bl ? 1 : 0);
        }
    }

    public void showFocus(boolean bl) {
        this.setActive(bl);
    }

    private boolean isFastView() {
        return this.page.isFastView(this.getViewReference());
    }

    boolean isMoveable() {
        return !this.page.isFixedLayout();
    }

    public boolean hasViewMenu() {
        return false;
    }

    public void showViewMenu(Point point) {
        if (!this.hasViewMenu()) {
            return;
        }
        if (this.isFastView() && this.page.getActiveFastView() != this.getViewReference()) {
            return;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }

    public void updateActionBars() {
    }

    public void updateTitles() {
    }

    protected void doZoom() {
        if (this.isMoveable()) {
            super.doZoom();
        }
    }

    public void setContainer(ILayoutContainer iLayoutContainer) {
        ILayoutContainer iLayoutContainer2 = this.getContainer();
        if (this.hasFocus) {
            if (iLayoutContainer2 != null && iLayoutContainer2 instanceof PartStack) {
                ((PartStack)iLayoutContainer2).setActive(0);
            }
            if (iLayoutContainer != null && iLayoutContainer instanceof PartStack) {
                ((PartStack)iLayoutContainer).setActive(1);
            }
        }
        super.setContainer(iLayoutContainer);
    }

    public void reparent(Composite composite) {
        super.reparent(composite);
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.setParent(composite);
        }
    }

    public void moveAbove(Control control) {
        super.moveAbove(control);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setBusy(boolean bl) {
        if (bl != this.busy) {
            this.busy = bl;
            this.presentableAdapter.firePropertyChange(146);
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void showHighlight() {
        this.presentableAdapter.firePropertyChange(148);
    }

    public String getPlaceHolderId() {
        return ViewFactory.getKey(this.getViewReference());
    }

    public Control getToolBar() {
        return this.toolbarWrapper;
    }

    public boolean isCloseable() {
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return true;
        }
        return perspective.isCloseable(this.getViewReference());
    }
}

