/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import com.ibm.ugl.eswt.expanded.OS;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DialogUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RGBUtils;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    private FontData fontData;
    private RGB rgb;

    public FontDialog(Shell parent) {
        super(parent);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontData[] getFontList() {
        FontDialog fontDialog = this;
        synchronized (fontDialog) {
            if (this.fontData == null) {
                return null;
            }
            return new FontData[]{this.fontData};
        }
    }

    public RGB getRGB() {
        return this.rgb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontData open() {
        Display display = this.parent.getDisplay();
        if (display == null) {
            this.error(24);
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (this.parent.isDisposed()) {
            this.error(24);
        }
        int fontDialog = OS.FontDialog_New(this.parent.internal_handle, DialogUtils.getNativeModalityStyle(this));
        FontDialog fontDialog2 = this;
        synchronized (fontDialog2) {
            if (this.fontData != null) {
                OS.FontDialog_SetInitialFontData(fontDialog, this.fontData.getName(), this.fontData.getHeight(), FontData.internal_convertToNativeStyle(this.fontData.getStyle()));
            }
            if (this.rgb != null) {
                OS.FontDialog_SetInitialRGB(fontDialog, RGBUtils.toRGBInt(this.rgb));
            }
        }
        boolean success = OS.FontDialog_Open(fontDialog, DialogUtils.getNativeTitle(this));
        if (success) {
            this.rgb = RGBUtils.fromRGBInt(OS.FontDialog_GetRGB(fontDialog));
            String name = OS.FontDialog_GetFontName(fontDialog);
            int size = OS.FontDialog_GetFontSize(fontDialog);
            int style = OS.FontDialog_GetFontStyle(fontDialog);
            this.fontData = new FontData(name, size, FontData.internal_convertToSWTStyle(style));
        } else {
            this.fontData = null;
        }
        OS.FontDialog_Dispose(fontDialog);
        return this.fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

