/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;

public class ContextFinder
extends ClassLoader
implements PrivilegedAction {
    private static ThreadLocal cycleDetector = new ThreadLocal();
    static ClassLoader finderClassLoader;
    static Finder contextFinder;
    private final ClassLoader parentContextClassLoader;
    static /* synthetic */ Class class$0;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.internal.adaptor.ContextFinder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                finderClassLoader = clazz.getClassLoader();
                contextFinder = new Finder();
                return null;
            }
        });
    }

    public ContextFinder(ClassLoader classLoader) {
        super(classLoader);
        this.parentContextClassLoader = classLoader != null ? classLoader : new ClassLoader(null){};
    }

    ArrayList basicFindClassLoaders() {
        Class[] classArray = contextFinder.getClassContext();
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(1);
        ClassLoader classLoader = null;
        int n = 1;
        while (n < classArray.length) {
            ClassLoader classLoader2 = classArray[n].getClassLoader();
            Class clazz = classArray[n];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.core.runtime.internal.adaptor.ContextFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2 && classLoader2 != null && classLoader2 != this) {
                if (this.checkClassLoader(classLoader2) && classLoader != classLoader2) {
                    arrayList.add(classLoader2);
                    classLoader = classLoader2;
                }
                if (classLoader2 == finderClassLoader || classLoader2 instanceof BundleClassLoader) break;
            }
            ++n;
        }
        return arrayList;
    }

    private boolean checkClassLoader(ClassLoader classLoader) {
        if (classLoader == null || classLoader == this.getParent()) {
            return false;
        }
        ClassLoader classLoader2 = classLoader.getParent();
        while (classLoader2 != null) {
            if (classLoader2 == this) {
                return false;
            }
            classLoader2 = classLoader2.getParent();
        }
        return true;
    }

    private ArrayList findClassLoaders() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoaders();
        }
        return (ArrayList)AccessController.doPrivileged(this);
    }

    public Object run() {
        return this.basicFindClassLoaders();
    }

    private boolean startLoading(String string) {
        HashSet<String> hashSet = (HashSet<String>)cycleDetector.get();
        if (hashSet != null && hashSet.contains(string)) {
            return false;
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>(3);
            cycleDetector.set(hashSet);
        }
        hashSet.add(string);
        return true;
    }

    private void stopLoading(String string) {
        ((Set)cycleDetector.get()).remove(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        if (!this.startLoading(string)) {
            throw new ClassNotFoundException(string);
        }
        try {
            ArrayList arrayList = this.findClassLoaders();
            Iterator iterator = arrayList.iterator();
            while (true) {
                Class<?> clazz2;
                if (!iterator.hasNext()) {
                    clazz = this.parentContextClassLoader.loadClass(string);
                    break;
                }
                try {
                    clazz2 = ((ClassLoader)iterator.next()).loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                Object var5_7 = null;
                this.stopLoading(string);
                return clazz2;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.stopLoading(string);
            throw throwable;
        }
        Object var5_8 = null;
        this.stopLoading(string);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getResource(String string) {
        URL uRL;
        if (!this.startLoading(string)) {
            return null;
        }
        try {
            block4: {
                URL uRL2;
                ArrayList arrayList = this.findClassLoaders();
                Iterator iterator = arrayList.iterator();
                do {
                    if (!iterator.hasNext()) break block4;
                } while ((uRL2 = ((ClassLoader)iterator.next()).getResource(string)) == null);
                URL uRL3 = uRL2;
                Object var5_7 = null;
                this.stopLoading(string);
                return uRL3;
            }
            uRL = super.getResource(string);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.stopLoading(string);
            throw throwable;
        }
        Object var5_8 = null;
        this.stopLoading(string);
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Enumeration findResources(String string) throws IOException {
        Enumeration<URL> enumeration;
        if (!this.startLoading(string)) {
            return null;
        }
        try {
            block4: {
                Enumeration<URL> enumeration2;
                ArrayList arrayList = this.findClassLoaders();
                Iterator iterator = arrayList.iterator();
                do {
                    if (!iterator.hasNext()) break block4;
                } while ((enumeration2 = ((ClassLoader)iterator.next()).getResources(string)) == null || !enumeration2.hasMoreElements());
                Enumeration<URL> enumeration3 = enumeration2;
                Object var5_7 = null;
                this.stopLoading(string);
                return enumeration3;
            }
            enumeration = super.findResources(string);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.stopLoading(string);
            throw throwable;
        }
        Object var5_8 = null;
        this.stopLoading(string);
        return enumeration;
    }

    static final class Finder
    extends SecurityManager {
        Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

