/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.app.AppPersistence;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.application.ApplicationAdminPermission;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;

public abstract class ApplicationDescriptor {
    public static final String APPLICATION_NAME = "application.name";
    public static final String APPLICATION_ICON = "application.icon";
    public static final String APPLICATION_PID = "service.pid";
    public static final String APPLICATION_VERSION = "application.version";
    public static final String APPLICATION_VENDOR = "service.vendor";
    public static final String APPLICATION_VISIBLE = "application.visible";
    public static final String APPLICATION_LAUNCHABLE = "application.launchable";
    public static final String APPLICATION_LOCKED = "application.locked";
    public static final String APPLICATION_DESCRIPTION = "application.description";
    public static final String APPLICATION_DOCUMENTATION = "application.documentation";
    public static final String APPLICATION_COPYRIGHT = "application.copyright";
    public static final String APPLICATION_LICENSE = "application.license";
    public static final String APPLICATION_CONTAINER = "application.container";
    public static final String APPLICATION_LOCATION = "application.location";
    private final String pid;
    private boolean[] locked = new boolean[1];

    protected ApplicationDescriptor(String string) {
        if (string == null) {
            throw new NullPointerException("Application ID must not be null!");
        }
        this.pid = string;
        this.locked[0] = this.isLocked();
    }

    public final String getApplicationId() {
        return this.pid;
    }

    public abstract boolean matchDNChain(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map getProperties(String string) {
        Map map = this.getPropertiesSpecific(string);
        Boolean bl = (Boolean)map.remove(APPLICATION_LOCKED);
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (bl != null && bl != this.locked[0]) {
                if (this.locked[0]) {
                    this.lockSpecific();
                } else {
                    this.unlockSpecific();
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            map.put(APPLICATION_LOCKED, new Boolean(this.locked[0]));
            return map;
        }
    }

    protected abstract Map getPropertiesSpecific(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ApplicationHandle launch(Map map) throws ApplicationException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ApplicationAdminPermission(this, "lifecycle"));
        }
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (this.locked[0]) {
                throw new ApplicationException(1, "Application is locked, can't launch!");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!this.isLaunchableSpecific()) {
                throw new ApplicationException(2, "Cannot launch the application!");
            }
            this.checkArgs(map);
            try {
                return this.launchSpecific(map);
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (ApplicationException applicationException) {
                throw applicationException;
            }
            catch (Exception exception) {
                throw new ApplicationException(3, (Throwable)exception);
            }
        }
    }

    protected abstract ApplicationHandle launchSpecific(Map var1) throws Exception;

    protected abstract boolean isLaunchableSpecific();

    public final ScheduledApplication schedule(String string, Map map, String string2, String string3, boolean bl) throws InvalidSyntaxException, ApplicationException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ApplicationAdminPermission(this, "schedule"));
        }
        this.checkArgs(map);
        this.isLaunchableSpecific();
        return AppPersistence.addScheduledApp(this, string, map, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lock() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ApplicationAdminPermission(this, "lock"));
        }
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (this.locked[0]) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.locked[0] = true;
            this.lockSpecific();
            this.saveLock(true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void lockSpecific();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ApplicationAdminPermission(this, "lock"));
        }
        boolean[] blArray = this.locked;
        synchronized (this.locked) {
            if (!this.locked[0]) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.locked[0] = false;
            this.unlockSpecific();
            this.saveLock(false);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void unlockSpecific();

    private void saveLock(boolean bl) {
        AppPersistence.saveLock(this, bl);
    }

    private boolean isLocked() {
        return AppPersistence.isLocked(this);
    }

    private void checkArgs(Map map) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) {
                throw new IllegalArgumentException("Invalid key type: " + k == null ? "<null>" : k.getClass().getName());
            }
            if (!"".equals(k)) continue;
            throw new IllegalArgumentException("Empty string is an invalid key");
        }
    }
}

