/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.connection.AbstractResponse;
import org.eclipse.update.internal.core.connection.TooManyOpenConnectionsException;

public class HttpResponse
extends AbstractResponse {
    protected URL url;
    protected InputStream in;
    protected long lastModified;
    protected long offset;
    private boolean isPoorNetwork = false;

    protected HttpResponse(URL url) {
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            try {
                InputStream connInputStream = this.connection.getInputStream();
                if (connInputStream != null) {
                    this.in = new MonitoringInputStream(connInputStream);
                }
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
            this.checkOffset();
        }
        return this.in;
    }

    /*
     * Unable to fully structure code
     */
    public InputStream getInputStream(IProgressMonitor monitor) throws IOException, CoreException, TooManyOpenConnectionsException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            if (monitor != null) {
                try {
                    connInputStream = this.openStreamWithCancel(this.connection, monitor);
                    if (connInputStream == null) ** GOTO lbl23
                    this.in = new MonitoringInputStream(connInputStream);
                }
                catch (IOException ioe) {
                    this.connection = null;
                    throw ioe;
                }
            } else {
                try {
                    connInputStream = this.connection.getInputStream();
                    if (connInputStream != null) {
                        this.in = new MonitoringInputStream(connInputStream);
                    }
                }
                catch (IOException ioe) {
                    this.connection = null;
                    throw ioe;
                }
            }
lbl23:
            // 3 sources

            this.checkOffset();
            if (this.in != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.in;
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        if (this.connection == null) {
            try {
                this.connection = this.url.openConnection();
            }
            catch (IOException iOException) {}
        }
        if (this.connection != null) {
            this.isPoorNetwork = false;
            StatusThread st = new StatusThread((HttpURLConnection)this.connection);
            st.start();
            int timeOutValue = 10000;
            try {
                String timeOutValueString = System.getProperty("sun.net.client.defaultConnectTimeout");
                if (timeOutValueString != null) {
                    timeOutValue = Integer.parseInt(timeOutValueString);
                }
                if (timeOutValue < 1000) {
                    timeOutValue = 1000;
                }
            }
            catch (Exception exception) {}
            try {
                st.join(timeOutValue);
                if (st.isAlive()) {
                    if (UpdateCore.DEBUG) {
                        System.out.println("[eUpdate Debug] Internal time out detection for HttpURLConnection.");
                    }
                    st.interrupt();
                    this.isPoorNetwork = true;
                }
            }
            catch (InterruptedException interruptedException) {}
            if (this.isPoorNetwork) {
                return 504;
            }
            return st.getResponseCode();
        }
        return 200;
    }

    public String getStatusMessage() {
        if (this.connection != null) {
            if (this.isPoorNetwork) {
                return "";
            }
            try {
                return ((HttpURLConnection)this.connection).getResponseMessage();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            if (this.connection == null) {
                try {
                    this.connection = this.url.openConnection();
                }
                catch (IOException iOException) {}
            }
            if (this.connection != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.lastModified;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    private void checkOffset() throws IOException {
        if (this.offset == 0L) {
            return;
        }
        String range = this.connection.getHeaderField("Content-Range");
        if (range == null) {
            throw new IOException(Messages.HttpResponse_rangeExpected);
        }
        if (!range.startsWith("bytes " + this.offset + "-")) {
            throw new IOException(Messages.HttpResponse_wrongRange);
        }
    }

    private class MonitoringInputStream
    extends FilterInputStream {
        InputStream in;

        public MonitoringInputStream(InputStream in) {
            super(in);
            this.in = in;
        }

        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException ioe) {
                HttpResponse.this.connection = null;
                throw ioe;
            }
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException ioe) {
                HttpResponse.this.connection = null;
                throw ioe;
            }
        }

        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException ioe) {
                HttpResponse.this.connection = null;
                throw ioe;
            }
        }

        public synchronized void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException ioe) {
                HttpResponse.this.connection = null;
                throw ioe;
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                return super.read(b);
            }
            catch (IOException ioe) {
                HttpResponse.this.connection = null;
                throw ioe;
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return super.read(b, off, len);
            }
            catch (IOException ioe) {
                HttpResponse.this.connection = null;
                throw ioe;
            }
        }

        public long skip(long n) throws IOException {
            try {
                return super.skip(n);
            }
            catch (IOException ioe) {
                HttpResponse.this.connection = null;
                throw ioe;
            }
        }
    }

    public class StatusThread
    extends Thread {
        HttpURLConnection conn;
        int result;

        public StatusThread(HttpURLConnection connection) {
            this.conn = connection;
        }

        public void run() {
            try {
                this.result = this.conn.getResponseCode();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }

        public int getResponseCode() {
            return this.result;
        }
    }
}

