/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.ManageScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.util.FeatureWrap;

public class InstallingScreen
extends AbsScreen {
    public static final int PROGRESS_MAX_VALUE = 10;
    public Label featureName;
    public ProgressBar featureProgress;
    public ProgressBar overallProgress;
    private int totalInstallFeaturesCount = 0;
    private UpdateMonitor installFeatureMonitor;
    private InstallFeatureThread installFeaturesThread;
    private Composite pane;
    private Command cancelCommand;
    private StringBuffer installLog;
    private boolean isExisted = false;

    InstallingScreen(NormalView view) {
        super(view);
    }

    protected void createScreen() {
        this.init(null);
        this.pane = new Composite(this.screen, 0);
        this.pane.setLayoutData((Object)new GridData(768));
        RowLayout paneLayout = new RowLayout(256);
        paneLayout.wrap = false;
        this.pane.setLayout((Layout)paneLayout);
        new Label(this.pane, 0).setText(UIMessages.Installing);
        this.featureName = new Label(this.pane, 0);
        this.featureProgress = new ProgressBar(this.screen, 65536);
        this.featureProgress.setMaximum(10);
        Label overallLabel = new Label(this.screen, 0);
        overallLabel.setText(UIMessages.OverallProgress);
        this.overallProgress = new ProgressBar(this.screen, 65536);
        this.fillSpace();
        if (this.view.isSmartPhone) {
            this.cancelCommand = new Command((Control)this.screen, 1, 10);
            this.cancelCommand.setText(UIMessages.Cancel);
            this.cancelCommand.setLongLabel(UIMessages.Cancel);
            this.cancelCommand.addSelectionListener((SelectionListener)this);
        }
        this.setButtons(0, 2, 0);
        this.screen.layout();
    }

    protected void refresh() {
        if (this.view.isSmartPhone) {
            this.cancelCommand.setEnabled(true);
        }
        this.cancelButton.setEnabled(true);
        this.featureName.setText("");
        this.featureProgress.setSelection(0);
        this.overallProgress.setSelection(0);
        this.screen.layout();
    }

    protected void action() {
        try {
            if (this.view.targetSite == null) {
                this.view.targetSite = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites()[0];
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (this.view.targetSite == null) {
            System.out.println("Error: error to get local site for installation.");
            return;
        }
        this.totalInstallFeaturesCount = 0;
        int i = 0;
        while (i < this.view.availableFeatures.size()) {
            if (((FeatureWrap)this.view.availableFeatures.elementAt(i)).isSelected()) {
                ++this.totalInstallFeaturesCount;
            }
            ++i;
        }
        this.overallProgress.setMaximum(this.totalInstallFeaturesCount);
        this.installFeatureMonitor = new UpdateMonitor();
        this.installLog = new StringBuffer();
        this.installFeaturesThread = new InstallFeatureThread("", this.view.targetSite, this.view.availableFeatures, this.view.installedFeatures, this.installLog, this.installFeatureMonitor);
        this.installFeaturesThread.start();
        this.setDefaultFocus();
        Display.getCurrent().timerExec(400, new Runnable(){

            public void run() {
                if (InstallingScreen.this.installFeaturesThread.isFinished()) {
                    if (InstallingScreen.this.isExisted) {
                        return;
                    }
                    InstallingScreen.this.isExisted = true;
                    if (InstallingScreen.this.installFeaturesThread.getDoneWorksCount() == InstallingScreen.this.totalInstallFeaturesCount) {
                        InstallingScreen.this.featureName.setText(NLS.bind((String)UIMessages.FeaturesInstalled, (Object[])new Object[]{new Integer(InstallingScreen.this.totalInstallFeaturesCount).toString()}));
                        InstallingScreen.this.screen.layout();
                        InstallingScreen.this.featureProgress.setSelection(10);
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.totalInstallFeaturesCount);
                        InstallingScreen.this.view.enableRestartCommand = true;
                        if (InstallingScreen.this.installFeaturesThread.isJvmInUpdateList()) {
                            MessageBox mb1 = new MessageBox(InstallingScreen.this.screen.getShell(), 194);
                            mb1.setText(UIMessages.ConfirmRestart);
                            mb1.setMessage(NLS.bind((String)UIMessages.NeedRestartManually, (Object[])InstallingScreen.this.view.RuntimeName));
                            if (mb1.open() == 64) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(0));
                                PlatformUI.getWorkbench().close();
                            }
                        } else if (InstallingScreen.this.installFeaturesThread.isOldVersionReplaced()) {
                            MessageBox mb2 = new MessageBox(InstallingScreen.this.screen.getShell(), 194);
                            mb2.setText(UIMessages.ConfirmRestart);
                            mb2.setMessage(NLS.bind((String)UIMessages.RecommendToRestart, (Object[])InstallingScreen.this.view.RuntimeName));
                            if (mb2.open() == 64) {
                                System.getProperties().put("eworkbench.returnCode", new Integer(1));
                                PlatformUI.getWorkbench().close();
                            }
                        } else {
                            MessageBox mb4 = new MessageBox(InstallingScreen.this.screen.getShell(), 34);
                            mb4.setText(UIMessages.InstallStatus);
                            mb4.setMessage(NLS.bind((String)UIMessages.InstallCompleted, (Object[])InstallingScreen.this.view.RuntimeName));
                            mb4.open();
                        }
                    } else {
                        InstallingScreen.this.featureProgress.setSelection((int)(10.0 * InstallingScreen.this.installFeatureMonitor.getDoneWorksCount() / (double)InstallingScreen.this.installFeatureMonitor.getTotalWorksCount()));
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.installFeaturesThread.getDoneWorksCount());
                        UpdateCore.log((String)UIMessages.InstallNotCompleted, null);
                        UpdateCore.log((String)InstallingScreen.this.installLog.toString(), null);
                        MessageBox mb2 = new MessageBox(InstallingScreen.this.screen.getShell(), 33);
                        mb2.setText(UIMessages.InstallStatus);
                        mb2.setMessage(UIMessages.InstallNotCompleted);
                        mb2.open();
                    }
                    InstallingScreen.this.isExisted = false;
                    if (InstallingScreen.this.view.isSmartPhone) {
                        InstallingScreen.this.cancelCommand.setEnabled(false);
                    }
                    InstallingScreen.this.cancelButton.setEnabled(false);
                    InstallingScreen.this.installFeaturesThread = null;
                    InstallingScreen.this.setVisible(false);
                    NormalView normalView = InstallingScreen.this.view;
                    ((Object)((Object)InstallingScreen.this.view)).getClass();
                    ((Object)((Object)InstallingScreen.this.view)).getClass();
                    normalView.showScreen(0, true);
                } else {
                    if (InstallingScreen.this.installFeaturesThread.isAlive()) {
                        InstallingScreen.this.featureName.setText(InstallingScreen.this.installFeaturesThread.getCurrentFeatureName());
                        InstallingScreen.this.screen.layout();
                        InstallingScreen.this.featureProgress.setSelection((int)(10.0 * InstallingScreen.this.installFeatureMonitor.getDoneWorksCount() / (double)InstallingScreen.this.installFeatureMonitor.getTotalWorksCount()));
                        InstallingScreen.this.overallProgress.setSelection(InstallingScreen.this.installFeaturesThread.getDoneWorksCount());
                    }
                    Display.getCurrent().timerExec(300, (Runnable)this);
                }
            }
        });
    }

    protected void setDefaultFocus() {
        if (this.view.isSmartPhone) {
            // empty if block
        }
        this.cancelButton.setFocus();
    }

    public void widgetSelected(SelectionEvent e) {
        if (!(e.widget != this.cancelButton && e.widget != this.cancelCommand || this.installFeaturesThread == null || this.installFeaturesThread.isFinished())) {
            this.installFeatureMonitor.setCanceled(true);
        }
    }

    private class InstallFeatureThread
    extends Thread {
        private IConfiguredSite site;
        private Vector features;
        private Vector allEarlierFeatures;
        private Vector beSuccessfullyInstalleds;
        private StringBuffer log;
        private IProgressMonitor monitor;
        private int count;
        private String currentFeatureName = "";
        private boolean isThreadFinished = false;
        private boolean isJvmInList = false;
        private boolean isAnythingReplaced = false;

        public InstallFeatureThread(String name, IConfiguredSite configuredSite, Vector availableFeatures, Vector earlierInstalledFeatures, StringBuffer installLog, IProgressMonitor installMonitor) {
            super(name);
            this.site = configuredSite;
            this.features = availableFeatures;
            this.allEarlierFeatures = earlierInstalledFeatures;
            this.log = installLog;
            this.monitor = installMonitor;
            this.count = 0;
            this.beSuccessfullyInstalleds = new Vector();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block33: {
                block32: {
                    block30: {
                        block31: {
                            this.isThreadFinished = false;
                            this.isJvmInList = false;
                            this.isAnythingReplaced = false;
                            i = 0;
                            try {
                                try {
                                    fw = null;
                                    operationFactory = (OperationFactory)OperationsManager.getOperationFactory();
                                    i = 0;
                                    while (i < this.features.size()) {
                                        block29: {
                                            fw = (FeatureWrap)this.features.elementAt(i);
                                            if (fw.isSelected()) {
                                                try {
                                                    if (!this.monitor.isCanceled()) {
                                                        this.currentFeatureName = fw.getShowedName();
                                                        operationFactory.createInstallOperation(this.site, fw.getFeature(), null, null, null).execute(this.monitor, null);
                                                        if (!this.isJvmInList && fw.getVID().getIdentifier().startsWith(ManageScreen.JVM_LIB_FEATURE_NAME)) {
                                                            this.isJvmInList = true;
                                                        }
                                                        fw.releaseFeature();
                                                        try {
                                                            if (this.features.size() >= 10) {
                                                                InstallFeatureThread.sleep(500L);
                                                            } else {
                                                                InstallFeatureThread.sleep(100L);
                                                            }
                                                        }
                                                        catch (InterruptedException v0) {}
                                                        ++this.count;
                                                        this.beSuccessfullyInstalleds.add(fw.getVID());
                                                        break block29;
                                                    }
                                                    this.isThreadFinished = true;
                                                }
                                                catch (CoreException ce) {
                                                    if (!(ce instanceof InstallAbortedException)) {
                                                        this.log.append(fw.getShowedName()).append("\n");
                                                        ce.printStackTrace();
                                                        break block29;
                                                    }
                                                    this.isThreadFinished = true;
                                                }
                                                var5_6 = null;
                                                if (this.beSuccessfullyInstalleds.size() <= 0) break block30;
                                                this.removeOldVersion(this.beSuccessfullyInstalleds);
                                                break block31;
                                            }
                                        }
                                        ++i;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    ** GOTO lbl-1000
                                }
                            }
                            catch (Throwable var6_15) {
                                var5_7 = null;
                                if (this.beSuccessfullyInstalleds.size() > 0) {
                                    this.removeOldVersion(this.beSuccessfullyInstalleds);
                                    ConfiguratorUtils.getCurrentPlatformConfiguration().refresh();
                                    if (!this.isAnythingReplaced) {
                                        OperationsManager.applyChangesNow();
                                    }
                                }
                                j = i;
                                break block32;
                            }
                        }
                        ConfiguratorUtils.getCurrentPlatformConfiguration().refresh();
                        if (!this.isAnythingReplaced) {
                            OperationsManager.applyChangesNow();
                        }
                    }
                    j = i;
                    while (true) {
                        if (j >= this.features.size()) break;
                        fw = (FeatureWrap)this.features.elementAt(j);
                        if (fw.isSelected()) {
                            this.log.append(fw.getShowedName()).append("\n");
                        }
                        ++j;
                    }
                    this.isThreadFinished = true;
                    return;
                }
                while (true) {
                    if (j >= this.features.size()) {
                        this.isThreadFinished = true;
                        throw var6_15;
                    }
                    fw = (FeatureWrap)this.features.elementAt(j);
                    if (fw.isSelected()) {
                        this.log.append(fw.getShowedName()).append("\n");
                    }
                    ++j;
                }
lbl-1000:
                // 2 sources

                {
                    var5_8 = null;
                    if (this.beSuccessfullyInstalleds.size() <= 0) break block33;
                    this.removeOldVersion(this.beSuccessfullyInstalleds);
                }
                ConfiguratorUtils.getCurrentPlatformConfiguration().refresh();
                if (!this.isAnythingReplaced) {
                    OperationsManager.applyChangesNow();
                }
            }
            j = i;
            while (true) {
                if (j >= this.features.size()) {
                    this.isThreadFinished = true;
                    return;
                }
                fw = (FeatureWrap)this.features.elementAt(j);
                if (fw.isSelected()) {
                    this.log.append(fw.getShowedName()).append("\n");
                }
                ++j;
            }
        }

        private void removeOldVersion(Vector newInstalledFeatureVIDs) {
            try {
                Object[] allEarlierFeatures_A = this.allEarlierFeatures.toArray();
                OperationFactory operationFactory = (OperationFactory)OperationsManager.getOperationFactory();
                IUnconfigureAndUninstallFeatureOperation unconfigureAndUninstallOperation = null;
                int i = 0;
                while (i < newInstalledFeatureVIDs.size()) {
                    VersionedIdentifier newInstalledVID = (VersionedIdentifier)newInstalledFeatureVIDs.elementAt(i);
                    try {
                        int j = 0;
                        while (j < allEarlierFeatures_A.length) {
                            IFeatureReference earlierFeature = (IFeatureReference)allEarlierFeatures_A[j];
                            if (earlierFeature != null && newInstalledVID.getIdentifier().equals(earlierFeature.getVersionedIdentifier().getIdentifier()) && newInstalledVID.getVersion().isGreaterThan(earlierFeature.getVersionedIdentifier().getVersion())) {
                                unconfigureAndUninstallOperation = operationFactory.createUnconfigureAndUninstallFeatureOperation(earlierFeature.getSite().getCurrentConfiguredSite(), earlierFeature.getFeature(null));
                                unconfigureAndUninstallOperation.execute(null, null);
                                this.isAnythingReplaced = true;
                                allEarlierFeatures_A[j] = null;
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                    }
                    catch (InvocationTargetException ite) {
                        ite.printStackTrace();
                    }
                    ++i;
                }
                SiteManager.getLocalSite().save();
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                return;
            }
        }

        public String getCurrentFeatureName() {
            return this.currentFeatureName;
        }

        public int getDoneWorksCount() {
            return this.count;
        }

        public boolean isFinished() {
            return this.isThreadFinished;
        }

        public boolean isJvmInUpdateList() {
            return this.isJvmInList;
        }

        public boolean isOldVersionReplaced() {
            return this.isAnythingReplaced;
        }
    }
}

