/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IObjectWithState;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.commands.common.NotDefinedException;

abstract class NamedHandleObjectWithState
extends NamedHandleObject
implements IObjectWithState {
    private static final String[] NO_STATE = new String[0];
    private Map states = null;

    protected NamedHandleObjectWithState(String string) {
        super(string);
    }

    public void addState(String string, State state) {
        if (state == null) {
            throw new NullPointerException("Cannot add a null state");
        }
        if (this.states == null) {
            this.states = new HashMap(3);
        }
        this.states.put(string, state);
    }

    public final String getDescription() throws NotDefinedException {
        Object object;
        String string = super.getDescription();
        State state = this.getState("DESCRIPTION");
        if (state != null && (object = state.getValue()) != null) {
            return object.toString();
        }
        return string;
    }

    public final String getName() throws NotDefinedException {
        Object object;
        String string = super.getName();
        State state = this.getState("NAME");
        if (state != null && (object = state.getValue()) != null) {
            return object.toString();
        }
        return string;
    }

    public final State getState(String string) {
        if (this.states == null || this.states.isEmpty()) {
            return null;
        }
        return (State)this.states.get(string);
    }

    public final String[] getStateIds() {
        if (this.states == null || this.states.isEmpty()) {
            return NO_STATE;
        }
        Set set = this.states.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void removeState(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot remove a null id");
        }
        if (this.states != null) {
            this.states.remove(string);
            if (this.states.isEmpty()) {
                this.states = null;
            }
        }
    }
}

