/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ercp.eworkbench.ApplicationDescriptor;
import org.eclipse.ercp.eworkbench.IApplicationDescriptor;
import org.eclipse.ercp.eworkbench.IApplicationRegistry;
import org.eclipse.ercp.eworkbench.Messages;
import org.eclipse.ercp.eworkbench.eWorkbenchPlugin;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceManager;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.IViewRegistry;

public class DefaultView
extends ViewPart
implements IOpenListener,
SelectionListener {
    public static final String ID_VIEW = "org.eclipse.ercp.eworkbench.DefaultView";
    public static final String ID_VIEW_2 = "org.eclipse.ercp.eworkbench.SimpleDefaultView";
    private Composite parent;
    private TableViewer viewer;
    private IViewRegistry viewReg;
    private Command launchCommand;
    private Command listCommand;
    private Command exitCommand;
    private Command preferenceCommand;
    private String currentPrefPage = null;

    public void createPartControl(Composite composite) {
        this.parent = composite;
        IApplicationRegistry iApplicationRegistry = eWorkbenchPlugin.getDefault().getApplicationRegistry();
        this.viewReg = eWorkbenchPlugin.getDefault().getWorkbench().getViewRegistry();
        this.viewer = new TableViewer(composite, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(false));
        this.viewer.setInput((Object)iApplicationRegistry);
        this.viewer.addOpenListener((IOpenListener)this);
        this.enableLaunchCommand(true);
        this.exitCommand = new Command((Control)composite.getShell(), 7, 0);
        this.exitCommand.setText(Messages.getString("DefaultView.1"));
        this.exitCommand.addSelectionListener((SelectionListener)this);
    }

    private void enablePreferencesCommand(boolean bl) {
        if (bl) {
            this.preferenceCommand = new Command((Control)this.parent.getShell(), 2, 10);
            this.preferenceCommand.setText(Messages.getString("DefaultView.2"));
            this.preferenceCommand.addSelectionListener((SelectionListener)this);
        } else if (this.preferenceCommand != null) {
            this.preferenceCommand.dispose();
        }
    }

    private void enableLaunchCommand(boolean bl) {
        if (bl) {
            this.launchCommand = new Command((Control)this.parent.getShell(), 2, 10);
            this.launchCommand.setText(Messages.getString("DefaultView.3"));
            this.launchCommand.setLongLabel(Messages.getString("DefaultView.4"));
            this.launchCommand.addSelectionListener((SelectionListener)this);
        } else if (this.launchCommand != null) {
            this.launchCommand.dispose();
        }
    }

    private void enableListCommand(boolean bl) {
        if (bl) {
            this.listCommand = new Command((Control)this.parent.getShell(), 2, 1);
            this.listCommand.setText(Messages.getString("DefaultView.5"));
            this.listCommand.setLongLabel(Messages.getString("DefaultView.6"));
            this.listCommand.addSelectionListener((SelectionListener)this);
        } else if (this.listCommand != null) {
            this.listCommand.dispose();
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void open(OpenEvent openEvent) {
        this.launchSelection(openEvent.getSelection());
    }

    private void launchSelection(ISelection iSelection) {
        String string;
        ApplicationDescriptor applicationDescriptor;
        Object object;
        if (iSelection.isEmpty()) {
            return;
        }
        if (iSelection instanceof IStructuredSelection) {
            object = (IStructuredSelection)iSelection;
            applicationDescriptor = (ApplicationDescriptor)object.getFirstElement();
        } else if (iSelection instanceof ApplicationDescriptor) {
            applicationDescriptor = (ApplicationDescriptor)iSelection;
        } else {
            return;
        }
        object = null;
        Point point = this.parent.getSize();
        if (point.x >= point.y && point.x > 640 && point.y > 480 || point.x < point.y && point.y > 640 && point.x > 480) {
            object = applicationDescriptor.getViewId("large");
        }
        if (object == null) {
            object = applicationDescriptor.getViewId("normal");
        }
        if ((string = applicationDescriptor.getLabel()) != null) {
            this.parent.getShell().setText(string);
        }
        try {
            eWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView((String)object);
            this.enablePreferencesCommand(this.hasPrefs(applicationDescriptor));
            this.enableLaunchCommand(false);
            this.enableListCommand(true);
        }
        catch (PartInitException partInitException) {
            System.out.println((Object)partInitException);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.launchCommand) {
            this.launchSelection(this.viewer.getSelection());
        } else if (selectionEvent.widget == this.listCommand) {
            try {
                this.parent.getShell().setText(Messages.getString("eRCP_Workbench"));
                eWorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID_VIEW);
                this.enableLaunchCommand(true);
                this.enableListCommand(false);
                this.enablePreferencesCommand(false);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        } else if (selectionEvent.widget == this.exitCommand) {
            eWorkbenchPlugin.getDefault().getWorkbench().close();
            eWorkbenchPlugin.getDefault().getWorkbench().getDisplay().dispose();
        } else if (selectionEvent.widget == this.preferenceCommand) {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn(null, (String)this.currentPrefPage, null, null);
            preferenceDialog.open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private boolean hasPrefs(ApplicationDescriptor applicationDescriptor) {
        List list = ((WorkbenchPreferenceManager)PlatformUI.getWorkbench().getPreferenceManager()).getElements(0);
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WorkbenchPreferenceNode workbenchPreferenceNode = (WorkbenchPreferenceNode)iterator.next();
                if (!workbenchPreferenceNode.getPluginId().equals(applicationDescriptor.getPluginId())) continue;
                this.currentPrefPage = workbenchPreferenceNode.getId();
                return true;
            }
        }
        return false;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof IApplicationRegistry) {
                return ((IApplicationRegistry)object).getApplications();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private HashMap imageCache = new HashMap(5);
        private boolean markDefault;

        public ViewLabelProvider() {
            this(true);
        }

        public ViewLabelProvider(boolean bl) {
            this.markDefault = bl;
        }

        public final Image getImage(Object object) {
            if (object instanceof IApplicationDescriptor) {
                Image image;
                IApplicationDescriptor iApplicationDescriptor = (IApplicationDescriptor)object;
                ImageDescriptor imageDescriptor = iApplicationDescriptor.getImageDescriptor();
                if (imageDescriptor == null) {
                    imageDescriptor = WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_DEF_PERSPECTIVE");
                }
                if ((image = (Image)this.imageCache.get(imageDescriptor)) == null) {
                    image = imageDescriptor.createImage();
                    this.imageCache.put(imageDescriptor, image);
                }
                return image;
            }
            return null;
        }

        public final void dispose() {
            Iterator iterator = this.imageCache.values().iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
            this.imageCache.clear();
        }

        public final String getText(Object object) {
            if (object instanceof IApplicationDescriptor) {
                IApplicationDescriptor iApplicationDescriptor = (IApplicationDescriptor)object;
                String string = iApplicationDescriptor.getLabel();
                return string;
            }
            return Messages.getString("AppNameUnknown");
        }

        public final Image getColumnImage(Object object, int n) {
            return this.getImage(object);
        }

        public final String getColumnText(Object object, int n) {
            return this.getText(object);
        }
    }
}

