/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class TrustEngineListener {
    private static volatile TrustEngineListener instance;
    private final BundleContext context;
    private final ServiceTracker authorizationTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    TrustEngineListener(BundleContext bundleContext) {
        this.context = bundleContext;
        String string = FrameworkProperties.getProperty("osgi.signedcontent.authorization.engine");
        Filter filter = null;
        if (string != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                filter = FrameworkUtil.createFilter(stringBuffer.append(clazz.getName()).append(")(").append("osgi.signedcontent.authorization.engine").append("=").append(string).append("))").toString());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                SignedBundleHook.log("Invalid authorization filter", 2, invalidSyntaxException);
            }
        }
        if (filter != null) {
            this.authorizationTracker = new ServiceTracker(bundleContext, filter, null);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.authorizationTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        }
        this.authorizationTracker.open();
        instance = this;
    }

    public static TrustEngineListener getInstance() {
        return instance;
    }

    void stopTrustEngineListener() {
        this.authorizationTracker.close();
        instance = null;
    }

    public void addedTrustAnchor(Certificate certificate) {
        Bundle[] bundleArray = this.context.getBundles();
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        int n = 0;
        while (n < bundleArray.length) {
            SignedContentImpl signedContentImpl = this.getSignedContent(bundleArray[n]);
            if (signedContentImpl != null && signedContentImpl.isSigned()) {
                SignerInfo[] signerInfoArray = signedContentImpl.getSignerInfos();
                int n2 = 0;
                while (n2 < signerInfoArray.length) {
                    SignerInfo signerInfo;
                    if (signerInfoArray[n2].getTrustAnchor() == null) {
                        hashSet.add(bundleArray[n]);
                    }
                    if ((signerInfo = signedContentImpl.getTSASignerInfo(signerInfoArray[n2])) != null && signerInfo.getTrustAnchor() == null) {
                        hashSet.add(bundleArray[n]);
                    }
                    ++n2;
                }
            }
            if (hashSet.contains(bundleArray[n])) {
                SignedBundleFile.determineTrust(signedContentImpl, 2);
                this.checkAuthorization(signedContentImpl, bundleArray[n]);
            }
            ++n;
        }
        if (hashSet.size() > 0) {
            this.resolveBundles(hashSet.toArray(new Bundle[hashSet.size()]), false);
        }
    }

    private void checkAuthorization(SignedContentImpl signedContentImpl, Bundle bundle) {
        AuthorizationEngine authorizationEngine = this.getAuthorizationEngine();
        if (authorizationEngine != null) {
            authorizationEngine.authorize(signedContentImpl, bundle);
        }
    }

    AuthorizationEngine getAuthorizationEngine() {
        return (AuthorizationEngine)this.authorizationTracker.getService();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveBundles(Bundle[] bundleArray, boolean bl) {
        ServiceReference serviceReference;
        Class<?> clazz = class$1;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$1 = clazz2;
        }
        if ((serviceReference = this.context.getServiceReference(clazz.getName())) == null) {
            return;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(serviceReference);
        if (packageAdmin == null) {
            return;
        }
        try {
            if (bl) {
                packageAdmin.refreshPackages(bundleArray);
            } else {
                packageAdmin.resolveBundles(bundleArray);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.context.ungetService(serviceReference);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.context.ungetService(serviceReference);
        }
    }

    public void removedTrustAnchor(Certificate certificate) {
        Object object;
        Object object2;
        Bundle[] bundleArray = this.context.getBundles();
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        HashSet<SignerInfo> hashSet2 = new HashSet<SignerInfo>();
        int n = 0;
        while (n < bundleArray.length) {
            object2 = this.getSignedContent(bundleArray[n]);
            if (object2 != null && ((SignedContentImpl)object2).isSigned()) {
                object = ((SignedContentImpl)object2).getSignerInfos();
                int n2 = 0;
                while (n2 < ((SignerInfo[])object).length) {
                    SignerInfo signerInfo;
                    if (certificate.equals(object[n2].getTrustAnchor())) {
                        hashSet2.add(object[n2]);
                        hashSet.add(bundleArray[n]);
                    }
                    if ((signerInfo = ((SignedContentImpl)object2).getTSASignerInfo(object[n2])) != null && certificate.equals(signerInfo.getTrustAnchor())) {
                        hashSet.add(bundleArray[n]);
                        hashSet2.add(signerInfo);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            ((SignerInfoImpl)iterator.next()).setTrustAnchor(null);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (Bundle)iterator.next();
            object = this.getSignedContent((Bundle)object2);
            SignedBundleFile.determineTrust((SignedContentImpl)object, 2);
            this.checkAuthorization((SignedContentImpl)object, (Bundle)object2);
        }
        if (hashSet.size() > 0) {
            this.resolveBundles(hashSet.toArray(new Bundle[hashSet.size()]), true);
        }
    }

    private SignedContentImpl getSignedContent(Bundle bundle) {
        BaseData baseData = (BaseData)((AbstractBundle)bundle).getBundleData();
        SignedStorageHook signedStorageHook = (SignedStorageHook)baseData.getStorageHook(SignedStorageHook.KEY);
        if (signedStorageHook == null) {
            return null;
        }
        return (SignedContentImpl)signedStorageHook.getSignedContent();
    }
}

