/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.image.GIFFileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LEDataOutputStream;

public abstract class FileFormat {
    static final String FORMAT_PACKAGE = "org.eclipse.swt.internal.image";
    static final String FORMAT_SUFFIX = "FileFormat";
    static final String[] FORMATS = new String[]{"WinBMP", "WinBMP", "GIF", "WinICO", "JPEG", "PNG", "TIFF", "OS2BMP"};
    LEDataInputStream inputStream;
    LEDataOutputStream outputStream;
    ImageLoader loader;
    int compression;

    byte[] bitInvertData(byte[] data, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            data[i] = (byte)(255 - data[i - startIndex]);
        }
        return data;
    }

    abstract boolean isFileFormat(LEDataInputStream var1);

    abstract ImageData[] loadFromByteStream();

    public ImageData[] loadFromStream(LEDataInputStream stream) {
        try {
            this.inputStream = stream;
            return this.loadFromByteStream();
        }
        catch (Exception e) {
            SWT.error(39, e);
            return null;
        }
    }

    public static ImageData[] load(InputStream is, ImageLoader loader) {
        GIFFileFormat fileFormat = null;
        fileFormat = new GIFFileFormat();
        LEDataInputStream stream = new LEDataInputStream(is);
        if (((FileFormat)fileFormat).isFileFormat(stream)) {
            fileFormat.loader = loader;
            return fileFormat.loadFromStream(stream);
        }
        return null;
    }

    public static void save(OutputStream os, int format, ImageLoader loader) {
        if (format < 0 || format >= FORMATS.length) {
            SWT.error(42);
        }
        if (FORMATS[format] == null) {
            SWT.error(42);
        }
        ImageData data = loader.data[0];
        LEDataOutputStream stream = new LEDataOutputStream(os);
        FileFormat fileFormat = null;
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.image." + FORMATS[format] + FORMAT_SUFFIX);
            fileFormat = (FileFormat)clazz.newInstance();
        }
        catch (Exception e) {
            SWT.error(42);
        }
        fileFormat.unloadIntoStream(data, stream);
    }

    abstract void unloadIntoByteStream(ImageData var1);

    public void unloadIntoStream(ImageData image, LEDataOutputStream stream) {
        try {
            this.outputStream = stream;
            this.unloadIntoByteStream(image);
            this.outputStream.flush();
        }
        catch (Exception e) {
            try {
                this.outputStream.flush();
            }
            catch (Exception f) {
                // empty catch block
            }
            SWT.error(39, e);
        }
    }
}

