/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.misc.Policy;

public final class HandlerService
implements IHandlerService {
    private final CommandManager commandManager;

    static {
        Command.DEBUG_HANDLERS = Policy.DEBUG_HANDLERS_VERBOSE;
        Command.DEBUG_HANDLERS_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    }

    public HandlerService(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    private final void updateCommand(String string, IHandlerActivation iHandlerActivation) {
        Command command = this.commandManager.getCommand(string);
        if (iHandlerActivation == null) {
            command.setHandler(null);
        } else {
            command.setHandler(iHandlerActivation.getHandler());
        }
    }

    public final IHandlerActivation activateHandler(String string, IHandler iHandler) {
        HandlerActivation handlerActivation = new HandlerActivation(string, iHandler, null, 1, this);
        this.updateCommand(string, handlerActivation);
        return handlerActivation;
    }

    public final IHandlerActivation activateHandler(String string, IHandler iHandler, Expression expression, int n) {
        if (expression == null) {
            throw new NullPointerException("The expression cannot be null");
        }
        HandlerActivation handlerActivation = new HandlerActivation(string, iHandler, expression, n, this);
        this.updateCommand(string, handlerActivation);
        return handlerActivation;
    }

    public final void deactivateHandler(IHandlerActivation iHandlerActivation) {
        if (iHandlerActivation.getHandlerService() == this) {
            this.updateCommand(iHandlerActivation.getCommandId(), null);
        }
    }

    public final void deactivateHandlers(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IHandlerActivation iHandlerActivation = (IHandlerActivation)iterator.next();
            this.deactivateHandler(iHandlerActivation);
        }
    }

    public final IEvaluationContext getCurrentState() {
        return null;
    }

    public final void readRegistry() {
    }
}

