/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.LocationHelper;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;

public class LocationManager {
    private static Location installLocation = null;
    private static Location configurationLocation = null;
    private static Location userLocation = null;
    private static Location instanceLocation = null;
    private static Location eclipseHomeLocation = null;
    public static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    public static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_INSTANCE_AREA_DEFAULT = "osgi.instance.area.default";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_USER_AREA_DEFAULT = "osgi.user.area.default";
    public static final String PROP_MANIFEST_CACHE = "osgi.manifest.cache";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_USER_DIR = "user.dir";
    public static final String PROP_HOME_LOCATION_AREA = "eclipse.home.location";
    static final String PROP_LAUNCHER = "eclipse.launcher";
    public static final String BUNDLES_DIR = "bundles";
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    public static final String BUNDLE_DATA_FILE = ".bundledata";
    public static final String MANIFESTS_DIR = "manifests";
    public static final String CONFIG_FILE = "config.ini";
    public static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String CONFIG_DIR = "configuration";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";

    public static URL buildURL(String string, boolean bl) {
        return LocationHelper.buildURL(string, bl);
    }

    private static void mungeConfigurationLocation() {
        String string = FrameworkProperties.getProperty(PROP_CONFIG_AREA);
        if (string != null && string.endsWith(".cfg")) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = string.lastIndexOf(92);
            }
            string = string.substring(0, n + 1);
            FrameworkProperties.setProperty(PROP_CONFIG_AREA, string);
        }
    }

    public static void initializeLocations() {
        String string;
        Object object;
        URL uRL;
        installLocation = LocationManager.buildLocation(PROP_INSTALL_AREA, null, "", true, false);
        Location location = LocationManager.buildLocation(PROP_USER_AREA_DEFAULT, null, "", false, false);
        URL uRL2 = uRL = location == null ? null : location.getURL();
        if (uRL == null) {
            uRL = LocationManager.buildURL(new File(FrameworkProperties.getProperty(PROP_USER_HOME), "user").getAbsolutePath(), true);
        }
        userLocation = LocationManager.buildLocation(PROP_USER_AREA, uRL, "", false, false);
        location = LocationManager.buildLocation(PROP_INSTANCE_AREA_DEFAULT, null, "", false, false);
        URL uRL3 = uRL = location == null ? null : location.getURL();
        if (uRL == null) {
            uRL = LocationManager.buildURL(new File(FrameworkProperties.getProperty(PROP_USER_DIR), "workspace").getAbsolutePath(), true);
        }
        instanceLocation = LocationManager.buildLocation(PROP_INSTANCE_AREA, uRL, "", false, false);
        LocationManager.mungeConfigurationLocation();
        location = LocationManager.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "", false, false);
        URL uRL4 = uRL = location == null ? null : location.getURL();
        if (uRL == null) {
            uRL = LocationManager.buildURL(LocationManager.computeDefaultConfigurationLocation(), true);
        }
        configurationLocation = LocationManager.buildLocation(PROP_CONFIG_AREA, uRL, "", false, false);
        URL uRL5 = LocationManager.computeSharedConfigurationLocation();
        if (uRL5 != null && !((Object)uRL5).equals(configurationLocation.getURL())) {
            object = new BasicLocation(null, uRL5, true);
            ((BasicLocation)configurationLocation).setParent((Location)object);
        }
        LocationManager.initializeDerivedConfigurationLocations();
        if (FrameworkProperties.getProperty(PROP_HOME_LOCATION_AREA) == null && (string = LocationManager.getEclipseHomeLocation((String)(object = FrameworkProperties.getProperty(PROP_LAUNCHER)))) != null) {
            FrameworkProperties.setProperty(PROP_HOME_LOCATION_AREA, string);
        }
        if (FrameworkProperties.getProperty(PROP_HOME_LOCATION_AREA) == null && FrameworkProperties.getProperty(PROP_INSTALL_AREA) != null) {
            FrameworkProperties.setProperty(PROP_HOME_LOCATION_AREA, FrameworkProperties.getProperty(PROP_INSTALL_AREA));
        }
        eclipseHomeLocation = LocationManager.buildLocation(PROP_HOME_LOCATION_AREA, null, "", true, true);
    }

    private static String getEclipseHomeLocation(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.getParent() == null) {
            return null;
        }
        File file2 = new File(file.getParent());
        String string2 = "macosx";
        if (string2.equals(EclipseEnvironmentInfo.getDefault().getOS())) {
            file2 = LocationManager.getMacOSEclipsoeHomeLocation(file2);
        }
        return file2.exists() && file2.isDirectory() ? file2.getAbsolutePath() : null;
    }

    private static File getMacOSEclipsoeHomeLocation(File file) {
        if (!file.getName().equalsIgnoreCase("macos")) {
            return file;
        }
        String string = file.getParent();
        if (string != null) {
            string = new File(string).getParent();
        }
        if (string != null) {
            string = new File(string).getParent();
        }
        return string == null ? null : new File(string);
    }

    private static Location buildLocation(String string, URL uRL, String string2, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        String string3 = FrameworkProperties.clearProperty(string);
        String string4 = FrameworkProperties.getProperty(String.valueOf(string) + READ_ONLY_AREA_SUFFIX);
        boolean bl4 = bl3 = string4 == null ? bl : Boolean.valueOf(string4);
        if (string3 == null) {
            return new BasicLocation(string, uRL, string4 != null || !bl2 ? bl3 : !LocationManager.canWrite(uRL));
        }
        String string5 = string3.trim();
        if (string5.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (string5.equalsIgnoreCase(NO_DEFAULT)) {
            return new BasicLocation(string, null, bl3);
        }
        if (string5.startsWith(USER_HOME)) {
            object = LocationManager.substituteVar(string3, USER_HOME, PROP_USER_HOME);
            string3 = new File((String)object, string2).getAbsolutePath();
        } else if (string5.startsWith(USER_DIR)) {
            object = LocationManager.substituteVar(string3, USER_DIR, PROP_USER_DIR);
            string3 = new File((String)object, string2).getAbsolutePath();
        }
        object = LocationManager.buildURL(string3, true);
        BasicLocation basicLocation = null;
        if (object != null) {
            basicLocation = new BasicLocation(string, null, string4 != null || !bl2 ? bl3 : !LocationManager.canWrite((URL)object));
            basicLocation.setURL((URL)object, false);
        }
        return basicLocation;
    }

    private static String substituteVar(String string, String string2, String string3) {
        String string4 = FrameworkProperties.getProperty(string3, "");
        return String.valueOf(string4) + string.substring(string2.length());
    }

    private static void initializeDerivedConfigurationLocations() {
        if (FrameworkProperties.getProperty(PROP_MANIFEST_CACHE) == null) {
            FrameworkProperties.setProperty(PROP_MANIFEST_CACHE, LocationManager.getConfigurationFile(MANIFESTS_DIR).getAbsolutePath());
        }
    }

    private static URL computeInstallConfigurationLocation() {
        String string = FrameworkProperties.getProperty(PROP_INSTALL_AREA);
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    private static URL computeSharedConfigurationLocation() {
        String string = FrameworkProperties.getProperty(PROP_SHARED_CONFIG_AREA);
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            if (uRL.getPath().startsWith("/")) {
                return uRL;
            }
            URL uRL2 = installLocation.getURL();
            if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
                return uRL;
            }
            uRL = new URL(uRL2, uRL.getPath());
            FrameworkProperties.setProperty(PROP_SHARED_CONFIG_AREA, uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private static String computeDefaultConfigurationLocation() {
        URL uRL = LocationManager.computeInstallConfigurationLocation();
        if (uRL != null && "file".equals(uRL.getProtocol())) {
            File file = new File(uRL.getFile());
            File file2 = new File(file, CONFIG_DIR);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (file2.exists() && AdaptorUtil.canWrite(file2)) {
                return file2.getAbsolutePath();
            }
        }
        return LocationManager.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    private static boolean canWrite(URL uRL) {
        if (uRL != null && "file".equals(uRL.getProtocol())) {
            File file = new File(uRL.getFile());
            if (!file.exists()) {
                file.mkdirs();
            }
            if (file.exists() && AdaptorUtil.canWrite(file)) {
                return true;
            }
        }
        return false;
    }

    private static String computeDefaultUserAreaLocation(String string) {
        Object object;
        int n;
        String string2 = FrameworkProperties.getProperty(PROP_INSTALL_AREA);
        URL uRL = LocationManager.buildURL(string2, true);
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getFile());
        try {
            n = file.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            n = file.getAbsolutePath().hashCode();
        }
        if (n < 0) {
            n = -n;
        }
        String string3 = String.valueOf(n);
        String string4 = ".eclipse";
        File file2 = new File(file, PRODUCT_SITE_MARKER);
        if (file2.exists()) {
            object = new Properties();
            try {
                String string5;
                ((Properties)object).load(new FileInputStream(file2));
                String string6 = ((Properties)object).getProperty(PRODUCT_SITE_ID);
                if (string6 == null || string6.trim().length() == 0) {
                    string6 = ECLIPSE;
                }
                if ((string5 = ((Properties)object).getProperty(PRODUCT_SITE_VERSION)) == null || string5.trim().length() == 0) {
                    string5 = "";
                }
                string4 = String.valueOf(string4) + File.separator + string6 + "_" + string5 + "_" + string3;
            }
            catch (IOException iOException) {
                string4 = String.valueOf(string4) + File.separator + string3;
            }
        } else {
            string4 = String.valueOf(string4) + File.separator + string3;
        }
        object = FrameworkProperties.getProperty(PROP_USER_HOME);
        return new File((String)object, String.valueOf(string4) + "/" + string).getAbsolutePath();
    }

    public static Location getUserLocation() {
        return userLocation;
    }

    public static Location getConfigurationLocation() {
        return configurationLocation;
    }

    public static Location getInstallLocation() {
        return installLocation;
    }

    public static Location getInstanceLocation() {
        return instanceLocation;
    }

    public static Location getEclipseHomeLocation() {
        return eclipseHomeLocation;
    }

    public static File getOSGiConfigurationDir() {
        return new File(configurationLocation.getURL().getFile(), "org.eclipse.osgi");
    }

    public static File getConfigurationFile(String string) {
        File file = LocationManager.getOSGiConfigurationDir();
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, string);
    }
}

