/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.IModel;
import org.eclipse.core.runtime.internal.adaptor.IPluginInfo;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler
implements IModel {
    private static ServiceTracker xmlTracker = null;
    private PluginInfo manifestInfo = new PluginInfo();
    private BundleContext context;
    private FrameworkAdaptor adaptor;
    private Version target;
    private static final Version TARGET21 = new Version(2, 1, 0);
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    Locator locator = null;
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_RUNTIME_STATE = 3;
    private static final int PLUGIN_REQUIRES_STATE = 4;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 5;
    private static final int PLUGIN_EXTENSION_STATE = 6;
    private static final int RUNTIME_LIBRARY_STATE = 7;
    private static final int LIBRARY_EXPORT_STATE = 8;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 9;
    private static final int FRAGMENT_STATE = 11;

    public PluginParser(FrameworkAdaptor frameworkAdaptor, BundleContext bundleContext, Version version) {
        this.context = bundleContext;
        this.adaptor = frameworkAdaptor;
        this.target = version;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void endDocument() {
    }

    public void endElement(String string, String string2, String string3) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                if (!string2.equals("runtime")) break;
                this.stateStack.pop();
                break;
            }
            case 4: {
                if (!string2.equals("requires")) break;
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 5: {
                if (!string2.equals("extension-point")) break;
                this.stateStack.pop();
                break;
            }
            case 6: {
                if (!string2.equals("extension")) break;
                this.stateStack.pop();
                break;
            }
            case 7: {
                if (!string2.equals("library")) break;
                String string4 = (String)this.objectStack.pop();
                if (!string4.trim().equals("")) {
                    Vector vector = (Vector)this.objectStack.pop();
                    if (this.manifestInfo.libraries == null) {
                        this.manifestInfo.libraries = new HashMap(3);
                        this.manifestInfo.libraryPaths = new ArrayList(3);
                    }
                    this.manifestInfo.libraries.put(string4, vector);
                    this.manifestInfo.libraryPaths.add(string4.replace('\\', '/'));
                }
                this.stateStack.pop();
                break;
            }
            case 8: {
                if (!string2.equals("export")) break;
                this.stateStack.pop();
                break;
            }
            case 9: {
                if (!string2.equals("import")) break;
                this.stateStack.pop();
            }
        }
    }

    public void error(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logStatus(sAXParseException);
        throw sAXParseException;
    }

    public void handleExtensionPointState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        this.manifestInfo.hasExtensionExtensionPoints = true;
    }

    public void handleExtensionState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        this.manifestInfo.hasExtensionExtensionPoints = true;
    }

    public void handleInitialState(String string, Attributes attributes) {
        if (string.equals("plugin")) {
            this.stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes);
        } else if (string.equals("fragment")) {
            this.manifestInfo.fragment = true;
            this.stateStack.push(new Integer(11));
            this.parseFragmentAttributes(attributes);
        } else {
            this.stateStack.push(new Integer(0));
            this.internalError(string);
        }
    }

    public void handleLibraryExportState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
    }

    public void handleLibraryState(String string, Attributes attributes) {
        if (string.equals("export")) {
            this.stateStack.push(new Integer(8));
            String string2 = (String)this.objectStack.peek();
            if (attributes == null) {
                return;
            }
            String string3 = attributes.getValue("", "name");
            this.objectStack.pop();
            Vector vector = (Vector)this.objectStack.peek();
            this.objectStack.push(string2);
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (vector.contains(string3)) continue;
                    vector.addElement(string4.trim());
                }
            }
            return;
        }
        if (string.equals("packages")) {
            this.stateStack.push(new Integer(0));
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    public void handlePluginState(String string, Attributes attributes) {
        if (string.equals("runtime")) {
            Object e = this.objectStack.peek();
            if (e instanceof PluginInfo && ((PluginInfo)this.objectStack.peek()).libraries != null) {
                this.stateStack.push(new Integer(0));
                return;
            }
            this.stateStack.push(new Integer(3));
            return;
        }
        if (string.equals("requires")) {
            this.stateStack.push(new Integer(4));
            this.objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes);
            return;
        }
        if (string.equals("extension-point")) {
            this.manifestInfo.singleton = true;
            this.stateStack.push(new Integer(5));
            return;
        }
        if (string.equals("extension")) {
            this.manifestInfo.singleton = true;
            this.stateStack.push(new Integer(6));
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    public void handleRequiresImportState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
    }

    public void handleRequiresState(String string, Attributes attributes) {
        if (string.equals("import")) {
            this.parsePluginRequiresImport(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    public void handleRuntimeState(String string, Attributes attributes) {
        if (string.equals("library")) {
            this.stateStack.push(new Integer(7));
            this.parseLibraryAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    private void logStatus(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        string = string == null ? "" : string.substring(1 + string.lastIndexOf("/"));
        String string2 = string.equals("") ? NLS.bind(EclipseAdaptorMsg.parse_error, sAXParseException.getMessage()) : NLS.bind(EclipseAdaptorMsg.parse_errorNameLineColumn, new String[]{string, Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()), sAXParseException.getMessage()});
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string2, 0, sAXParseException, null);
        this.adaptor.getFrameworkLog().log(frameworkLogEntry);
    }

    public synchronized PluginInfo parsePlugin(InputStream inputStream) throws Exception {
        SAXParserFactory sAXParserFactory = PluginParser.acquireXMLParsing(this.context);
        if (sAXParserFactory == null) {
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_CONVERTER_NO_SAX_FACTORY, 0, null, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            return null;
        }
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setNamespaceAware(true);
        try {
            sAXParserFactory.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {}
        sAXParserFactory.setValidating(false);
        sAXParserFactory.newSAXParser().parse(inputStream, (DefaultHandler)this);
        return this.manifestInfo;
    }

    public static SAXParserFactory acquireXMLParsing(BundleContext bundleContext) {
        SAXParserFactory sAXParserFactory;
        if (xmlTracker == null) {
            xmlTracker = new ServiceTracker(bundleContext, "javax.xml.parsers.SAXParserFactory", null);
            xmlTracker.open();
        }
        if ((sAXParserFactory = (SAXParserFactory)xmlTracker.getService()) != null) {
            return sAXParserFactory;
        }
        return SAXParserFactory.newInstance();
    }

    public static void releaseXMLParsing() {
        if (xmlTracker != null) {
            xmlTracker.close();
        }
    }

    public void parseFragmentAttributes(Attributes attributes) {
        this.objectStack.push(this.manifestInfo);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getLocalName(n2);
            String string2 = attributes.getValue(n2).trim();
            if (string.equals("id")) {
                this.manifestInfo.pluginId = string2;
            } else if (string.equals("name")) {
                this.manifestInfo.pluginName = string2;
            } else if (string.equals("version")) {
                this.manifestInfo.version = string2;
            } else if (string.equals("provider-name")) {
                this.manifestInfo.vendor = string2;
            } else if (string.equals("plugin-id")) {
                this.manifestInfo.masterPluginId = string2;
            } else if (string.equals("plugin-version")) {
                this.manifestInfo.masterVersion = string2;
            } else if (string.equals("match")) {
                this.manifestInfo.masterMatch = string2;
            }
            ++n2;
        }
    }

    public void parseLibraryAttributes(Attributes attributes) {
        this.objectStack.push(new Vector());
        String string = attributes.getValue("", "name");
        this.objectStack.push(string);
    }

    public void parsePluginAttributes(Attributes attributes) {
        this.objectStack.push(this.manifestInfo);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getLocalName(n2);
            String string2 = attributes.getValue(n2).trim();
            if (string.equals("id")) {
                this.manifestInfo.pluginId = string2;
            } else if (string.equals("name")) {
                this.manifestInfo.pluginName = string2;
            } else if (string.equals("version")) {
                this.manifestInfo.version = string2;
            } else if (string.equals("vendor-name") || string.equals("provider-name")) {
                this.manifestInfo.vendor = string2;
            } else if (string.equals("class")) {
                this.manifestInfo.pluginClass = string2;
            }
            ++n2;
        }
    }

    public void parsePluginRequiresImport(Attributes attributes) {
        String string;
        if (this.manifestInfo.requires == null) {
            this.manifestInfo.requires = new ArrayList();
        }
        if ((string = attributes.getValue("", "plugin")) == null) {
            return;
        }
        if (string.equals("org.eclipse.core.boot")) {
            return;
        }
        if (string.equals("org.eclipse.core.runtime.compatibility")) {
            this.manifestInfo.compatibilityFound = true;
        }
        String string2 = attributes.getValue("", "version");
        String string3 = attributes.getValue("", "optional");
        String string4 = attributes.getValue("", "export");
        String string5 = attributes.getValue("", "match");
        this.manifestInfo.requires.add(new Prerequisite(string, string2, "true".equalsIgnoreCase(string3), "true".equalsIgnoreCase(string4), string5));
    }

    public void parseRequiresAttributes(Attributes attributes) {
    }

    static String replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string2.length();
        int n2 = string3.length();
        int n3 = string4.indexOf(string2);
        while (n3 != -1) {
            string4 = String.valueOf(string4.substring(0, n3)) + string3 + string4.substring(n3 + n);
            n3 = string4.indexOf(string2, n3 + n2);
        }
        return string4;
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(string2, attributes);
                break;
            }
            case 2: 
            case 11: {
                this.handlePluginState(string2, attributes);
                break;
            }
            case 3: {
                this.handleRuntimeState(string2, attributes);
                break;
            }
            case 4: {
                this.handleRequiresState(string2, attributes);
                break;
            }
            case 5: {
                this.handleExtensionPointState(string2, attributes);
                break;
            }
            case 6: {
                this.handleExtensionState(string2, attributes);
                break;
            }
            case 7: {
                this.handleLibraryState(string2, attributes);
                break;
            }
            case 8: {
                this.handleLibraryExportState(string2, attributes);
                break;
            }
            case 9: {
                this.handleRequiresImportState(string2, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
            }
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    private void internalError(String string) {
        String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_PARSE_UNKNOWNTOP_ELEMENT, string);
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, this.manifestInfo.pluginId == null ? string2 : "Plug-in : " + this.manifestInfo.pluginId + ", " + string2, 0, null, null);
        this.adaptor.getFrameworkLog().log(frameworkLogEntry);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equalsIgnoreCase("eclipse")) {
            this.manifestInfo.schemaVersion = "3.0";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=\"");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equalsIgnoreCase("version")) continue;
                if (!stringTokenizer.hasMoreTokens()) break;
                this.manifestInfo.schemaVersion = stringTokenizer.nextToken();
                break;
            }
        }
    }

    public class PluginInfo
    implements IPluginInfo {
        private String schemaVersion;
        private String pluginId;
        private String version;
        private String vendor;
        private ArrayList libraryPaths;
        private Map libraries;
        private ArrayList requires;
        private boolean requiresExpanded = false;
        private boolean compatibilityFound = false;
        private String pluginClass;
        private String masterPluginId;
        private String masterVersion;
        private String masterMatch;
        private Set filters;
        private String pluginName;
        private boolean singleton;
        private boolean fragment;
        private static final String TARGET21_STRING = "2.1";
        private boolean hasExtensionExtensionPoints = false;

        public boolean isFragment() {
            return this.fragment;
        }

        public String toString() {
            return "plugin-id: " + this.pluginId + "  version: " + this.version + " libraries: " + this.libraries + " class:" + this.pluginClass + " master: " + this.masterPluginId + " master-version: " + this.masterVersion + " requires: " + this.requires + " singleton: " + this.singleton;
        }

        public Map getLibraries() {
            if (this.libraries == null) {
                return new HashMap(0);
            }
            return this.libraries;
        }

        public ArrayList getRequires() {
            if (!TARGET21.equals(PluginParser.this.target) && this.schemaVersion == null && !this.requiresExpanded) {
                this.requiresExpanded = true;
                if (this.requires == null) {
                    this.requires = new ArrayList(1);
                    this.requires.add(new Prerequisite("org.eclipse.core.runtime", TARGET21_STRING, false, false, "greaterOrEqual"));
                    this.requires.add(new Prerequisite("org.eclipse.core.runtime.compatibility", null, false, false, null));
                } else {
                    int n = 0;
                    while (n < this.requires.size()) {
                        Prerequisite prerequisite = (Prerequisite)this.requires.get(n);
                        if ("org.eclipse.ui".equals(prerequisite.getName())) {
                            this.requires.add(n + 1, new Prerequisite("org.eclipse.ui.workbench.texteditor", null, true, prerequisite.isExported(), null));
                            this.requires.add(n + 1, new Prerequisite("org.eclipse.jface.text", null, true, prerequisite.isExported(), null));
                            this.requires.add(n + 1, new Prerequisite("org.eclipse.ui.editors", null, true, prerequisite.isExported(), null));
                            this.requires.add(n + 1, new Prerequisite("org.eclipse.ui.views", null, true, prerequisite.isExported(), null));
                            this.requires.add(n + 1, new Prerequisite("org.eclipse.ui.ide", null, true, prerequisite.isExported(), null));
                        } else if ("org.eclipse.help".equals(prerequisite.getName())) {
                            this.requires.add(n + 1, new Prerequisite("org.eclipse.help.base", null, true, prerequisite.isExported(), null));
                        } else if ("org.eclipse.core.runtime".equals(prerequisite.getName()) && !this.compatibilityFound) {
                            this.requires.add(n + 1, new Prerequisite("org.eclipse.core.runtime.compatibility", null, false, prerequisite.isExported(), null));
                        }
                        ++n;
                    }
                    if (!this.requires.contains(new Prerequisite("org.eclipse.core.runtime.compatibility", null, false, false, null))) {
                        this.requires.add(new Prerequisite("org.eclipse.core.runtime.compatibility", null, false, false, null));
                    }
                    Prerequisite prerequisite = new Prerequisite("org.eclipse.core.runtime", null, false, false, null);
                    this.requires.remove(prerequisite);
                    this.requires.add(new Prerequisite("org.eclipse.core.runtime", TARGET21_STRING, false, false, "greaterOrEqual"));
                }
            }
            if (this.requires == null) {
                this.requires = new ArrayList(0);
                return this.requires;
            }
            return this.requires;
        }

        public String getMasterId() {
            return this.masterPluginId;
        }

        public String getMasterVersion() {
            return this.masterVersion;
        }

        public String getMasterMatch() {
            return this.masterMatch;
        }

        public String getPluginClass() {
            return this.pluginClass;
        }

        public String getUniqueId() {
            return this.pluginId;
        }

        public String getVersion() {
            return this.version;
        }

        public Set getPackageFilters() {
            return this.filters;
        }

        public String[] getLibrariesName() {
            if (this.libraryPaths == null) {
                return new String[0];
            }
            return this.libraryPaths.toArray(new String[this.libraryPaths.size()]);
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getProviderName() {
            return this.vendor;
        }

        public boolean isSingleton() {
            return this.singleton;
        }

        public boolean hasExtensionExtensionPoints() {
            return this.hasExtensionExtensionPoints;
        }

        public String getRoot() {
            return this.isFragment() ? "fragment" : "plugin";
        }

        public String validateForm() {
            if (this.pluginId == null) {
                return NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_MISSING_ATTRIBUTE, new String[]{this.getRoot(), "id", this.getRoot()});
            }
            if (this.pluginName == null) {
                return NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_MISSING_ATTRIBUTE, new String[]{this.getRoot(), "name", this.getRoot()});
            }
            if (this.version == null) {
                return NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_MISSING_ATTRIBUTE, new String[]{this.getRoot(), "version", this.getRoot()});
            }
            if (this.isFragment() && this.masterPluginId == null) {
                return NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_MISSING_ATTRIBUTE, new String[]{this.getRoot(), "plugin-id", this.getRoot()});
            }
            if (this.isFragment() && this.masterVersion == null) {
                return NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_MISSING_ATTRIBUTE, new String[]{this.getRoot(), "plugin-version", this.getRoot()});
            }
            return null;
        }
    }

    public class Prerequisite {
        String name;
        String version;
        boolean optional;
        boolean export;
        String match;

        public boolean isExported() {
            return this.export;
        }

        public String getMatch() {
            return this.match;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String getVersion() {
            return this.version;
        }

        public Prerequisite(String string, String string2, boolean bl, boolean bl2, String string3) {
            this.name = string;
            this.version = string2;
            this.optional = bl;
            this.export = bl2;
            this.match = string3;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Prerequisite)) {
                return false;
            }
            return this.name.equals(((Prerequisite)object).name);
        }
    }
}

