/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.stats;

import java.util.ArrayList;
import org.eclipse.core.runtime.internal.stats.ClassloaderStats;
import org.eclipse.core.runtime.internal.stats.StatsManager;

public class ClassStats {
    private String className;
    private ClassloaderStats classloader;
    private int loadOrder = -1;
    private long timestamp;
    private long timeLoading;
    private long timeLoadingOthers = 0L;
    private ClassStats loadedBy = null;
    private ArrayList loaded = new ArrayList(2);
    private boolean duringStartup;
    private long traceStart = -1L;
    private long traceEnd = -1L;

    public ClassStats(String string, ClassloaderStats classloaderStats) {
        this.className = string;
        this.timestamp = System.currentTimeMillis();
        this.duringStartup = StatsManager.isBooting();
        this.classloader = classloaderStats;
    }

    public void setLoadOrder(int n) {
        this.loadOrder = n;
    }

    public void loadingDone() {
        this.timeLoading = System.currentTimeMillis() - this.timestamp;
    }

    public long getTimeLoading() {
        return this.timeLoading;
    }

    public long getLocalTimeLoading() {
        return this.timeLoading - this.timeLoadingOthers;
    }

    public void addTimeLoadingOthers(long l) {
        this.timeLoadingOthers += l;
    }

    public long getTraceStart() {
        return this.traceStart;
    }

    public long getTraceEnd() {
        return this.traceEnd;
    }

    public void setTraceStart(long l) {
        this.traceStart = l;
    }

    public void setTraceEnd(long l) {
        this.traceEnd = l;
    }

    public void loaded(ClassStats classStats) {
        this.loaded.add(classStats);
    }

    public void setLoadedBy(ClassStats classStats) {
        this.loadedBy = classStats;
    }

    public ClassStats getLoadedBy() {
        return this.loadedBy;
    }

    public ArrayList getLoadedClasses() {
        return this.loaded;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isStartupClass() {
        return this.duringStartup;
    }

    public ClassloaderStats getClassloader() {
        return this.classloader;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void toBaseClass() {
        this.duringStartup = true;
        this.loadOrder = -2;
    }
}

