/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTreeViewer
extends StructuredViewer {
    public static final int ALL_LEVELS = -1;
    private ListenerList treeListeners = new ListenerList(1);
    private int expandToLevel = 0;

    protected AbstractTreeViewer() {
    }

    public void add(Object object, Object[] objectArray) {
        Assert.isNotNull(object);
        this.assertElementsNotNull(objectArray);
        Widget widget = this.findItem(object);
        if (widget == null) {
            return;
        }
        this.internalAdd(widget, object, objectArray);
    }

    protected void internalAdd(Widget widget, Object object, Object[] objectArray) {
        Object[] objectArray2;
        if (widget instanceof Item && !this.getExpanded((Item)(objectArray2 = (Object[])widget))) {
            boolean bl = this.isExpandable(object);
            boolean bl2 = false;
            Item[] itemArray = this.getItems((Item)objectArray2);
            int n = 0;
            while (n < itemArray.length) {
                if (itemArray[n].getData() != null) {
                    this.disassociate(itemArray[n]);
                    itemArray[n].dispose();
                } else if (bl && !bl2) {
                    bl2 = true;
                } else {
                    itemArray[n].dispose();
                }
                ++n;
            }
            if (bl && !bl2) {
                this.newItem((Widget)objectArray2, 0, -1);
            }
            return;
        }
        if (objectArray.length > 0) {
            objectArray2 = this.filter(objectArray);
            if (this.getSorter() != null) {
                this.getSorter().sort(this, objectArray2);
            }
            this.createAddedElements(widget, objectArray2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createAddedElements(Widget var1_1, Object[] var2_2) {
        if (var2_2.length == 1 && this.equals(var2_2[0], var1_1.getData())) {
            return;
        }
        var3_3 = this.getSorter();
        var4_4 = this.getChildren(var1_1);
        var5_5 = 0;
        if (var4_4.length == 0) {
            var6_6 = 0;
            while (var6_6 < var2_2.length) {
                this.createTreeItem(var1_1, var2_2[var6_6], -1);
                ++var6_6;
            }
            return;
        }
        var6_7 = 0;
        while (var6_7 < var2_2.length) {
            block9: {
                block8: {
                    var7_8 = true;
                    var8_9 = var2_2[var6_7];
                    if (var3_3 != null) break block8;
                    if (this.itemExists(var4_4, var8_9)) {
                        this.refresh(var8_9);
                        var7_8 = false;
                    }
                    var9_10 = -1;
                    break block9;
                }
                if ((var5_5 = this.insertionPosition(var4_4, var3_3, var5_5, var8_9)) != var4_4.length) ** GOTO lbl31
                var9_10 = -1;
                break block9;
lbl-1000:
                // 1 sources

                {
                    if (var4_4[var5_5].getData().equals(var8_9)) {
                        this.refresh(var8_9);
                        var7_8 = false;
                    }
                    ++var5_5;
lbl31:
                    // 2 sources

                    ** while (var5_5 < var4_4.length && var3_3.compare((Viewer)this, (Object)var8_9, (Object)var4_4[var5_5].getData()) == 0)
                }
lbl32:
                // 1 sources

                var9_10 = var5_5 == var4_4.length ? -1 : var5_5 + var6_7;
            }
            if (var7_8) {
                this.createTreeItem(var1_1, var8_9, var9_10);
            }
            ++var6_7;
        }
    }

    private boolean itemExists(Item[] itemArray, Object object) {
        if (this.usingElementMap()) {
            return this.findItem(object) != null;
        }
        int n = 0;
        while (n < itemArray.length) {
            if (itemArray[n].getData().equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int insertionPosition(Item[] itemArray, ViewerSorter viewerSorter, int n, Object object) {
        int n2 = itemArray.length;
        if (viewerSorter == null) {
            return n2;
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            Object object2 = itemArray[n5].getData();
            int n6 = viewerSorter.compare(this, object2, object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return n3;
    }

    protected int indexForElement(Widget widget, Object object) {
        ViewerSorter viewerSorter = this.getSorter();
        Item[] itemArray = this.getChildren(widget);
        int n = itemArray.length;
        if (viewerSorter == null) {
            return n;
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object object2 = itemArray[n4].getData();
            int n5 = viewerSorter.compare(this, object2, object);
            if (n5 == 0) {
                while (n5 == 0) {
                    if (++n4 >= n) break;
                    object2 = itemArray[n4].getData();
                    n5 = viewerSorter.compare(this, object2, object);
                }
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    public void add(Object object, Object object2) {
        this.add(object, new Object[]{object2});
    }

    protected void addSelectionListener(Control control, SelectionListener selectionListener) {
    }

    public void addTreeListener(ITreeViewerListener iTreeViewerListener) {
        this.treeListeners.add(iTreeViewerListener);
    }

    protected abstract void addTreeListener(Control var1, TreeListener var2);

    protected void associate(Object object, Item item) {
        Object object2 = item.getData();
        if (object2 != null && object2 != object && this.equals(object2, object)) {
            this.unmapElement(object2, (Widget)item);
            item.setData(object);
            this.mapElement(object, (Widget)item);
        } else {
            super.associate(object, item);
        }
    }

    public void collapseAll() {
        Object object = this.getRoot();
        if (object != null) {
            this.collapseToLevel(object, -1);
        }
    }

    public void collapseToLevel(Object object, int n) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget != null) {
            this.internalCollapseToLevel(widget, n);
        }
    }

    protected void createChildren(Widget widget) {
        Object object;
        Item[] itemArray = this.getChildren(widget);
        if (itemArray != null && itemArray.length > 0 && (object = itemArray[0].getData()) != null) {
            return;
        }
        if (itemArray != null) {
            int n = 0;
            while (n < itemArray.length) {
                if (itemArray[n].getData() != null) {
                    this.disassociate(itemArray[n]);
                    Assert.isTrue(itemArray[n].getData() == null, "Second or later child is non -null");
                }
                itemArray[n].dispose();
                ++n;
            }
        }
        if ((object = widget.getData()) != null) {
            Object object2 = object;
            Object[] objectArray = this.getSortedChildren(object2);
            int n = 0;
            while (n < objectArray.length) {
                this.createTreeItem(widget, objectArray[n], -1);
                ++n;
            }
        }
    }

    protected void createTreeItem(Widget widget, Object object, int n) {
        Item item = this.newItem(widget, 0, n);
        this.updateItem((Widget)item, object);
        this.updatePlus(item, object);
    }

    protected void disassociate(Item item) {
        super.disassociate(item);
        if (this.usingElementMap()) {
            this.disassociateChildren(item);
        }
    }

    private void disassociateChildren(Item item) {
        Item[] itemArray = this.getChildren((Widget)item);
        int n = 0;
        while (n < itemArray.length) {
            if (itemArray[n].getData() != null) {
                this.disassociate(itemArray[n]);
            }
            ++n;
        }
    }

    protected Widget doFindInputItem(Object object) {
        Object object2 = this.getRoot();
        if (object2 == null) {
            return null;
        }
        if (this.equals(object2, object)) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object object) {
        Object object2 = this.getRoot();
        if (object2 == null) {
            return null;
        }
        Item[] itemArray = this.getChildren((Widget)this.getControl());
        if (itemArray != null) {
            int n = 0;
            while (n < itemArray.length) {
                Widget widget = this.internalFindItem(itemArray[n], object);
                if (widget != null) {
                    return widget;
                }
                ++n;
            }
        }
        return null;
    }

    protected abstract void doUpdateItem(Item var1, Object var2);

    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        if (widget instanceof Item) {
            Item item = (Item)widget;
            if (bl) {
                this.associate(object, item);
            } else {
                item.setData(object);
                this.mapElement(object, (Widget)item);
            }
            SafeRunnable.run(new UpdateItemSafeRunnable(item, object));
        }
    }

    public void expandAll() {
        this.expandToLevel(-1);
    }

    public void expandToLevel(int n) {
        this.expandToLevel(this.getRoot(), n);
    }

    public void expandToLevel(Object object, int n) {
        Widget widget = this.internalExpand(object, true);
        if (widget != null) {
            this.internalExpandToLevel(widget, n);
        }
    }

    protected void fireTreeCollapsed(final TreeExpansionEvent treeExpansionEvent) {
        Object[] objectArray = this.treeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ITreeViewerListener iTreeViewerListener = (ITreeViewerListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iTreeViewerListener.treeCollapsed(treeExpansionEvent);
                }
            });
            ++n;
        }
    }

    protected void fireTreeExpanded(final TreeExpansionEvent treeExpansionEvent) {
        Object[] objectArray = this.treeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ITreeViewerListener iTreeViewerListener = (ITreeViewerListener)objectArray[n];
            SafeRunnable.run(new SafeRunnable(){

                public void run() {
                    iTreeViewerListener.treeExpanded(treeExpansionEvent);
                }
            });
            ++n;
        }
    }

    public int getAutoExpandLevel() {
        return this.expandToLevel;
    }

    protected abstract Item[] getChildren(Widget var1);

    protected Item getChild(Widget widget, int n) {
        return this.getChildren(widget)[n];
    }

    protected abstract boolean getExpanded(Item var1);

    public Object[] getExpandedElements() {
        ArrayList arrayList = new ArrayList();
        this.internalCollectExpanded(arrayList, (Widget)this.getControl());
        return arrayList.toArray();
    }

    public boolean getExpandedState(Object object) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget instanceof Item) {
            return this.getExpanded((Item)widget);
        }
        return false;
    }

    protected abstract int getItemCount(Control var1);

    protected abstract int getItemCount(Item var1);

    protected abstract Item[] getItems(Item var1);

    protected Item getNextItem(Item item, boolean bl) {
        Item[] itemArray;
        if (item == null) {
            return null;
        }
        if (bl && this.getExpanded(item) && (itemArray = this.getItems(item)) != null && itemArray.length > 0) {
            return itemArray[0];
        }
        itemArray = this.getParentItem(item);
        if (itemArray == null) {
            return null;
        }
        Item[] itemArray2 = this.getItems((Item)itemArray);
        if (itemArray2 != null) {
            if (itemArray2.length <= 1) {
                return this.getNextItem((Item)itemArray, false);
            }
            int n = 0;
            while (n < itemArray2.length) {
                if (itemArray2[n] == item && n < itemArray2.length - 1) {
                    return itemArray2[n + 1];
                }
                ++n;
            }
        }
        return this.getNextItem((Item)itemArray, false);
    }

    protected abstract Item getParentItem(Item var1);

    protected Item getPreviousItem(Item item) {
        Item item2 = this.getParentItem(item);
        if (item2 == null) {
            return null;
        }
        Item[] itemArray = this.getItems(item2);
        if (itemArray.length == 0 || itemArray[0] == item) {
            return item2;
        }
        Item item3 = itemArray[0];
        int n = 1;
        while (n < itemArray.length) {
            if (itemArray[n] == item) {
                return this.rightMostVisibleDescendent(item3);
            }
            item3 = itemArray[n];
            ++n;
        }
        return null;
    }

    protected Object[] getRawChildren(Object object) {
        if (object != null) {
            Object[] objectArray;
            if (this.equals(object, this.getRoot())) {
                return super.getRawChildren(object);
            }
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.getContentProvider();
            if (iTreeContentProvider != null && (objectArray = iTreeContentProvider.getChildren(object)) != null) {
                return objectArray;
            }
        }
        return new Object[0];
    }

    protected abstract Item[] getSelection(Control var1);

    protected List getSelectionFromWidget() {
        Item[] itemArray = this.getSelection(this.getControl());
        ArrayList<Object> arrayList = new ArrayList<Object>(itemArray.length);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            Object object = item.getData();
            if (object != null) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList;
    }

    protected void handleTreeCollapse(TreeEvent treeEvent) {
        if (treeEvent.item.getData() != null) {
            this.fireTreeCollapsed(new TreeExpansionEvent(this, treeEvent.item.getData()));
        }
    }

    protected void handleTreeExpand(TreeEvent treeEvent) {
        this.createChildren(treeEvent.item);
        if (treeEvent.item.getData() != null) {
            this.fireTreeExpanded(new TreeExpansionEvent(this, treeEvent.item.getData()));
        }
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.addTreeListener(control, new TreeListener(){

            public void treeExpanded(TreeEvent treeEvent) {
                AbstractTreeViewer.this.handleTreeExpand(treeEvent);
            }

            public void treeCollapsed(TreeEvent treeEvent) {
                AbstractTreeViewer.this.handleTreeCollapse(treeEvent);
            }
        });
    }

    protected void inputChanged(Object object, Object object2) {
        this.preservingSelection(new Runnable(){

            public void run() {
                Control control = AbstractTreeViewer.this.getControl();
                boolean bl = true;
                if (bl) {
                    control.setRedraw(false);
                }
                AbstractTreeViewer.this.removeAll(control);
                control.setData(AbstractTreeViewer.this.getRoot());
                AbstractTreeViewer.this.createChildren((Widget)control);
                AbstractTreeViewer.this.internalExpandToLevel((Widget)control, AbstractTreeViewer.this.expandToLevel);
                if (bl) {
                    control.setRedraw(true);
                }
            }
        });
    }

    protected void internalCollapseToLevel(Widget widget, int n) {
        if (n == -1 || n > 0) {
            Item[] itemArray;
            if (widget instanceof Item) {
                this.setExpanded((Item)widget, false);
            }
            if ((n == -1 || n > 1) && (itemArray = this.getChildren(widget)) != null) {
                int n2 = n == -1 ? -1 : n - 1;
                int n3 = 0;
                while (n3 < itemArray.length) {
                    this.internalCollapseToLevel((Widget)itemArray[n3], n2);
                    ++n3;
                }
            }
        }
    }

    private void internalCollectExpanded(List list, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Object object;
            Item item = itemArray[n];
            if (this.getExpanded(item) && (object = item.getData()) != null) {
                list.add(object);
            }
            this.internalCollectExpanded(list, (Widget)item);
            ++n;
        }
    }

    protected Widget internalExpand(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        Widget widget = this.internalGetWidgetToSelect(object);
        if (widget == null) {
            Widget widget2;
            if (this.equals(object, this.getRoot())) {
                return null;
            }
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.getContentProvider();
            if (iTreeContentProvider == null) {
                return null;
            }
            Object object2 = iTreeContentProvider.getParent(object);
            if (object2 != null && (widget2 = this.internalExpand(object2, false)) != null) {
                this.createChildren(widget2);
                if (widget2 instanceof Item) {
                    Item item = (Item)widget2;
                    widget = this.internalFindChild(item, object);
                    if (bl) {
                        while (item != null && !this.getExpanded(item)) {
                            this.setExpanded(item, true);
                            item = this.getParentItem(item);
                        }
                    }
                }
            }
        }
        return widget;
    }

    protected Widget internalGetWidgetToSelect(Object object) {
        return this.findItem(object);
    }

    protected void internalExpandToLevel(Widget widget, int n) {
        if (n == -1 || n > 0) {
            Item[] itemArray;
            this.createChildren(widget);
            if (widget instanceof Item) {
                this.setExpanded((Item)widget, true);
            }
            if ((n == -1 || n > 1) && (itemArray = this.getChildren(widget)) != null) {
                int n2 = n == -1 ? -1 : n - 1;
                int n3 = 0;
                while (n3 < itemArray.length) {
                    this.internalExpandToLevel((Widget)itemArray[n3], n2);
                    ++n3;
                }
            }
        }
    }

    private Widget internalFindChild(Item item, Object object) {
        Item[] itemArray = this.getChildren((Widget)item);
        int n = 0;
        while (n < itemArray.length) {
            Item item2 = itemArray[n];
            Object object2 = item2.getData();
            if (object2 != null && this.equals(object2, object)) {
                return item2;
            }
            ++n;
        }
        return null;
    }

    private Widget internalFindItem(Item item, Object object) {
        Object object2 = item.getData();
        if (object2 != null && this.equals(object2, object)) {
            return item;
        }
        Item[] itemArray = this.getChildren((Widget)item);
        int n = 0;
        while (n < itemArray.length) {
            Item item2 = itemArray[n];
            Widget widget = this.internalFindItem(item2, object);
            if (widget != null) {
                return widget;
            }
            ++n;
        }
        return null;
    }

    protected void internalRefresh(Object object) {
        this.internalRefresh(object, true);
    }

    protected void internalRefresh(Object object, boolean bl) {
        if (object == null) {
            this.internalRefresh((Widget)this.getControl(), this.getRoot(), true, bl);
            return;
        }
        Widget widget = this.findItem(object);
        if (widget != null) {
            this.internalRefresh(widget, object, true, bl);
        }
    }

    protected void internalRefresh(Widget widget, Object object, boolean bl, boolean bl2) {
        if (widget instanceof Item) {
            if (bl) {
                this.updatePlus((Item)widget, object);
            }
            if (bl2 || !this.equals(object, widget.getData())) {
                this.doUpdateItem(widget, object, true);
            } else {
                this.associate(object, (Item)widget);
            }
        }
        if (bl) {
            this.internalRefreshStruct(widget, object, bl2);
        } else {
            Item[] itemArray = this.getChildren(widget);
            if (itemArray != null) {
                int n = 0;
                while (n < itemArray.length) {
                    Item item = itemArray[n];
                    Object object2 = item.getData();
                    if (object2 != null) {
                        this.internalRefresh((Widget)item, object2, bl, bl2);
                    }
                    ++n;
                }
            }
        }
    }

    private void internalRefreshStruct(Widget widget, Object object, boolean bl) {
        this.updateChildren(widget, object, null, bl);
        Item[] itemArray = this.getChildren(widget);
        if (itemArray != null) {
            int n = 0;
            while (n < itemArray.length) {
                Item item = itemArray[n];
                Object object2 = item.getData();
                if (object2 != null) {
                    this.internalRefreshStruct((Widget)item, object2, bl);
                }
                ++n;
            }
        }
    }

    protected void internalRemove(Object[] objectArray) {
        Item item;
        Enumeration enumeration;
        Object object = this.getInput();
        CustomHashtable customHashtable = new CustomHashtable(5);
        int n = 0;
        while (n < objectArray.length) {
            if (this.equals(objectArray[n], object)) {
                this.setInput(null);
                return;
            }
            enumeration = this.findItem(objectArray[n]);
            if (enumeration instanceof Item) {
                item = this.getParentItem((Item)enumeration);
                if (item != null) {
                    customHashtable.put(item, item);
                }
                this.disassociate((Item)enumeration);
                enumeration.dispose();
            }
            ++n;
        }
        Control control = this.getControl();
        enumeration = customHashtable.keys();
        while (enumeration.hasMoreElements()) {
            item = (Item)enumeration.nextElement();
            if (item.isDisposed() || this.getExpanded(item) || this.getItemCount(item) != 0) continue;
            if (this.isExpandable(item.getData())) {
                this.newItem((Widget)item, 0, -1);
                continue;
            }
            control.redraw();
        }
    }

    private void internalSetExpanded(CustomHashtable customHashtable, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            Object object = item.getData();
            if (object != null) {
                boolean bl;
                boolean bl2 = bl = customHashtable.remove(object) != null;
                if (bl != this.getExpanded(item)) {
                    if (bl) {
                        this.createChildren((Widget)item);
                    }
                    this.setExpanded(item, bl);
                }
            }
            this.internalSetExpanded(customHashtable, (Widget)item);
            ++n;
        }
    }

    public boolean isExpandable(Object object) {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.getContentProvider();
        return iTreeContentProvider != null && iTreeContentProvider.hasChildren(object);
    }

    protected void labelProviderChanged() {
        Control control = this.getControl();
        control.setRedraw(false);
        this.internalRefresh((Widget)control, this.getRoot(), false, true);
        control.setRedraw(true);
    }

    protected abstract Item newItem(Widget var1, int var2, int var3);

    public void remove(final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        this.preservingSelection(new Runnable(){

            public void run() {
                AbstractTreeViewer.this.internalRemove(objectArray);
            }
        });
    }

    public void remove(Object object) {
        this.remove(new Object[]{object});
    }

    protected abstract void removeAll(Control var1);

    public void removeTreeListener(ITreeViewerListener iTreeViewerListener) {
        this.treeListeners.remove(iTreeViewerListener);
    }

    public void reveal(Object object) {
        Assert.isNotNull(object);
        Widget widget = this.internalExpand(object, true);
        if (widget instanceof Item) {
            this.showItem((Item)widget);
        }
    }

    private Item rightMostVisibleDescendent(Item item) {
        Item[] itemArray = this.getItems(item);
        if (this.getExpanded(item) && itemArray != null && itemArray.length > 0) {
            return this.rightMostVisibleDescendent(itemArray[itemArray.length - 1]);
        }
        return item;
    }

    public Item scrollDown(int n, int n2) {
        Item item = this.getItem(n, n2);
        if (item != null) {
            Item item2 = this.getNextItem(item, true);
            this.showItem(item2 == null ? item : item2);
            return item2;
        }
        return null;
    }

    public Item scrollUp(int n, int n2) {
        Item item = this.getItem(n, n2);
        if (item != null) {
            Item item2 = this.getPreviousItem(item);
            this.showItem(item2 == null ? item : item2);
            return item2;
        }
        return null;
    }

    public void setAutoExpandLevel(int n) {
        this.expandToLevel = n;
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        Assert.isTrue(iContentProvider instanceof ITreeContentProvider);
        super.setContentProvider(iContentProvider);
    }

    protected abstract void setExpanded(Item var1, boolean var2);

    public void setExpandedElements(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        CustomHashtable customHashtable = this.newHashtable(objectArray.length * 2 + 1);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.internalExpand(object, false);
            customHashtable.put(object, object);
            ++n;
        }
        this.internalSetExpanded(customHashtable, (Widget)this.getControl());
    }

    public void setExpandedState(Object object, boolean bl) {
        Assert.isNotNull(object);
        Widget widget = this.internalExpand(object, false);
        if (widget instanceof Item) {
            if (bl) {
                this.createChildren(widget);
            }
            this.setExpanded((Item)widget, bl);
        }
    }

    protected abstract void setSelection(List var1);

    protected void setSelectionToWidget(List list, boolean bl) {
        if (list == null) {
            this.setSelection(new ArrayList(0));
            return;
        }
        int n = list.size();
        ArrayList<Widget> arrayList = new ArrayList<Widget>(n);
        int n2 = 0;
        while (n2 < n) {
            Widget widget = this.internalExpand(list.get(n2), false);
            if (widget instanceof Item) {
                arrayList.add(widget);
            }
            ++n2;
        }
        this.setSelection(arrayList);
    }

    protected abstract void showItem(Item var1);

    protected void updateChildren(Widget widget, Object object, Object[] objectArray) {
        this.updateChildren(widget, object, objectArray, true);
    }

    private void updateChildren(Widget widget, Object object, Object[] objectArray, boolean bl) {
        Object object2;
        Item item;
        Item item2;
        if (widget instanceof Item && !this.getExpanded(item2 = (Item)widget)) {
            boolean bl2 = this.isExpandable(object);
            boolean bl3 = false;
            Item[] itemArray = this.getItems(item2);
            int n = 0;
            while (n < itemArray.length) {
                if (itemArray[n].getData() != null) {
                    this.disassociate(itemArray[n]);
                    itemArray[n].dispose();
                } else if (bl2 && !bl3) {
                    bl3 = true;
                } else {
                    itemArray[n].dispose();
                }
                ++n;
            }
            if (bl2 && !bl3) {
                this.newItem((Widget)item2, 0, -1);
            }
            return;
        }
        if (objectArray == null) {
            objectArray = this.getSortedChildren(object);
        }
        item2 = this.getControl();
        int n = -1;
        if (widget == item2) {
            n = this.getItemCount((Control)item2);
        }
        Item[] itemArray = this.getChildren(widget);
        CustomHashtable customHashtable = this.newHashtable(13);
        int n2 = 0;
        while (n2 < itemArray.length) {
            Object object3;
            if (this.getExpanded(itemArray[n2]) && (object3 = itemArray[n2].getData()) != null) {
                customHashtable.put(object3, object3);
            }
            ++n2;
        }
        n2 = Math.min(objectArray.length, itemArray.length);
        int n3 = itemArray.length;
        while (--n3 >= n2) {
            if (itemArray[n3].getData() != null) {
                this.disassociate(itemArray[n3]);
            }
            itemArray[n3].dispose();
        }
        n3 = 0;
        while (n3 < n2) {
            Object object4;
            item = itemArray[n3];
            object2 = item.getData();
            if (object2 != null && (object4 = objectArray[n3]) != object2) {
                if (this.equals(object4, object2)) {
                    item.setData(object4);
                    this.mapElement(object4, (Widget)item);
                } else {
                    this.disassociate(item);
                    item.setImage(null);
                    item.setText("");
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            item = itemArray[n3];
            object2 = objectArray[n3];
            if (item.getData() == null) {
                this.associate(object2, item);
                this.updatePlus(item, object2);
                this.updateItem((Widget)item, object2);
                this.setExpanded(item, customHashtable.containsKey(object2));
            } else {
                this.updatePlus(item, object2);
                if (bl) {
                    this.updateItem((Widget)item, object2);
                }
            }
            ++n3;
        }
        if (n2 < objectArray.length) {
            n3 = n2;
            while (n3 < objectArray.length) {
                this.createTreeItem(widget, objectArray[n3], n3);
                ++n3;
            }
            if (customHashtable.size() > 0) {
                itemArray = this.getChildren(widget);
                n3 = n2;
                while (n3 < objectArray.length) {
                    if (customHashtable.containsKey(objectArray[n3])) {
                        this.setExpanded(itemArray[n3], true);
                    }
                    ++n3;
                }
            }
        }
        if (widget == item2 && n == 0 && this.getItemCount((Control)item2) != 0) {
            item2.setRedraw(false);
            item2.setRedraw(true);
        }
    }

    protected void updatePlus(Item item, Object object) {
        boolean bl = this.getItemCount(item) > 0;
        boolean bl2 = this.isExpandable(object);
        boolean bl3 = false;
        boolean bl4 = false;
        Object object2 = item.getData();
        if (object2 != null && this.equals(object, object2)) {
            if (bl != bl2) {
                if (bl2) {
                    bl4 = true;
                } else {
                    bl3 = true;
                }
            }
        } else {
            bl3 = true;
            bl4 = bl2;
            this.setExpanded(item, false);
        }
        if (bl3) {
            Item[] itemArray = this.getItems(item);
            int n = 0;
            while (n < itemArray.length) {
                if (itemArray[n].getData() != null) {
                    this.disassociate(itemArray[n]);
                }
                itemArray[n].dispose();
                ++n;
            }
        }
        if (bl4) {
            this.newItem((Widget)item, 0, -1);
        }
    }

    public Object[] getVisibleExpandedElements() {
        ArrayList arrayList = new ArrayList();
        this.internalCollectVisibleExpanded(arrayList, (Widget)this.getControl());
        return arrayList.toArray();
    }

    private void internalCollectVisibleExpanded(ArrayList arrayList, Widget widget) {
        Item[] itemArray = this.getChildren(widget);
        int n = 0;
        while (n < itemArray.length) {
            Item item = itemArray[n];
            if (this.getExpanded(item)) {
                Object object = item.getData();
                if (object != null) {
                    arrayList.add(object);
                }
                this.internalCollectVisibleExpanded(arrayList, (Widget)item);
            }
            ++n;
        }
    }

    class UpdateItemSafeRunnable
    extends SafeRunnable {
        private Object element;
        private Item item;

        UpdateItemSafeRunnable(Item item, Object object) {
            this.item = item;
            this.element = object;
        }

        public void run() {
            AbstractTreeViewer.this.doUpdateItem(this.item, this.element);
        }
    }
}

