/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.UnconfigOperation;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class BatchUnconfigOperation
extends Operation
implements IBatchOperation {
    protected IUnconfigFeatureOperation[] operations;
    private boolean bVerifyComplete = false;

    public BatchUnconfigOperation(IUnconfigFeatureOperation[] iUnconfigFeatureOperationArray, boolean bl) {
        this.operations = iUnconfigFeatureOperationArray;
        this.bVerifyComplete = bl;
    }

    public IFeatureOperation[] getOperations() {
        return this.operations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException, InvocationTargetException {
        boolean bl;
        IStatus iStatus;
        int n = 0;
        if (this.operations == null) return false;
        if (this.operations.length == 0) {
            return false;
        }
        if (!this.bVerifyComplete && (iStatus = OperationsManager.getValidator().validatePendingChanges(this.operations)) != null && iStatus.getCode() == 4) {
            throw new CoreException(iStatus);
        }
        OperationsManager.setInProgress(true);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            try {
                if (iOperationListener != null) {
                    iOperationListener.beforeExecute(this, null);
                }
                iProgressMonitor.beginTask(Messages.OperationsManager_installing, this.operations.length);
                int n2 = 0;
                while (true) {
                    if (n2 >= this.operations.length) {
                        bl = SiteManager.getLocalSite().save();
                        Object var7_11 = null;
                        break;
                    }
                    SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1, 4);
                    if (this.operations[n2] instanceof UnconfigOperation) {
                        UnconfigOperation unconfigOperation = (UnconfigOperation)this.operations[n2];
                        unconfigOperation.setBatchUnconfigOperation();
                    }
                    this.operations[n2].execute((IProgressMonitor)subProgressMonitor, iOperationListener);
                    OperationsManager.addPendingOperation(this.operations[n2]);
                    this.operations[n2].markProcessed();
                    if (iOperationListener != null) {
                        iOperationListener.afterExecute(this.operations[n2], null);
                    }
                    ++n;
                    ++n2;
                }
            }
            catch (InstallAbortedException installAbortedException) {
                if (n <= 0) throw new InvocationTargetException((Throwable)((Object)installAbortedException));
                SiteManager.getLocalSite().save();
                throw new InvocationTargetException((Throwable)((Object)installAbortedException));
            }
            catch (CoreException coreException) {
                if (n <= 0) throw new InvocationTargetException(coreException);
                SiteManager.getLocalSite().save();
                throw new InvocationTargetException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            OperationsManager.setInProgress(false);
            iProgressMonitor.done();
            throw throwable;
        }
        OperationsManager.setInProgress(false);
        iProgressMonitor.done();
        return bl;
    }
}

