/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public class NativeStackPresentation
extends StackPresentation {
    private Composite tabFolder;
    private Listener dragListener;
    private IPresentablePart current;
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private static final String TAB_DATA;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.presentations.NativeStackPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAB_DATA = String.valueOf(clazz.getName()) + ".partId";
    }

    public NativeStackPresentation(Composite parent, IStackPresentationSite stackSite) {
        super(stackSite);
        int tabPos = this.preferenceStore.getInt("VIEW_TAB_POSITION");
        this.tabFolder = new Composite(parent, tabPos);
    }

    public void setBounds(Rectangle bounds) {
        this.tabFolder.setBounds(bounds);
        this.setControlSize();
    }

    private void setControlSize() {
        if (this.current == null || this.tabFolder == null) {
            return;
        }
        this.current.setBounds(NativeStackPresentation.calculatePageBounds(this.tabFolder));
    }

    public static Rectangle calculatePageBounds(Composite folder) {
        if (folder == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bounds = folder.getBounds();
        Rectangle offset = folder.getClientArea();
        bounds.x += offset.x;
        bounds.y += offset.y;
        bounds.width = offset.width;
        bounds.height = offset.height;
        return bounds;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.tabFolder.dispose();
        this.tabFolder = null;
    }

    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed();
    }

    public void setActive(int newState) {
    }

    public void setVisible(boolean isVisible) {
        if (this.current != null) {
            this.current.setVisible(isVisible);
        }
        this.tabFolder.setVisible(isVisible);
    }

    public void setState(int state) {
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
    }

    public void removePart(IPresentablePart oldPart) {
        oldPart.setVisible(false);
    }

    public void selectPart(IPresentablePart toSelect) {
        if (toSelect == this.current) {
            return;
        }
        if (this.current != null) {
            this.current.setVisible(false);
        }
        this.current = toSelect;
        if (this.current != null) {
            this.current.setVisible(true);
            this.setControlSize();
        }
    }

    public void showSystemMenu() {
    }

    public void showPaneMenu() {
    }

    public Control[] getTabList(IPresentablePart part) {
        ArrayList<Control> list = new ArrayList<Control>();
        if (this.getControl() != null) {
            list.add(this.getControl());
        }
        if (part.getControl() != null) {
            list.add(part.getControl());
        }
        return list.toArray(new Control[list.size()]);
    }
}

