/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class PreferencePage
implements IPreferencePage {
    private Image image = null;
    private ImageDescriptor imageDescriptor = null;
    private IPreferenceStore preferenceStore;
    private boolean isValid = true;
    private Control body;
    private Control control;
    private boolean createDefaultAndApplyButton = true;
    private Button defaultsButton = null;
    private IPreferencePageContainer container = null;
    private Button applyButton = null;
    private Label descriptionLabel;
    private String description = null;
    private Point size = null;
    private String title = null;

    protected PreferencePage() {
        this("");
    }

    protected PreferencePage(String title) {
        this.title = title;
    }

    protected PreferencePage(String title, ImageDescriptor image) {
        this.title = title;
        this.imageDescriptor = image;
    }

    protected abstract Control createContents(Composite var1);

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.body = this.createContents(parent);
        this.setControl(this.body);
        if (this.body != null) {
            this.body.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        parent.layout();
    }

    private void setControl(Control body2) {
        this.control = body2;
    }

    public Control getControl() {
        return this.control;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return null;
    }

    public IPreferencePageContainer getContainer() {
        return this.container;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = this.doGetPreferenceStore();
        }
        if (this.preferenceStore != null) {
            return this.preferenceStore;
        }
        if (this.container != null) {
            return this.container.getPreferenceStore();
        }
        return null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void noDefaultAndApplyButton() {
        this.createDefaultAndApplyButton = false;
    }

    public boolean okToLeave() {
        return this.isValid();
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performCancel() {
        return true;
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        return true;
    }

    public void setContainer(IPreferencePageContainer container) {
        this.container = container;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
    }

    public void setSize(Point uiSize) {
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValid(boolean b) {
        this.isValid = b;
    }

    public String toString() {
        return this.title;
    }

    protected Button getApplyButton() {
        return this.applyButton;
    }

    protected Button getDefaultsButton() {
        return this.defaultsButton;
    }

    public void applyData(Object data) {
    }

    public String getTitle() {
        if (this.title == null) {
            return "title not supplied";
        }
        return this.title;
    }

    public Image getImage() {
        if (this.image == null && this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    public void setImageDescriptor(ImageDescriptor desc) {
        this.imageDescriptor = desc;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public Point computeSize() {
        return new Point(0, 0);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

