/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.MobileShell;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class MobileShellShowCase
extends ShowCase
implements PaintListener,
KeyListener,
TraverseListener,
SelectionListener {
    MobileShell mobileShell;
    Composite c;
    final String keyCodeString = Messages.getString("MobileShellShowCase.0");
    String keycode = "";
    boolean keypressed;
    boolean switchmode = false;
    int mode;
    Command commandFullscreen;
    Command commandFullscreenWithCmd;
    Command commandExit;
    Command commandBack;
    Button b;
    Color colBlue;
    Color colWhite;
    Color colRed;
    Image backbufferImage;
    GC backbufferGC;
    static int BACKGROUND_BORDER_WIDTH = 10;
    static int RED_RECTANGLES_WIDTH = 20;
    static int MODE_NORMAL = 1;
    static int MODE_FULLSCREEN = 2;
    static int MODE_FULLSCREENWITHCMD = 3;

    public String getName() {
        return Messages.getString("MobileShellShowCase.2");
    }

    public void show() {
        this.mobileShell = new MobileShell(Display.getCurrent(), 1200);
        this.c = new Composite((Composite)this.mobileShell, 0);
        this.mobileShell.setText(Messages.getString("MobileShellShowCase.3"));
        this.c.addPaintListener((PaintListener)this);
        this.mobileShell.addKeyListener((KeyListener)this);
        this.mobileShell.addTraverseListener((TraverseListener)this);
        this.mobileShell.setLayout((Layout)new FillLayout());
        this.b = new Button(this.c, 8);
        this.b.setText(Messages.getString("MobileShellShowCase.4"));
        this.b.setBounds(20, 20, 100, 40);
        this.b.addSelectionListener((SelectionListener)this);
        this.b.addKeyListener((KeyListener)this);
        this.mobileShell.redraw();
        this.mobileShell.setFocus();
        this.normalMode();
        this.mobileShell.layout();
        this.mobileShell.open();
        this.mobileShell.setBackground(new Color((Device)Display.getCurrent(), 25, 255, 25));
    }

    public void paintControl(PaintEvent e) {
        this.buildDoubleBufferingGC();
        this.c.getClientArea();
        Rectangle rc = this.textRectangle(String.valueOf(this.keyCodeString) + (this.keycode != null ? this.keycode : ""));
        if (e.height == rc.height && e.width == rc.width) {
            if (this.colWhite == null) {
                this.colWhite = new Color((Device)this.mobileShell.getDisplay(), 255, 255, 255);
            }
            this.backbufferGC.setBackground(this.colWhite);
            this.backbufferGC.setForeground(this.colWhite);
            this.backbufferGC.fillRectangle(new Rectangle(e.x, e.y, e.width, e.height));
        } else {
            this.drawBackground();
        }
        this.DrawText();
        e.gc.drawImage(this.backbufferImage, 0, 0);
    }

    private void drawBackground() {
        Rectangle area = this.c.getClientArea();
        if (this.colBlue == null) {
            this.colBlue = new Color((Device)this.mobileShell.getDisplay(), 0, 0, 255);
        }
        this.backbufferGC.setBackground(this.colBlue);
        this.backbufferGC.setForeground(this.colBlue);
        this.backbufferGC.fillRectangle(area);
        Rectangle insideRect = new Rectangle(area.x + BACKGROUND_BORDER_WIDTH, area.y + BACKGROUND_BORDER_WIDTH, area.width - BACKGROUND_BORDER_WIDTH * 2, area.height - BACKGROUND_BORDER_WIDTH * 2);
        if (this.colWhite == null) {
            this.colWhite = new Color((Device)this.mobileShell.getDisplay(), 255, 255, 255);
        }
        this.backbufferGC.setBackground(this.colWhite);
        this.backbufferGC.setForeground(this.colWhite);
        this.backbufferGC.fillRectangle(insideRect);
        int nb_red_rectangle_x = area.width / (RED_RECTANGLES_WIDTH * 2) + 1;
        int nb_red_rectangle_y = area.height / (RED_RECTANGLES_WIDTH * 2) + 1;
        if (this.colRed == null) {
            this.colRed = new Color((Device)this.mobileShell.getDisplay(), 255, 0, 0);
        }
        this.backbufferGC.setBackground(this.colRed);
        this.backbufferGC.setForeground(this.colRed);
        int i = 0;
        while (i < nb_red_rectangle_x) {
            this.backbufferGC.fillRectangle(i * 2 * RED_RECTANGLES_WIDTH, 0, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++i;
        }
        i = 0;
        while (i < nb_red_rectangle_x) {
            this.backbufferGC.fillRectangle(i * 2 * RED_RECTANGLES_WIDTH, area.height - RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++i;
        }
        i = 0;
        while (i < nb_red_rectangle_y) {
            this.backbufferGC.fillRectangle(0, i * 2 * RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++i;
        }
        i = 0;
        while (i < nb_red_rectangle_y) {
            this.backbufferGC.fillRectangle(area.width - RED_RECTANGLES_WIDTH, i * 2 * RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH, RED_RECTANGLES_WIDTH);
            ++i;
        }
    }

    private void DrawText() {
        this.backbufferGC.setBackground(this.mobileShell.getDisplay().getSystemColor(22));
        this.backbufferGC.setForeground(this.mobileShell.getDisplay().getSystemColor(21));
        String text = Messages.getString("MobileShellShowCase.6");
        if (this.keycode != null) {
            text = String.valueOf(text) + this.keycode;
        }
        Rectangle r = this.textRectangle(text);
        this.backbufferGC.drawText(text, r.x, r.y);
        if (this.mode == MODE_FULLSCREEN) {
            Rectangle area = this.mobileShell.getClientArea();
            text = Messages.getString("MobileShellShowCase.7");
            Point textextent = this.backbufferGC.textExtent(text);
            if (textextent.x < area.width) {
                this.backbufferGC.drawText(text, area.x + (area.width - textextent.x) / 2, area.y + (area.height / 2 - textextent.y) / 2);
            } else {
                text = Messages.getString("MobileShellShowCase.8");
                String text2 = Messages.getString("MobileShellShowCase.9");
                String text3 = Messages.getString("MobileShellShowCase.10");
                textextent = this.backbufferGC.textExtent(text);
                Point textextent2 = this.backbufferGC.textExtent(text2);
                Point textextent3 = this.backbufferGC.textExtent(text3);
                this.backbufferGC.drawText(text, area.x + (area.width - textextent.x) / 2, area.y + (area.height / 2 - textextent.y) / 2);
                this.backbufferGC.drawText(text2, area.x + (area.width - textextent2.x) / 2, area.y + (area.height / 2 - textextent.y) / 2 + textextent.y);
                this.backbufferGC.drawText(text3, area.x + (area.width - textextent3.x) / 2, area.y + (area.height / 2 - textextent.y) / 2 + textextent.y + textextent2.y);
            }
        }
    }

    public Rectangle textRectangle(String text) {
        Rectangle area;
        Rectangle keycodetextarea = area = this.mobileShell.getClientArea();
        keycodetextarea = this.mode == MODE_FULLSCREEN ? new Rectangle(area.x, area.y + area.height / 2, area.width, area.height / 2) : area;
        Point textextent = this.backbufferGC.textExtent(text);
        return new Rectangle(keycodetextarea.x + (keycodetextarea.width - textextent.x) / 2, keycodetextarea.y + (keycodetextarea.height - textextent.y) / 2, textextent.x, textextent.y);
    }

    public void keyPressed(KeyEvent e) {
        Rectangle oldRect = this.textRectangle(String.valueOf(this.keyCodeString) + (this.keycode != null ? this.keycode : ""));
        this.keypressed = true;
        this.keycode = new Integer(e.keyCode).toString();
        String text = this.keyCodeString;
        if (this.keycode != null) {
            text = String.valueOf(text) + this.keycode;
        }
        Rectangle newRect = this.textRectangle(text);
        Rectangle maxRect = oldRect.width > newRect.width ? oldRect : newRect;
        this.mobileShell.redraw(maxRect.x, maxRect.y, maxRect.width, maxRect.height, true);
        if (this.mode == MODE_FULLSCREEN && (e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 174)) {
            this.normalMode();
        }
    }

    public void keyTraversed(TraverseEvent arg0) {
        arg0.doit = false;
    }

    public void keyReleased(KeyEvent e) {
        this.keypressed = false;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.commandFullscreen) {
            this.fullscreenMode();
        } else if (e.widget == this.commandFullscreenWithCmd) {
            this.fullscreenModeWithCommands();
        } else if (e.widget == this.commandExit) {
            this.quit();
        } else if (e.widget == this.b || e.widget == this.commandBack) {
            this.normalMode();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void normalMode() {
        this.releaseCommands();
        this.switchmode = true;
        this.mode = MODE_NORMAL;
        this.mobileShell.setFullScreenMode(false);
        this.commandFullscreen = new Command((Control)this.mobileShell, 1, 3);
        this.commandFullscreen.setText(Messages.getString("MobileShellShowCase.14"));
        this.commandFullscreen.addSelectionListener((SelectionListener)this);
        this.commandFullscreenWithCmd = new Command((Control)this.mobileShell, 1, 2);
        this.commandFullscreenWithCmd.setText(Messages.getString("MobileShellShowCase.15"));
        this.commandFullscreenWithCmd.addSelectionListener((SelectionListener)this);
        this.commandExit = new Command((Control)this.mobileShell, 7, 1);
        this.commandExit.setText(Messages.getString("MobileShellShowCase.16"));
        this.commandExit.setLongLabel(Messages.getString("MobileShellShowCase.17"));
        this.commandExit.addSelectionListener((SelectionListener)this);
    }

    private void fullscreenMode() {
        this.releaseCommands();
        this.switchmode = true;
        this.mode = MODE_FULLSCREEN;
        this.mobileShell.setFullScreenMode(true);
    }

    private void fullscreenModeWithCommands() {
        this.releaseCommands();
        this.switchmode = true;
        this.mode = MODE_FULLSCREENWITHCMD;
        this.commandBack = new Command((Control)this.mobileShell, 6, 2);
        this.commandBack.setText(Messages.getString("MobileShellShowCase.18"));
        this.commandBack.addSelectionListener((SelectionListener)this);
        this.mobileShell.setFullScreenMode(true);
    }

    private void buildDoubleBufferingGC() {
        if (this.switchmode) {
            if (this.backbufferImage != null) {
                this.backbufferImage.dispose();
            }
            if (this.backbufferGC != null) {
                this.backbufferGC.dispose();
            }
            this.backbufferImage = new Image((Device)this.mobileShell.getDisplay(), this.mobileShell.getClientArea());
            this.backbufferGC = new GC((Drawable)this.backbufferImage);
            this.switchmode = false;
        }
    }

    private void releaseCommands() {
        if (this.commandFullscreen != null) {
            this.commandFullscreen.dispose();
            this.commandFullscreen = null;
        }
        if (this.commandFullscreenWithCmd != null) {
            this.commandFullscreenWithCmd.dispose();
            this.commandFullscreenWithCmd = null;
        }
        if (this.commandExit != null) {
            this.commandExit.dispose();
            this.commandExit = null;
        }
        if (this.commandBack != null) {
            this.commandBack.dispose();
            this.commandBack = null;
        }
    }

    private void quit() {
        if (this.backbufferImage != null) {
            this.backbufferImage.dispose();
        }
        if (this.backbufferGC != null) {
            this.backbufferGC.dispose();
        }
        if (this.colBlue != null) {
            this.colBlue.dispose();
            this.colBlue = null;
        }
        if (this.colWhite != null) {
            this.colWhite.dispose();
            this.colWhite = null;
        }
        if (this.colRed != null) {
            this.colRed.dispose();
            this.colRed = null;
        }
        this.releaseCommands();
        this.mobileShell.removeTraverseListener((TraverseListener)this);
        this.c.removePaintListener((PaintListener)this);
        this.mobileShell.removeKeyListener((KeyListener)this);
        this.mobileShell.dispose();
        this.dispose();
    }

    protected void setFocus() {
        this.mobileShell.forceActive();
    }
}

