/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.update.views;

import java.io.File;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.TaskTip;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.ercp.update.UIImage;
import org.eclipse.ercp.update.UIMessages;
import org.eclipse.ercp.update.views.AbsScreen;
import org.eclipse.ercp.update.views.NormalView;
import org.eclipse.ercp.update.views.UpdateMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.model.BookmarkUtil;
import org.eclipse.update.util.BookmarkSite;
import org.eclipse.update.util.CategoryWrap;
import org.eclipse.update.util.FeatureWrap;
import org.eclipse.update.util.SiteWrap;

public class BookmarksScreen
extends AbsScreen {
    public static final String BOOKMARK_FILE = "bookmarks.xml";
    private Table siteList;
    private BookmarkSite selectedBookmark;
    private Vector bookmarks = new Vector();
    private Vector tableItems = new Vector();
    private String bookmarkLocation = null;
    private Label description;
    private TaskTip progress;
    private Command addCommand;
    private Command editCommand;
    private Command removeCommand;
    private StringBuffer accessLog;
    private UpdateMonitor accessSiteMonitor;
    private AccessSiteThread accessSiteThread;
    private boolean neverComeHere = true;
    private boolean isDuplicated = false;

    public BookmarksScreen(NormalView view) {
        super(view);
        URL platformXML = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation();
        if (!"file".equals(platformXML.getProtocol())) {
            IPath path = AppPlugin.getDefault().getStateLocation();
            path = path.append(BOOKMARK_FILE);
            this.bookmarkLocation = path.toOSString();
        } else {
            File f = new File(platformXML.getFile());
            f = new File(f.getParentFile(), BOOKMARK_FILE);
            this.bookmarkLocation = f.getAbsolutePath();
        }
    }

    protected void createScreen() {
        this.init(UIMessages.SelectSites);
        this.siteList = new Table(this.screen, 544);
        this.siteList.setLayoutData((Object)new GridData(1808));
        this.siteList.addSelectionListener((SelectionListener)this);
        TableColumn tc = new TableColumn(this.siteList, 0);
        tc.setWidth(this.view.parent.getSize().x - 20);
        this.separator();
        this.description = new Label(this.screen, 0);
        this.description.setLayoutData((Object)new GridData(768));
        this.setButtons(1, 2, 3);
        this.addCommand = new Command((Control)this.screen, 1, 10);
        this.addCommand.setText(UIMessages.Add);
        this.addCommand.setLongLabel(UIMessages.AddBookmark);
        this.addCommand.addSelectionListener((SelectionListener)this);
        this.editCommand = new Command((Control)this.screen, 1, 9);
        this.editCommand.setText(UIMessages.Edit);
        this.editCommand.setLongLabel(UIMessages.EditBookmark);
        this.editCommand.addSelectionListener((SelectionListener)this);
        this.removeCommand = new Command((Control)this.screen, 1, 8);
        this.removeCommand.setText(UIMessages.Remove);
        this.removeCommand.setLongLabel(UIMessages.RemoveBookmark);
        this.removeCommand.addSelectionListener((SelectionListener)this);
        this.screen.layout();
    }

    protected void refresh() {
        this.addCommand.setEnabled(true);
        this.editCommand.setEnabled(false);
        this.removeCommand.setEnabled(false);
        this.backButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.description.setText("");
        this.view.bookmarkFile = this.bookmarkLocation;
        this.siteList.removeAll();
        this.tableItems.removeAllElements();
        BookmarkUtil.load(this.bookmarkLocation, this.bookmarks);
        int i = 0;
        while (i < this.bookmarks.size()) {
            TableItem ti = new TableItem(this.siteList, 0);
            BookmarkSite bkmark = (BookmarkSite)this.bookmarks.elementAt(i);
            ti.setImage(UIImage.ICON_SITE.createImage());
            ti.setText(bkmark.getName());
            ti.setChecked(bkmark.getSelected());
            this.tableItems.add(ti);
            if (bkmark.getSelected()) {
                this.nextButton.setEnabled(true);
            }
            ++i;
        }
    }

    public void action() {
        if (this.neverComeHere && this.bookmarks.size() == 0) {
            MessageBox mb = new MessageBox(this.screen.getShell(), 34);
            mb.setText(UIMessages.Hints);
            if (this.view.isSoftKeySupported) {
                mb.setMessage(UIMessages.HintToNewBookmark2);
            } else {
                mb.setMessage(UIMessages.HintToNewBookmark);
            }
            mb.open();
        }
        this.neverComeHere = false;
        this.setDefaultFocus();
        this.screen.pack();
    }

    protected void setDefaultFocus() {
        if (this.nextButton.getEnabled()) {
            this.nextButton.setFocus();
        } else {
            this.siteList.setFocus();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.siteList) {
            if (e.detail == 32 && e.item != null) {
                int checkedCount = 0;
                int i = 0;
                while (i < this.tableItems.size()) {
                    if (((TableItem)e.item).equals((TableItem)this.tableItems.elementAt(i))) {
                        ((BookmarkSite)this.bookmarks.elementAt(i)).setSelected(((TableItem)e.item).getChecked());
                    }
                    if (((TableItem)this.tableItems.elementAt(i)).getChecked()) {
                        ++checkedCount;
                    }
                    ++i;
                }
                this.nextButton.setEnabled(checkedCount > 0);
                int count = this.siteList.getSelectionCount();
                if (count == 1) {
                    this.editCommand.setEnabled(true);
                    this.removeCommand.setEnabled(true);
                    TableItem[] items = this.siteList.getSelection();
                    int j = 0;
                    while (j < this.bookmarks.size()) {
                        this.selectedBookmark = (BookmarkSite)this.bookmarks.elementAt(j);
                        if (items[0].getText().equals(this.selectedBookmark.getName())) {
                            this.description.setText(this.selectedBookmark.getDescription());
                            this.view.currentName = this.selectedBookmark.getName();
                            break;
                        }
                        ++j;
                    }
                }
            } else {
                int count = this.siteList.getSelectionCount();
                this.editCommand.setEnabled(count == 1);
                this.removeCommand.setEnabled(count == 1);
                if (count == 1) {
                    TableItem[] items = this.siteList.getSelection();
                    int j = 0;
                    while (j < this.bookmarks.size()) {
                        this.selectedBookmark = (BookmarkSite)this.bookmarks.elementAt(j);
                        if (items[0].getText().equals(this.selectedBookmark.getName())) {
                            this.description.setText(this.selectedBookmark.getDescription());
                            this.view.currentName = this.selectedBookmark.getName();
                            break;
                        }
                        ++j;
                    }
                }
            }
            return;
        }
        BookmarkUtil.store(this.bookmarkLocation, this.bookmarks);
        if (e.widget == this.backButton) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(0, false);
        } else if (e.widget == this.cancelButton) {
            if (this.accessSiteMonitor != null) {
                this.accessSiteMonitor.setCanceled(true);
            }
        } else if (e.widget == this.nextButton) {
            this.backButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
            this.nextButton.setEnabled(false);
            this.processNextButton();
        } else if (e.widget == this.addCommand) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(5, true);
        } else if (e.widget == this.editCommand) {
            this.setVisible(false);
            ((Object)((Object)this.view)).getClass();
            ((Object)((Object)this.view)).getClass();
            this.view.showScreen(8, true);
        } else if (e.widget == this.removeCommand) {
            MessageBox mb = new MessageBox(this.screen.getShell(), 196);
            mb.setText(UIMessages.RemoveBookmark);
            mb.setMessage(UIMessages.RemoveBookmarkQuery);
            if (mb.open() == 64) {
                this.bookmarks.remove(this.selectedBookmark);
                BookmarkUtil.store(this.bookmarkLocation, this.bookmarks);
                this.refresh();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.siteList) {
            this.widgetSelected(e);
        }
    }

    private void processNextButton() {
        this.progress = new TaskTip(this.screen.getShell(), 2);
        this.progress.setText(UIMessages.SearchingSites);
        this.progress.setVisible(true);
        this.cancelButton.setFocus();
        this.accessSiteMonitor = new UpdateMonitor();
        this.accessLog = new StringBuffer();
        this.accessSiteThread = new AccessSiteThread("", this.bookmarks, this.view.viewedTree, this.view.availableFeatures, this.accessLog, this.accessSiteMonitor);
        this.accessSiteThread.start();
        Display.getCurrent().timerExec(700, new Runnable(){

            public void run() {
                int threadStatus = BookmarksScreen.this.accessSiteThread.getStatus();
                if (threadStatus == 1) {
                    Display.getCurrent().timerExec(500, (Runnable)this);
                } else if (!BookmarksScreen.this.accessSiteMonitor.isCanceled() && threadStatus == 2) {
                    BookmarksScreen.this.cancelButton.setEnabled(false);
                    BookmarksScreen.this.progress.setVisible(false);
                    if (BookmarksScreen.this.isDuplicated) {
                        return;
                    }
                    BookmarksScreen.this.isDuplicated = true;
                    if (BookmarksScreen.this.accessLog.length() > 0) {
                        MessageBox mb = new MessageBox(BookmarksScreen.this.screen.getShell(), 34);
                        mb.setText(UIMessages.UpdateSiteStatus);
                        mb.setMessage(BookmarksScreen.this.accessLog.toString());
                        mb.open();
                    }
                    BookmarksScreen.this.isDuplicated = false;
                    BookmarksScreen.this.progress.dispose();
                    BookmarksScreen.this.progress = null;
                    BookmarksScreen.this.accessSiteThread = null;
                    BookmarksScreen.this.backButton.setEnabled(true);
                    BookmarksScreen.this.nextButton.setEnabled(true);
                    BookmarksScreen.this.setVisible(false);
                    NormalView normalView = BookmarksScreen.this.view;
                    ((Object)((Object)BookmarksScreen.this.view)).getClass();
                    ((Object)((Object)BookmarksScreen.this.view)).getClass();
                    normalView.showScreen(2, true);
                } else {
                    BookmarksScreen.this.accessSiteThread = null;
                    BookmarksScreen.this.progress.setVisible(false);
                    BookmarksScreen.this.progress.dispose();
                    BookmarksScreen.this.progress = null;
                    BookmarksScreen.this.backButton.setEnabled(true);
                    BookmarksScreen.this.cancelButton.setEnabled(false);
                    BookmarksScreen.this.nextButton.setEnabled(true);
                }
            }
        });
    }

    public class AccessSiteThread
    extends Thread {
        public static final int NONE = 0;
        public static final int RUNNING = 1;
        public static final int DONE = 2;
        public static final int CANCELED = 3;
        private Vector bookmarks;
        private Vector viewedTree;
        private Vector availableFeatures;
        private StringBuffer log;
        private IProgressMonitor monitor;
        private int currentStatus;

        public AccessSiteThread(String name, Vector bookmarks, Vector viewedTree, Vector availableFeatures, StringBuffer accessLog, IProgressMonitor accessMonitor) {
            super(name);
            this.bookmarks = bookmarks;
            this.viewedTree = viewedTree;
            this.availableFeatures = availableFeatures;
            this.log = accessLog;
            this.monitor = accessMonitor;
            this.currentStatus = 0;
        }

        public void run() {
            try {
                this.currentStatus = 1;
                this.viewedTree.removeAllElements();
                this.availableFeatures.removeAllElements();
                int i = 0;
                while (i < this.bookmarks.size()) {
                    block21: {
                        BookmarkSite bookmarkSite = (BookmarkSite)this.bookmarks.elementAt(i);
                        if (bookmarkSite.getSelected()) {
                            ISite remoteSite = null;
                            if (!this.monitor.isCanceled()) {
                                try {
                                    remoteSite = SiteManager.getSite((URL)bookmarkSite.getURL(), (IProgressMonitor)this.monitor);
                                }
                                catch (CoreException ce) {
                                    this.log.append(NLS.bind((String)UIMessages.GotAccessError, (Object[])new String[]{bookmarkSite.getName(), ce.getLocalizedMessage()})).append("\n");
                                    UpdateCore.log((Throwable)ce);
                                    if (UpdateCore.DEBUG) {
                                        ce.printStackTrace();
                                    }
                                    break block21;
                                }
                            }
                            if (this.monitor.isCanceled()) {
                                this.currentStatus = 3;
                                return;
                            }
                            boolean enableSiteFilter = Boolean.valueOf(System.getProperty("org.eclipse.ercp.update.enableSiteFilter"));
                            if (enableSiteFilter && !"org.eclipse.update.core.http".equalsIgnoreCase(remoteSite.getType()) && !"org.eclipse.update.core.file".equalsIgnoreCase(remoteSite.getType())) {
                                this.log.append(NLS.bind((String)UIMessages.NotSupportedSiteType, (Object[])new String[]{bookmarkSite.getName(), remoteSite.getType() == null ? "" : remoteSite.getType()})).append("\n");
                            } else {
                                SiteWrap sw = new SiteWrap(bookmarkSite.getName());
                                sw.setDescription(remoteSite.getDescription().getAnnotation());
                                bookmarkSite.setDescription(remoteSite.getDescription().getAnnotation());
                                CategoryWrap otherCategory = null;
                                ISiteFeatureReference[] remoteFeatures = remoteSite.getRawFeatureReferences();
                                if (remoteFeatures != null) {
                                    int j = 0;
                                    while (j < remoteFeatures.length) {
                                        try {
                                            if (this.isNewFeature(remoteFeatures[j])) {
                                                FeatureWrap fw = new FeatureWrap(remoteFeatures[j]);
                                                ICategory[] categories = remoteFeatures[j].getCategories();
                                                if (categories.length == 0) {
                                                    if (otherCategory == null) {
                                                        otherCategory = new CategoryWrap(UIMessages.Other);
                                                        sw.addChild(otherCategory);
                                                    }
                                                    otherCategory.addChild(fw);
                                                } else {
                                                    int k = 0;
                                                    while (k < categories.length) {
                                                        CategoryWrap cw = this.getThisCategoryWrap(sw, categories[k]);
                                                        if (cw != null) {
                                                            cw.addChild(fw);
                                                        }
                                                        ++k;
                                                    }
                                                }
                                                this.availableFeatures.add(fw);
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        ++j;
                                    }
                                }
                                BookmarksScreen.this.view.viewedTree.add(sw);
                            }
                        }
                    }
                    ++i;
                }
                this.currentStatus = this.monitor.isCanceled() ? 3 : 2;
            }
            catch (Exception e) {
                this.currentStatus = 3;
                e.printStackTrace();
            }
        }

        private CategoryWrap getThisCategoryWrap(SiteWrap sw, ICategory category) {
            if (sw == null || category == null) {
                return null;
            }
            CategoryWrap[] cws = sw.getChildren();
            int i = 0;
            while (i < cws.length) {
                if (category.getLabel().equals(cws[i].getLabel())) {
                    return cws[i];
                }
                ++i;
            }
            CategoryWrap result = new CategoryWrap(category.getLabel());
            IURLEntry description = category.getDescription();
            if (description != null) {
                result.setDescription(description.getAnnotation());
            }
            sw.addChild(result);
            return result;
        }

        private boolean isNewFeature(ISiteFeatureReference remoteFeature) {
            VersionedIdentifier remoteVID;
            try {
                remoteVID = remoteFeature.getVersionedIdentifier();
            }
            catch (CoreException ce1) {
                ce1.printStackTrace();
                return false;
            }
            int i = 0;
            while (i < BookmarksScreen.this.view.installedFeatures.size()) {
                block6: {
                    VersionedIdentifier localVID;
                    try {
                        localVID = ((IFeatureReference)BookmarksScreen.this.view.installedFeatures.get(i)).getVersionedIdentifier();
                    }
                    catch (CoreException ce2) {
                        ce2.printStackTrace();
                        break block6;
                    }
                    if (localVID.getIdentifier().equals(remoteVID.getIdentifier()) && localVID.getVersion().isGreaterOrEqualTo(remoteVID.getVersion())) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public int getStatus() {
            return this.currentStatus;
        }
    }
}

