/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

public class PreferenceStore
implements IPersistentPreferenceStore {
    private ListenerList listeners = new ListenerList();
    private Properties properties;
    private Properties defaultProperties = new Properties();
    private boolean dirty = false;
    private String filename;

    public PreferenceStore() {
        this.properties = new Properties(this.defaultProperties);
    }

    public PreferenceStore(String string) {
        this();
        Assert.isNotNull(string);
        this.filename = string;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add(iPropertyChangeListener);
    }

    public boolean contains(String string) {
        return this.properties.containsKey(string) || this.defaultProperties.containsKey(string);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.listeners.getListeners();
        if (!(objectArray.length <= 0 || object != null && object.equals(object2))) {
            final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            int n = 0;
            while (n < objectArray.length) {
                final IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
                SafeRunnable.run(new SafeRunnable(JFaceResources.getString("PreferenceStore.changeError")){

                    public void run() {
                        iPropertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                });
                ++n;
            }
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this.properties, string);
    }

    private boolean getBoolean(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return false;
        }
        return string2.equals("true");
    }

    public boolean getDefaultBoolean(String string) {
        return this.getBoolean(this.defaultProperties, string);
    }

    public double getDefaultDouble(String string) {
        return this.getDouble(this.defaultProperties, string);
    }

    public float getDefaultFloat(String string) {
        return this.getFloat(this.defaultProperties, string);
    }

    public int getDefaultInt(String string) {
        return this.getInt(this.defaultProperties, string);
    }

    public long getDefaultLong(String string) {
        return this.getLong(this.defaultProperties, string);
    }

    public String getDefaultString(String string) {
        return this.getString(this.defaultProperties, string);
    }

    public double getDouble(String string) {
        return this.getDouble(this.properties, string);
    }

    private double getDouble(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0.0;
        }
        double d = 0.0;
        try {
            d = new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return d;
    }

    public float getFloat(String string) {
        return this.getFloat(this.properties, string);
    }

    private float getFloat(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0.0f;
        }
        float f = 0.0f;
        try {
            f = new Float(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return f;
    }

    public int getInt(String string) {
        return this.getInt(this.properties, string);
    }

    private int getInt(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public long getLong(String string) {
        return this.getLong(this.properties, string);
    }

    private long getLong(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0L;
        }
        long l = 0L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return l;
    }

    public String getString(String string) {
        return this.getString(this.properties, string);
    }

    private String getString(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public boolean isDefault(String string) {
        return !this.properties.containsKey(string) && this.defaultProperties.containsKey(string);
    }

    public void list(PrintStream printStream) {
        this.properties.list(printStream);
    }

    public void list(PrintWriter printWriter) {
        this.properties.list(printWriter);
    }

    public void load() throws IOException {
        if (this.filename == null) {
            throw new IOException("File name not specified");
        }
        FileInputStream fileInputStream = new FileInputStream(this.filename);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public void load(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
        this.dirty = false;
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        ArrayList arrayList = new ArrayList();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void putValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.setValue(this.properties, string, string2);
            this.dirty = true;
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }

    /*
     * Exception decompiling
     */
    public void save() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 57->61)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void save(OutputStream outputStream, String string) throws IOException {
        this.properties.store(outputStream, string);
        this.dirty = false;
    }

    public void setDefault(String string, double d) {
        this.setValue(this.defaultProperties, string, d);
    }

    public void setDefault(String string, float f) {
        this.setValue(this.defaultProperties, string, f);
    }

    public void setDefault(String string, int n) {
        this.setValue(this.defaultProperties, string, n);
    }

    public void setDefault(String string, long l) {
        this.setValue(this.defaultProperties, string, l);
    }

    public void setDefault(String string, String string2) {
        this.setValue(this.defaultProperties, string, string2);
    }

    public void setDefault(String string, boolean bl) {
        this.setValue(this.defaultProperties, string, bl);
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setToDefault(String string) {
        Object object = this.properties.get(string);
        this.properties.remove(string);
        this.dirty = true;
        Object object2 = null;
        if (this.defaultProperties != null) {
            object2 = this.defaultProperties.get(string);
        }
        this.firePropertyChangeEvent(string, object, object2);
    }

    public void setValue(String string, double d) {
        double d2 = this.getDouble(string);
        if (d2 != d) {
            this.setValue(this.properties, string, d);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Double(d2), new Double(d));
        }
    }

    public void setValue(String string, float f) {
        float f2 = this.getFloat(string);
        if (f2 != f) {
            this.setValue(this.properties, string, f);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Float(f2), new Float(f));
        }
    }

    public void setValue(String string, int n) {
        int n2 = this.getInt(string);
        if (n2 != n) {
            this.setValue(this.properties, string, n);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Integer(n2), new Integer(n));
        }
    }

    public void setValue(String string, long l) {
        long l2 = this.getLong(string);
        if (l2 != l) {
            this.setValue(this.properties, string, l);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Long(l2), new Long(l));
        }
    }

    public void setValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.setValue(this.properties, string, string2);
            this.dirty = true;
            this.firePropertyChangeEvent(string, string3, string2);
        }
    }

    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl2 != bl) {
            this.setValue(this.properties, string, bl);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Boolean(bl2), new Boolean(bl));
        }
    }

    private void setValue(Properties properties, String string, double d) {
        Assert.isTrue(properties != null);
        properties.put(string, Double.toString(d));
    }

    private void setValue(Properties properties, String string, float f) {
        Assert.isTrue(properties != null);
        properties.put(string, Float.toString(f));
    }

    private void setValue(Properties properties, String string, int n) {
        Assert.isTrue(properties != null);
        properties.put(string, Integer.toString(n));
    }

    private void setValue(Properties properties, String string, long l) {
        Assert.isTrue(properties != null);
        properties.put(string, Long.toString(l));
    }

    private void setValue(Properties properties, String string, String string2) {
        Assert.isTrue(properties != null && string2 != null);
        properties.put(string, string2);
    }

    private void setValue(Properties properties, String string, boolean bl) {
        Assert.isTrue(properties != null);
        properties.put(string, bl ? "true" : "false");
    }
}

