/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.PropertyTesterDescriptor;
import org.eclipse.core.internal.expressions.TypeExtensionManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class TypeExtension {
    private static final TypeExtension[] EMPTY_TYPE_EXTENSION_ARRAY = new TypeExtension[0];
    static final IPropertyTester CONTINUE = new IPropertyTester(){

        public boolean handles(String string, String string2) {
            return false;
        }

        public boolean isInstantiated() {
            return true;
        }

        public boolean isDeclaringPluginActive() {
            return true;
        }

        public IPropertyTester instantiate() {
            return this;
        }

        public boolean test(Object object, String string, Object[] objectArray, Object object2) {
            return false;
        }
    };
    private static final TypeExtension END_POINT = new TypeExtension(){

        IPropertyTester findTypeExtender(TypeExtensionManager typeExtensionManager, String string, String string2, boolean bl, boolean bl2) throws CoreException {
            return CONTINUE;
        }
    };
    private Class fType;
    private IPropertyTester[] fExtenders;
    private TypeExtension fExtends;
    private TypeExtension[] fImplements;

    private TypeExtension() {
    }

    TypeExtension(Class clazz) {
        Assert.isNotNull((Object)clazz);
        this.fType = clazz;
    }

    IPropertyTester findTypeExtender(TypeExtensionManager typeExtensionManager, String string, String string2, boolean bl, boolean bl2) throws CoreException {
        IPropertyTester iPropertyTester;
        if (this.fExtenders == null) {
            this.fExtenders = typeExtensionManager.loadTesters(this.fType);
        }
        int n = 0;
        while (n < this.fExtenders.length) {
            IPropertyTester iPropertyTester2 = this.fExtenders[n];
            if (iPropertyTester2 != null && iPropertyTester2.handles(string, string2)) {
                if (iPropertyTester2.isInstantiated()) {
                    return iPropertyTester2;
                }
                if (iPropertyTester2.isDeclaringPluginActive() || bl2) {
                    try {
                        PropertyTesterDescriptor propertyTesterDescriptor = (PropertyTesterDescriptor)iPropertyTester2;
                        IPropertyTester iPropertyTester3 = propertyTesterDescriptor.instantiate();
                        ((PropertyTester)iPropertyTester3).internalInitialize(propertyTesterDescriptor);
                        this.fExtenders[n] = iPropertyTester2 = iPropertyTester3;
                        return iPropertyTester2;
                    }
                    catch (CoreException coreException) {
                        this.fExtenders[n] = null;
                        throw coreException;
                    }
                    catch (ClassCastException classCastException) {
                        this.fExtenders[n] = null;
                        throw new CoreException((IStatus)new ExpressionStatus(202, ExpressionMessages.TypeExtender_incorrectType, classCastException));
                    }
                }
                return iPropertyTester2;
            }
            ++n;
        }
        if (bl) {
            return CONTINUE;
        }
        if (this.fExtends == null) {
            Class clazz = this.fType.getSuperclass();
            this.fExtends = clazz != null ? typeExtensionManager.get(clazz) : END_POINT;
        }
        if ((iPropertyTester = this.fExtends.findTypeExtender(typeExtensionManager, string, string2, bl, bl2)) != CONTINUE) {
            return iPropertyTester;
        }
        if (this.fImplements == null) {
            Class<?>[] classArray = this.fType.getInterfaces();
            if (classArray.length == 0) {
                this.fImplements = EMPTY_TYPE_EXTENSION_ARRAY;
            } else {
                this.fImplements = new TypeExtension[classArray.length];
                int n2 = 0;
                while (n2 < classArray.length) {
                    this.fImplements[n2] = typeExtensionManager.get(classArray[n2]);
                    ++n2;
                }
            }
        }
        int n3 = 0;
        while (n3 < this.fImplements.length) {
            iPropertyTester = this.fImplements[n3].findTypeExtender(typeExtensionManager, string, string2, bl, bl2);
            if (iPropertyTester != CONTINUE) {
                return iPropertyTester;
            }
            ++n3;
        }
        return CONTINUE;
    }

    /* synthetic */ TypeExtension(TypeExtension typeExtension) {
        this();
    }
}

