/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.FeatureTypeFactory;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public class FeatureReference
extends FeatureReferenceModel
implements IFeatureReference,
IPlatformEnvironment {
    private VersionedIdentifier versionId;
    private IFeature exactFeature;

    public FeatureReference() {
    }

    public FeatureReference(IFeatureReference iFeatureReference) {
        super((FeatureReferenceModel)((Object)iFeatureReference));
        try {
            this.setURL(iFeatureReference.getURL());
        }
        catch (CoreException coreException) {
            UpdateCore.warn("", coreException);
        }
    }

    public FeatureReference(FeatureReferenceModel featureReferenceModel) {
        super(featureReferenceModel);
        try {
            this.setURL(featureReferenceModel.getURL());
        }
        catch (CoreException coreException) {
            UpdateCore.warn("", coreException);
        }
    }

    public IFeature getFeature() throws CoreException {
        return this.getFeature(null);
    }

    public IFeature getFeature(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.exactFeature != null) {
            return this.exactFeature;
        }
        this.exactFeature = this.getFeature(this, iProgressMonitor);
        return this.exactFeature;
    }

    protected IFeature getFeature(IFeatureReference iFeatureReference, IProgressMonitor iProgressMonitor) throws CoreException {
        IFeature iFeature = null;
        URL uRL = iFeatureReference.getURL();
        iFeature = this.createFeature(uRL, iProgressMonitor);
        return iFeature;
    }

    private IFeature createFeature(URL uRL, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = this.getType();
        ISite iSite = this.getSite();
        if (iSite != null) {
            return iSite.createFeature(string, uRL, iProgressMonitor);
        }
        IFeatureFactory iFeatureFactory = FeatureTypeFactory.getInstance().getFactory(string);
        return iFeatureFactory.createFeature(uRL, iSite, iProgressMonitor);
    }

    public ISite getSite() {
        return (ISite)((Object)this.getSiteModel());
    }

    public void setURL(URL uRL) throws CoreException {
        if (uRL != null) {
            this.setURLString(uRL.toExternalForm());
            try {
                this.resolve(uRL, null);
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.FeatureReference_UnableToResolveURL, (Object[])new String[]{uRL.toExternalForm()}), malformedURLException);
            }
        }
    }

    public void setSite(ISite iSite) {
        this.setSiteModel((SiteModel)((Object)iSite));
    }

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String string = this.getFeatureIdentifier();
        String string2 = this.getFeatureVersion();
        if (string != null && string2 != null) {
            try {
                this.versionId = new VersionedIdentifier(string, string2);
                return this.versionId;
            }
            catch (Exception exception) {
                UpdateCore.warn("Unable to create versioned identifier:" + string + ":" + string2);
            }
        }
        this.versionId = new VersionedIdentifier(this.getURL().toExternalForm(), null);
        try {
            this.versionId = this.getFeature(null).getVersionedIdentifier();
        }
        catch (CoreException coreException) {
            UpdateCore.warn("", coreException);
        }
        return this.versionId;
    }

    public String getName() {
        if (super.getLabel() != null) {
            return super.getLabel();
        }
        try {
            return this.getFeature(null).getLabel();
        }
        catch (CoreException coreException) {
            return this.getVersionedIdentifier().toString();
        }
    }

    public String getOS() {
        if (super.getOS() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getOS();
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return super.getOS();
    }

    public String getWS() {
        if (super.getWS() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getWS();
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return super.getWS();
    }

    public String getOSArch() {
        if (super.getOSArch() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getOSArch();
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return super.getOSArch();
    }

    public String getNL() {
        if (super.getNL() == null && this.getURL() != null) {
            try {
                return this.getFeature(null).getNL();
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return super.getNL();
    }

    public boolean isPatch() {
        if (super.getPatch() == null) {
            try {
                return this.getFeature(null).isPatch();
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return "true".equalsIgnoreCase(super.getPatch());
    }
}

