/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.ImmutableMap;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.preferences.StringPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferences
implements IEclipsePreferences,
IScope {
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    protected static final IEclipsePreferences[] EMPTY_NODE_ARRAY = new IEclipsePreferences[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected static final String VERSION_KEY = "eclipse.preferences.version";
    protected static final String VERSION_VALUE = "1";
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    protected static final String DOUBLE_SLASH = "//";
    protected static final String EMPTY_STRING = "";
    private String cachedPath;
    protected Map children;
    protected boolean dirty = false;
    protected boolean loading = false;
    protected final String name;
    protected final EclipsePreferences parent;
    protected ImmutableMap properties = ImmutableMap.EMPTY;
    protected boolean removed = false;
    private ListenerList nodeChangeListeners;
    private ListenerList preferenceChangeListeners;
    public static boolean DEBUG_PREFERENCE_GENERAL = false;
    public static boolean DEBUG_PREFERENCE_SET = false;
    public static boolean DEBUG_PREFERENCE_GET = false;
    protected static final String debugPluginName = "org.eclipse.equinox.preferences";

    static {
        DEBUG_PREFERENCE_GENERAL = PreferencesOSGiUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.preferences/general", false);
        DEBUG_PREFERENCE_SET = PreferencesOSGiUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.preferences/set", false);
        DEBUG_PREFERENCE_GET = PreferencesOSGiUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.preferences/get", false);
    }

    public EclipsePreferences() {
        this(null, null);
    }

    protected EclipsePreferences(EclipsePreferences eclipsePreferences, String string) {
        this.parent = eclipsePreferences;
        this.name = string;
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            String string;
            this.cachedPath = this.parent == null ? PATH_SEPARATOR : ((string = this.parent.absolutePath()).length() == 1 ? String.valueOf(string) + this.name() : String.valueOf(string) + PATH_SEPARATOR + this.name());
        }
        return this.cachedPath;
    }

    public void accept(IPreferenceNodeVisitor iPreferenceNodeVisitor) throws BackingStoreException {
        if (!iPreferenceNodeVisitor.visit(this)) {
            return;
        }
        IEclipsePreferences[] iEclipsePreferencesArray = this.getChildren(true);
        int n = 0;
        while (n < iEclipsePreferencesArray.length) {
            iEclipsePreferencesArray[n].accept(iPreferenceNodeVisitor);
            ++n;
        }
    }

    protected synchronized IEclipsePreferences addChild(String string, IEclipsePreferences iEclipsePreferences) {
        if (this.children == null) {
            this.children = Collections.synchronizedMap(new HashMap());
        }
        this.children.put(string, iEclipsePreferences == null ? string : iEclipsePreferences);
        return iEclipsePreferences;
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener iNodeChangeListener) {
        this.checkRemoved();
        if (this.nodeChangeListeners == null) {
            this.nodeChangeListeners = new ListenerList();
        }
        this.nodeChangeListeners.add((Object)iNodeChangeListener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Added preference node change listener: " + iNodeChangeListener + " to: " + this.absolutePath());
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        this.checkRemoved();
        if (this.preferenceChangeListeners == null) {
            this.preferenceChangeListeners = new ListenerList();
        }
        this.preferenceChangeListeners.add((Object)iPreferenceChangeListener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Added preference property change listener: " + iPreferenceChangeListener + " to: " + this.absolutePath());
        }
    }

    private IEclipsePreferences calculateRoot() {
        IEclipsePreferences iEclipsePreferences = this;
        while (iEclipsePreferences.parent() != null) {
            iEclipsePreferences = (IEclipsePreferences)iEclipsePreferences.parent();
        }
        return iEclipsePreferences;
    }

    protected void checkRemoved() {
        if (this.removed) {
            throw new IllegalStateException(NLS.bind((String)PrefsMessages.preferences_removedNode, (Object)this.name));
        }
    }

    public String[] childrenNames() {
        this.checkRemoved();
        return this.internalChildNames();
    }

    protected String[] internalChildNames() {
        Map map = this.children;
        if (map == null || map.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return map.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public void clear() {
        this.checkRemoved();
        String[] stringArray = this.properties.keys();
        int n = 0;
        while (n < stringArray.length) {
            this.remove(stringArray[n]);
            ++n;
        }
        this.makeDirty();
    }

    protected String[] computeChildren(IPath iPath) {
        if (iPath == null) {
            return EMPTY_STRING_ARRAY;
        }
        IPath iPath2 = iPath.append(DEFAULT_PREFERENCES_DIRNAME);
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = iPath2.toFile();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                String string;
                if (fileArray[n].isFile() && (string = fileArray[n].getName()).endsWith(".prefs")) {
                    String string2 = string.substring(0, string.length() - ".prefs".length());
                    arrayList.add(string2);
                }
                ++n;
            }
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    protected IPath computeLocation(IPath iPath, String string) {
        return iPath == null ? null : iPath.append(DEFAULT_PREFERENCES_DIRNAME).append(string).addFileExtension(PREFS_FILE_EXTENSION);
    }

    protected static void convertFromProperties(EclipsePreferences eclipsePreferences, Properties properties, boolean bl) {
        String string = properties.getProperty(VERSION_KEY);
        if (string != null) {
            VERSION_VALUE.equals(string);
        }
        properties.remove(VERSION_KEY);
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            String[] stringArray = EclipsePreferences.decodePath(string2);
            String string4 = stringArray[0];
            string4 = EclipsePreferences.makeRelative(string4);
            String string5 = stringArray[1];
            if (DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting preference: " + string4 + '/' + string5 + '=' + string3);
            }
            EclipsePreferences eclipsePreferences2 = (EclipsePreferences)eclipsePreferences.internalNode(string4, false, null);
            String string6 = eclipsePreferences2.internalPut(string5, string3);
            if (!bl || string3.equals(string6)) continue;
            eclipsePreferences.firePreferenceEvent(string5, string6, string3);
        }
        PreferencesService.getDefault().shareStrings();
    }

    protected Properties convertToProperties(Properties properties, String string) throws BackingStoreException {
        Object object;
        boolean bl = string.length() != 0;
        ImmutableMap immutableMap = this.properties;
        String[] stringArray = immutableMap.keys();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            object = immutableMap.get(stringArray[n]);
            if (object != null) {
                properties.put(EclipsePreferences.encodePath(string, stringArray[n]), object);
            }
            ++n;
        }
        IEclipsePreferences[] iEclipsePreferencesArray = this.getChildren(true);
        n2 = 0;
        while (n2 < iEclipsePreferencesArray.length) {
            object = (EclipsePreferences)iEclipsePreferencesArray[n2];
            String string2 = bl ? String.valueOf(string) + PATH_SEPARATOR + ((EclipsePreferences)object).name() : ((EclipsePreferences)object).name();
            ((EclipsePreferences)object).convertToProperties(properties, string2);
            ++n2;
        }
        PreferencesService.getDefault().shareStrings();
        return properties;
    }

    public IEclipsePreferences create(IEclipsePreferences iEclipsePreferences, String string) {
        return this.create((EclipsePreferences)iEclipsePreferences, string, null);
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected void setLoading(boolean bl) {
        this.loading = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEclipsePreferences create(EclipsePreferences eclipsePreferences, String string, Object object) {
        EclipsePreferences eclipsePreferences2 = this.internalCreate(eclipsePreferences, string, object);
        eclipsePreferences.addChild(string, eclipsePreferences2);
        IEclipsePreferences iEclipsePreferences = eclipsePreferences2.getLoadLevel();
        if (iEclipsePreferences == null) {
            return eclipsePreferences2;
        }
        if (eclipsePreferences2 != iEclipsePreferences) {
            return eclipsePreferences2;
        }
        if (this.isAlreadyLoaded(eclipsePreferences2)) return eclipsePreferences2;
        if (eclipsePreferences2.isLoading()) {
            return eclipsePreferences2;
        }
        try {
            try {
                eclipsePreferences2.setLoading(true);
                eclipsePreferences2.loadLegacy();
                eclipsePreferences2.load();
                eclipsePreferences2.loaded();
                eclipsePreferences2.flush();
            }
            catch (BackingStoreException backingStoreException) {
                IPath iPath = eclipsePreferences2.getLocation();
                String string2 = NLS.bind((String)PrefsMessages.preferences_loadException, (Object)(iPath == null ? EMPTY_STRING : iPath.toString()));
                Status status = new Status(4, debugPluginName, 4, string2, (Throwable)backingStoreException);
                RuntimeLog.log((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            eclipsePreferences2.setLoading(false);
            throw throwable;
        }
        {
            Object var10_12 = null;
            eclipsePreferences2.setLoading(false);
            return eclipsePreferences2;
        }
    }

    public void flush() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences iEclipsePreferences = this.getLoadLevel();
        if (iEclipsePreferences == null) {
            String[] stringArray = this.childrenNames();
            int n = 0;
            while (n < stringArray.length) {
                this.node(stringArray[n]).flush();
                ++n;
            }
            return;
        }
        if (this != iEclipsePreferences) {
            iEclipsePreferences.flush();
            return;
        }
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        try {
            this.save();
        }
        catch (BackingStoreException backingStoreException) {
            this.dirty = true;
            throw backingStoreException;
        }
    }

    public String get(String string, String string2) {
        String string3 = this.internalGet(string);
        return string3 == null ? string2 : string3;
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.internalGet(string);
        return string2 == null ? bl : TRUE.equalsIgnoreCase(string2);
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        String string2 = this.internalGet(string);
        return string2 == null ? byArray : Base64.decode(string2.getBytes());
    }

    protected synchronized boolean childExists(String string) {
        if (this.children == null) {
            return false;
        }
        return this.children.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEclipsePreferences getChild(String string, Object object, boolean bl) {
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            block9: {
                Object v;
                block8: {
                    block7: {
                        if (this.children != null) break block7;
                        return null;
                    }
                    v = this.children.get(string);
                    if (v != null) break block8;
                    return null;
                }
                if (v instanceof IEclipsePreferences) {
                    return (IEclipsePreferences)v;
                }
                if (bl) break block9;
                return null;
            }
        }
        return this.addChild(string, this.create(this, string, object));
    }

    protected IEclipsePreferences[] getChildren(boolean bl) {
        ArrayList<IEclipsePreferences> arrayList = new ArrayList<IEclipsePreferences>();
        String[] stringArray = this.internalChildNames();
        int n = 0;
        while (n < stringArray.length) {
            IEclipsePreferences iEclipsePreferences = this.getChild(stringArray[n], null, bl);
            if (iEclipsePreferences != null) {
                arrayList.add(iEclipsePreferences);
            }
            ++n;
        }
        return arrayList.toArray(EMPTY_NODE_ARRAY);
    }

    public double getDouble(String string, double d) {
        String string2 = this.internalGet(string);
        double d2 = d;
        if (string2 != null) {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d2;
    }

    public float getFloat(String string, float f) {
        String string2 = this.internalGet(string);
        float f2 = f;
        if (string2 != null) {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f2;
    }

    public int getInt(String string, int n) {
        String string2 = this.internalGet(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    protected IEclipsePreferences getLoadLevel() {
        return null;
    }

    protected IPath getLocation() {
        return null;
    }

    public long getLong(String string, long l) {
        String string2 = this.internalGet(string);
        long l2 = l;
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l2;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new EclipsePreferences(eclipsePreferences, string);
    }

    protected String internalGet(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        String string2 = this.properties.get(string);
        if (DEBUG_PREFERENCE_GET) {
            PrefsMessages.message("Getting preference value: " + this.absolutePath() + '/' + string + "->" + string2);
        }
        return string2;
    }

    protected IEclipsePreferences internalNode(String string, boolean bl, Object object) {
        this.checkRemoved();
        if (string.length() == 0) {
            return this;
        }
        if (string.charAt(0) == '/') {
            return (IEclipsePreferences)this.calculateRoot().node(string.substring(1));
        }
        int n = string.indexOf(47);
        String string2 = n == -1 ? string : string.substring(0, n);
        boolean bl2 = false;
        IEclipsePreferences iEclipsePreferences = this.getChild(string2, object, true);
        if (iEclipsePreferences == null) {
            iEclipsePreferences = this.create(this, string2, object);
            bl2 = true;
        }
        if (bl2 && bl) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent(this, iEclipsePreferences), true);
        }
        return (IEclipsePreferences)iEclipsePreferences.node(n == -1 ? EMPTY_STRING : string.substring(n + 1));
    }

    protected String internalPut(String string, String string2) {
        this.checkRemoved();
        String string3 = this.properties.get(string);
        if (string3 != null && string3.equals(string2)) {
            return string3;
        }
        if (DEBUG_PREFERENCE_SET) {
            PrefsMessages.message("Setting preference: " + this.absolutePath() + '/' + string + '=' + string2);
        }
        this.properties = this.properties.put(string, string2);
        return string3;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return true;
    }

    public String[] keys() {
        this.checkRemoved();
        return this.properties.keys();
    }

    protected void load() throws BackingStoreException {
        this.load(this.getLocation());
    }

    /*
     * Exception decompiling
     */
    protected static Properties loadProperties(IPath var0) throws BackingStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 162->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void load(IPath iPath) throws BackingStoreException {
        if (iPath == null) {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Unable to determine location of preference file for node: " + this.absolutePath());
            }
            return;
        }
        Properties properties = EclipsePreferences.loadProperties(iPath);
        EclipsePreferences.convertFromProperties(this, properties, false);
    }

    protected void loaded() {
    }

    protected void loadLegacy() {
    }

    public static void log(IStatus iStatus) {
        RuntimeLog.log((IStatus)iStatus);
    }

    protected void makeDirty() {
        EclipsePreferences eclipsePreferences = this;
        while (eclipsePreferences != null && !eclipsePreferences.removed) {
            eclipsePreferences.dirty = true;
            eclipsePreferences = (EclipsePreferences)eclipsePreferences.parent();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String string) {
        return this.internalNode(string, true, null);
    }

    protected void fireNodeEvent(final IEclipsePreferences.NodeChangeEvent nodeChangeEvent, final boolean bl) {
        if (this.nodeChangeListeners == null) {
            return;
        }
        Object[] objectArray = this.nodeChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IEclipsePreferences.INodeChangeListener iNodeChangeListener = (IEclipsePreferences.INodeChangeListener)objectArray[n];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() throws Exception {
                    if (bl) {
                        iNodeChangeListener.added(nodeChangeEvent);
                    } else {
                        iNodeChangeListener.removed(nodeChangeEvent);
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n;
        }
    }

    public boolean nodeExists(String string) throws BackingStoreException {
        boolean bl;
        if (string.length() == 0) {
            return !this.removed;
        }
        this.checkRemoved();
        if (string.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(string.substring(1));
        }
        int n = string.indexOf(47);
        boolean bl2 = bl = n == -1;
        if (bl) {
            return this.childExists(string);
        }
        String string2 = string.substring(0, n);
        if (!this.childExists(string2)) {
            return false;
        }
        IEclipsePreferences iEclipsePreferences = this.getChild(string2, null, true);
        if (iEclipsePreferences == null) {
            return false;
        }
        return iEclipsePreferences.nodeExists(string.substring(n + 1));
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    protected void firePreferenceEvent(String string, Object object, Object object2) {
        if (this.preferenceChangeListeners == null) {
            return;
        }
        Object[] objectArray = this.preferenceChangeListeners.getListeners();
        final IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent = new IEclipsePreferences.PreferenceChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            final IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener = (IEclipsePreferences.IPreferenceChangeListener)objectArray[n];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() throws Exception {
                    iPreferenceChangeListener.preferenceChange(preferenceChangeEvent);
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n;
        }
    }

    public void put(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        String string3 = this.internalPut(string, string2);
        if (!string2.equals(string3)) {
            this.makeDirty();
            this.firePreferenceEvent(string, string3, string2);
        }
    }

    public void putBoolean(String string, boolean bl) {
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        String string3 = bl ? TRUE : FALSE;
        if (!string3.equals(string2 = this.internalPut(string, string3))) {
            this.makeDirty();
            this.firePreferenceEvent(string, string2, string3);
        }
    }

    public void putByteArray(String string, byte[] byArray) {
        String string2;
        if (string == null || byArray == null) {
            throw new NullPointerException();
        }
        String string3 = new String(Base64.encode(byArray));
        if (!string3.equals(string2 = this.internalPut(string, string3))) {
            this.makeDirty();
            this.firePreferenceEvent(string, string2, string3);
        }
    }

    public void putDouble(String string, double d) {
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        String string3 = Double.toString(d);
        if (!string3.equals(string2 = this.internalPut(string, string3))) {
            this.makeDirty();
            this.firePreferenceEvent(string, string2, string3);
        }
    }

    public void putFloat(String string, float f) {
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        String string3 = Float.toString(f);
        if (!string3.equals(string2 = this.internalPut(string, string3))) {
            this.makeDirty();
            this.firePreferenceEvent(string, string2, string3);
        }
    }

    public void putInt(String string, int n) {
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        String string3 = Integer.toString(n);
        if (!string3.equals(string2 = this.internalPut(string, string3))) {
            this.makeDirty();
            this.firePreferenceEvent(string, string2, string3);
        }
    }

    public void putLong(String string, long l) {
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        String string3 = Long.toString(l);
        if (!string3.equals(string2 = this.internalPut(string, string3))) {
            this.makeDirty();
            this.firePreferenceEvent(string, string2, string3);
        }
    }

    public void remove(String string) {
        String string2 = this.properties.get(string);
        if (string2 == null) {
            return;
        }
        this.properties = this.properties.removeKey(string);
        this.makeDirty();
        this.firePreferenceEvent(string, string2, null);
    }

    public void removeNode() throws BackingStoreException {
        this.checkRemoved();
        String[] stringArray = this.keys();
        int n = 0;
        while (n < stringArray.length) {
            this.remove(stringArray[n]);
            ++n;
        }
        if (this.parent != null && !(this.parent instanceof RootPreferences)) {
            this.removed = true;
            this.parent.removeNode(this);
        }
        IEclipsePreferences[] iEclipsePreferencesArray = this.getChildren(false);
        int n2 = 0;
        while (n2 < iEclipsePreferencesArray.length) {
            try {
                iEclipsePreferencesArray[n2].removeNode();
            }
            catch (IllegalStateException illegalStateException) {}
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(IEclipsePreferences iEclipsePreferences) {
        boolean bl = false;
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            if (this.children != null) {
                boolean bl2 = bl = this.children.remove(iEclipsePreferences.name()) != null;
                if (bl) {
                    this.makeDirty();
                }
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
        }
        if (bl) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent(this, iEclipsePreferences), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(String string) {
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            if (this.children != null) {
                boolean bl;
                boolean bl2 = bl = this.children.remove(string) != null;
                if (bl) {
                    this.makeDirty();
                }
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
        }
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener iNodeChangeListener) {
        this.checkRemoved();
        if (this.nodeChangeListeners == null) {
            return;
        }
        this.nodeChangeListeners.remove((Object)iNodeChangeListener);
        if (this.nodeChangeListeners.size() == 0) {
            this.nodeChangeListeners = null;
        }
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Removed preference node change listener: " + iNodeChangeListener + " from: " + this.absolutePath());
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        this.checkRemoved();
        if (this.preferenceChangeListeners == null) {
            return;
        }
        this.preferenceChangeListeners.remove((Object)iPreferenceChangeListener);
        if (this.preferenceChangeListeners.size() == 0) {
            this.preferenceChangeListeners = null;
        }
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Removed preference property change listener: " + iPreferenceChangeListener + " from: " + this.absolutePath());
        }
    }

    protected void save() throws BackingStoreException {
        this.save(this.getLocation());
    }

    /*
     * Exception decompiling
     */
    protected void save(IPath var1_1) throws BackingStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 280->284)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void shareStrings(StringPool stringPool) {
        this.properties.shareStrings(stringPool);
        IEclipsePreferences[] iEclipsePreferencesArray = this.getChildren(false);
        int n = 0;
        while (n < iEclipsePreferencesArray.length) {
            if (iEclipsePreferencesArray[n] instanceof EclipsePreferences) {
                ((EclipsePreferences)iEclipsePreferencesArray[n]).shareStrings(stringPool);
            }
            ++n;
        }
    }

    public static String encodePath(String string, String string2) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        String string3 = string2.indexOf(47) == -1 ? (n == 0 ? string2 : String.valueOf(string) + '/' + string2) : (n == 0 ? DOUBLE_SLASH + string2 : String.valueOf(string) + DOUBLE_SLASH + string2);
        return string3;
    }

    public static String getSegment(String string, int n) {
        int n2 = string.indexOf(47) == 0 ? 1 : 0;
        int n3 = string.indexOf(47, n2);
        if (n3 == string.length() - 1) {
            n3 = -1;
        }
        int n4 = 0;
        while (n4 < n) {
            if (n3 == -1) {
                return null;
            }
            n2 = n3 + 1;
            n3 = string.indexOf(47, n2);
            ++n4;
        }
        if (n3 == -1) {
            n3 = string.length();
        }
        return string.substring(n2, n3);
    }

    public static int getSegmentCount(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf('/'));
        return stringTokenizer.countTokens();
    }

    public static String makeRelative(String string) {
        String string2 = string;
        if (string == null) {
            return EMPTY_STRING;
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            string2 = string.length() == 0 ? EMPTY_STRING : string.substring(1);
        }
        return string2;
    }

    public static String[] decodePath(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(DOUBLE_SLASH);
        if (n == -1) {
            int n2 = string.lastIndexOf(47);
            if (n2 == -1) {
                string2 = string;
            } else {
                string3 = string.substring(0, n2);
                string2 = string.substring(n2 + 1);
            }
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 2);
        }
        if (string3 != null) {
            if (string3.length() == 0) {
                string3 = null;
            } else if (string3.charAt(0) == '/') {
                string3 = string3.substring(1);
            }
        }
        return new String[]{string3, string2};
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences iEclipsePreferences = this.getLoadLevel();
        if (iEclipsePreferences == null) {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference node is not a load root: " + this.absolutePath());
            }
            return;
        }
        if (iEclipsePreferences instanceof EclipsePreferences) {
            ((EclipsePreferences)iEclipsePreferences).load();
            iEclipsePreferences.flush();
        }
    }

    public String toDeepDebugString() {
        final StringBuffer stringBuffer = new StringBuffer();
        IPreferenceNodeVisitor iPreferenceNodeVisitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
                stringBuffer.append(iEclipsePreferences);
                stringBuffer.append('\n');
                String[] stringArray = iEclipsePreferences.keys();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(iEclipsePreferences.absolutePath());
                    stringBuffer.append(PATH_SEPARATOR);
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append('=');
                    stringBuffer.append(iEclipsePreferences.get(stringArray[n], "*default*"));
                    stringBuffer.append('\n');
                    ++n;
                }
                return true;
            }
        };
        try {
            this.accept(iPreferenceNodeVisitor);
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("Exception while calling #toDeepDebugString()");
            backingStoreException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.absolutePath();
    }
}

