/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Command;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.TaskTip;
import org.eclipse.ercp.swt.samples.eswtdemo.Command.CommandEntryScreen;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class CommandShowCase
extends ShowCase
implements SelectionListener,
ModifyListener {
    private List list;
    Command commandExit;
    Command commandOpen;
    Command commandDelete;
    Command commandGroupSend;
    Command commandViaInfrared;
    Command commandViaBlueTooth;
    Command commandViaUSB;
    Text details;
    TaskTip sendingTaskTip;
    PhoneBookDataBase phoneBookDataBase;

    public String getName() {
        return Messages.getString("CommandShowCase.0");
    }

    public void show() {
        this.phoneBookDataBase = PhoneBookDataBase.getThePhoneBook();
        this.getComposite().setLayout((Layout)new FillLayout());
        this.commandExit = new Command((Control)this.getComposite(), 7, 0);
        this.commandExit.setText(Messages.getString("CommandShowCase.1"));
        this.commandExit.setLongLabel(Messages.getString("CommandShowCase.2"));
        this.commandExit.addSelectionListener((SelectionListener)this);
        this.list = new List(this.getComposite(), 516);
        this.list.addSelectionListener((SelectionListener)this);
        this.populateList();
        this.commandOpen = new Command((Control)this.list, 2, 3);
        this.commandOpen.setText(Messages.getString("CommandShowCase.3"));
        this.commandOpen.addSelectionListener((SelectionListener)this);
        this.commandOpen.setDefaultCommand();
        this.commandDelete = new Command((Control)this.list, 1, 2);
        this.commandDelete.setText(Messages.getString("CommandShowCase.4"));
        this.commandDelete.addSelectionListener((SelectionListener)this);
        this.commandGroupSend = new Command((Control)this.list, 10, 1);
        this.commandGroupSend.setText(Messages.getString("CommandShowCase.5"));
        this.commandViaInfrared = new Command(this.commandGroupSend, 1, 3);
        this.commandViaInfrared.setText(Messages.getString("CommandShowCase.6"));
        this.commandViaInfrared.addSelectionListener((SelectionListener)this);
        this.commandViaBlueTooth = new Command(this.commandGroupSend, 1, 2);
        this.commandViaBlueTooth.setText(Messages.getString("CommandShowCase.7"));
        this.commandViaBlueTooth.addSelectionListener((SelectionListener)this);
        this.commandViaUSB = new Command(this.commandGroupSend, 1, 1);
        this.commandViaUSB.setText(Messages.getString("CommandShowCase.8"));
        this.commandViaUSB.addSelectionListener((SelectionListener)this);
        this.details = new Text(this.getComposite(), 4);
        this.details.setText("");
        this.details.computeSize(-1, -1);
        this.details.setSize(150, 20);
        this.details.addModifyListener((ModifyListener)this);
        this.getComposite().layout();
        this.list.setFocus();
        this.list.setSelection(0);
        if (this.list.getSelectionCount() > 0) {
            this.showDetails(this.list.getSelectionIndex());
        }
    }

    boolean addToList(PhoneBookEntry phoneBookEntry) {
        boolean bl = false;
        if ((PhoneBookEntry)this.phoneBookDataBase.removeEntry(phoneBookEntry) == null) {
            this.phoneBookDataBase.addEntry(phoneBookEntry);
            String string = phoneBookEntry.getSurnameAndName();
            String string2 = "";
            int n = 0;
            boolean bl2 = true;
            while (n < this.list.getItemCount() && bl2) {
                string2 = this.list.getItem(n);
                if (string2.compareTo(string) < 0) {
                    ++n;
                    continue;
                }
                bl2 = false;
            }
            this.list.add(phoneBookEntry.getSurnameAndName(), n);
            bl = true;
        }
        return bl;
    }

    private void openEntry() {
        String string;
        PhoneBookEntry phoneBookEntry;
        if (this.list.getSelectionCount() > 0 && (phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(string = this.list.getItem(this.list.getSelectionIndex()))) != null) {
            new CommandEntryScreen(this.getComposite().getShell(), this, phoneBookEntry, this.phoneBookDataBase);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.list) {
            this.openEntry();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandExit) {
            this.quit();
        } else if (selectionEvent.widget == this.commandOpen) {
            this.openEntry();
        } else if (selectionEvent.widget == this.commandDelete) {
            if (this.list.getSelectionCount() > 0) {
                String string = this.list.getItem(this.list.getSelectionIndex());
                MessageBox messageBox = new MessageBox(this.getComposite().getShell(), 196);
                messageBox.setMessage(String.valueOf(Messages.getString("CommandShowCase.11")) + string + Messages.getString("CommandShowCase.12"));
                int n = messageBox.open();
                if (n == 64) {
                    PhoneBookEntry phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(string);
                    this.phoneBookDataBase.removeEntry(phoneBookEntry);
                    this.list.remove(this.list.getSelectionIndex());
                    if (this.list.getItemCount() > 0) {
                        this.list.setSelection(0);
                        this.showDetails(0);
                    } else {
                        this.details.setText("");
                    }
                }
            }
        } else if (selectionEvent.widget == this.list) {
            if (this.list.getSelectionCount() > 0) {
                this.showDetails(this.list.getSelectionIndex());
            }
        } else if (selectionEvent.widget == this.commandViaBlueTooth || selectionEvent.widget == this.commandViaInfrared || selectionEvent.widget == this.commandViaUSB) {
            this.send();
        }
    }

    private void send() {
        if (this.sendingTaskTip == null) {
            this.sendingTaskTip = new TaskTip(this.getComposite().getShell(), 65536);
        }
        this.sendingTaskTip.setText(Messages.getString("CommandShowCase.14"));
        this.sendingTaskTip.setMinimum(0);
        this.sendingTaskTip.setMaximum(100);
        this.sendingTaskTip.setVisible(true);
        this.getComposite().getShell().getDisplay().asyncExec(new Runnable(){
            int selection = 0;
            int deltaTime = 50;

            public void run() {
                if (CommandShowCase.this.sendingTaskTip.isDisposed()) {
                    return;
                }
                CommandShowCase.this.sendingTaskTip.setSelection(this.selection);
                ++this.selection;
                if (this.selection <= 100) {
                    CommandShowCase.this.getComposite().getShell().getDisplay().timerExec(this.deltaTime, (Runnable)this);
                } else {
                    CommandShowCase.this.sendingTaskTip.setVisible(false);
                }
            }
        });
    }

    public void quit() {
        this.commandExit.dispose();
        this.commandOpen.dispose();
        this.commandDelete.dispose();
        this.commandGroupSend.dispose();
        this.commandViaInfrared.dispose();
        this.commandViaBlueTooth.dispose();
        this.commandViaUSB.dispose();
        if (this.sendingTaskTip != null) {
            this.sendingTaskTip.dispose();
        }
        this.dispose();
    }

    private void showDetails(int n) {
        String string = this.list.getItem(n);
        PhoneBookEntry phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(string);
        if (phoneBookEntry != null) {
            this.details.setText(phoneBookEntry.get0rganization());
        }
    }

    private void populateList() {
        this.list.removeAll();
        Vector vector = this.phoneBookDataBase.getSurnameNameVector();
        int n = 0;
        while (n < vector.size()) {
            this.list.add((String)vector.get(n));
            ++n;
        }
    }

    protected void updateListAndDetails() {
        this.populateList();
        if (this.list.getSelectionCount() > 0) {
            this.showDetails(this.list.getSelectionIndex());
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        PhoneBookEntry phoneBookEntry;
        if (modifyEvent.widget == this.details && this.list.getSelectionIndex() >= 0 && (phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(string = this.list.getItem(this.list.getSelectionIndex()))) != null) {
            phoneBookEntry.set0rganization(this.details.getText());
        }
    }
}

