/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Hashtable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.AbstractPartSelectionTracker;

public abstract class AbstractSelectionService
implements ISelectionService,
IPartListener {
    private ListenerList listeners = new ListenerList();
    private ListenerList postListeners = new ListenerList();
    private IWorkbenchPart activePart;
    private ISelectionProvider activeProvider;
    private Hashtable perPartTrackers;
    private ISelectionChangedListener selListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            AbstractSelectionService.this.fireSelection(AbstractSelectionService.this.activePart, selectionChangedEvent.getSelection());
        }
    };
    private ISelectionChangedListener postSelListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            AbstractSelectionService.this.firePostSelection(AbstractSelectionService.this.activePart, selectionChangedEvent.getSelection());
        }
    };

    protected AbstractSelectionService() {
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        this.listeners.add((Object)iSelectionListener);
    }

    public void addSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).addSelectionListener(iSelectionListener);
    }

    public void addPostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.add((Object)iSelectionListener);
    }

    public void addPostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).addPostSelectionListener(iSelectionListener);
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.listeners.remove((Object)iSelectionListener);
    }

    public void removePostSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).removePostSelectionListener(iSelectionListener);
    }

    public void removePostSelectionListener(ISelectionListener iSelectionListener) {
        this.postListeners.remove((Object)iSelectionListener);
    }

    public void removeSelectionListener(String string, ISelectionListener iSelectionListener) {
        this.getPerPartTracker(string).removeSelectionListener(iSelectionListener);
    }

    protected void fireSelection(final IWorkbenchPart iWorkbenchPart, final ISelection iSelection) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            if (iWorkbenchPart != null && iSelection != null || iSelectionListener instanceof INullSelectionListener) {
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
                    }
                });
            }
            ++n;
        }
    }

    protected void firePostSelection(final IWorkbenchPart iWorkbenchPart, final ISelection iSelection) {
        Object[] objectArray = this.postListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ISelectionListener iSelectionListener = (ISelectionListener)objectArray[n];
            if (iWorkbenchPart != null && iSelection != null || iSelectionListener instanceof INullSelectionListener) {
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        iSelectionListener.selectionChanged(iWorkbenchPart, iSelection);
                    }
                });
            }
            ++n;
        }
    }

    protected AbstractPartSelectionTracker getPerPartTracker(String string) {
        AbstractPartSelectionTracker abstractPartSelectionTracker;
        if (this.perPartTrackers == null) {
            this.perPartTrackers = new Hashtable(4);
        }
        if ((abstractPartSelectionTracker = (AbstractPartSelectionTracker)this.perPartTrackers.get(string)) == null) {
            abstractPartSelectionTracker = this.createPartTracker(string);
            this.perPartTrackers.put(string, abstractPartSelectionTracker);
        }
        return abstractPartSelectionTracker;
    }

    protected abstract AbstractPartSelectionTracker createPartTracker(String var1);

    public ISelection getSelection() {
        if (this.activeProvider != null) {
            return this.activeProvider.getSelection();
        }
        return null;
    }

    public ISelection getSelection(String string) {
        return this.getPerPartTracker(string).getSelection();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.activePart) {
            return;
        }
        this.reset();
        this.activePart = iWorkbenchPart;
        if (this.activePart != null) {
            this.activeProvider = this.activePart.getSite().getSelectionProvider();
            if (this.activeProvider != null) {
                this.activeProvider.addSelectionChangedListener(this.selListener);
                ISelection iSelection = this.activeProvider.getSelection();
                this.fireSelection(iWorkbenchPart, iSelection);
                if (this.activeProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)this.activeProvider).addPostSelectionChangedListener(this.postSelListener);
                } else {
                    this.activeProvider.addSelectionChangedListener(this.postSelListener);
                }
                this.firePostSelection(iWorkbenchPart, iSelection);
            } else {
                this.activePart = null;
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.activePart) {
            this.reset();
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.activePart) {
            this.reset();
        }
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void partInputChanged(IWorkbenchPart iWorkbenchPart) {
        if (this.activePart == iWorkbenchPart) {
            this.reset();
            this.partActivated(iWorkbenchPart);
        }
    }

    public void reset() {
        if (this.activePart != null) {
            this.fireSelection(null, null);
            this.firePostSelection(null, null);
            if (this.activeProvider != null) {
                this.activeProvider.removeSelectionChangedListener(this.selListener);
                if (this.activeProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)this.activeProvider).removePostSelectionChangedListener(this.postSelListener);
                } else {
                    this.activeProvider.removeSelectionChangedListener(this.postSelListener);
                }
                this.activeProvider = null;
            }
            this.activePart = null;
        }
    }
}

