/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.update.internal.core.Assert;

public final class URLEncoder {
    private URLEncoder() {
    }

    public static String encode(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                stringBuffer.append(string4);
                continue;
            }
            stringBuffer.append(URLEncoder.encodeSegment(string4));
        }
        if (string2 != null) {
            stringBuffer.append('?');
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append('#');
            stringBuffer.append(URLEncoder.encodeSegment(string3));
        }
        return stringBuffer.toString();
    }

    public static URL encode(URL uRL) throws MalformedURLException {
        String string = uRL.getPath();
        String string2 = uRL.getQuery();
        String string3 = uRL.getRef();
        String string4 = uRL.getAuthority();
        String string5 = uRL.getHost();
        int n = uRL.getPort();
        URL uRL2 = uRL;
        if (uRL.getProtocol().equals("file")) {
            return uRL2;
        }
        if (string4 == null || string4.equals("") || string4.equals(String.valueOf(string5) + ":" + n)) {
            uRL2 = new URL(uRL.getProtocol(), string5, n, URLEncoder.encode(string, string2, string3));
        }
        return uRL2;
    }

    private static String encodeSegment(String string) {
        if (string.indexOf(37) != -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (URLEncoder.mustEncode(c)) {
                byte[] byArray = null;
                try {
                    byArray = new Character(c).toString().getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Assert.isTrue(false, unsupportedEncodingException.getMessage());
                }
                int n2 = 0;
                while (n2 < byArray.length) {
                    stringBuffer.append('%');
                    stringBuffer.append(Integer.toHexString(byArray[n2] >> 4 & 0xF));
                    stringBuffer.append(Integer.toHexString(byArray[n2] & 0xF));
                    ++n2;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean mustEncode(char c) {
        if (c >= 'a' && c <= 'z') {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            return false;
        }
        if (c >= '0' && c <= '9') {
            return false;
        }
        if (c >= '\'' && c <= '.') {
            return false;
        }
        if (c == '!' || c == '$' || c == '_') {
            return false;
        }
        return c != ':';
    }
}

