/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.XMLContentDescriber;
import org.eclipse.core.internal.content.XMLRootHandler;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLRootElementContentDescriber2
extends XMLContentDescriber
implements IExecutableExtension {
    private static final String ELEMENT_TO_FIND = "element";
    private QualifiedElement[] elementsToFind = null;
    static /* synthetic */ Class class$0;

    private int checkCriteria(InputSource inputSource) throws IOException {
        XMLRootHandler xMLRootHandler = new XMLRootHandler(this.elementsToFind != null);
        try {
            if (!xMLRootHandler.parseContents(inputSource)) {
                return 1;
            }
        }
        catch (SAXException sAXException) {
            return 1;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = ContentMessages.content_parserConfiguration;
            RuntimeLog.log((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, string, (Throwable)parserConfigurationException));
            throw new RuntimeException(string);
        }
        if (this.elementsToFind != null) {
            boolean bl = false;
            int n = 0;
            while (n < this.elementsToFind.length && !bl) {
                bl |= this.elementsToFind[n].matches(xMLRootHandler.getRootNamespace(), xMLRootHandler.getRootName(), xMLRootHandler.getDTD());
                ++n;
            }
            if (!bl) {
                return 1;
            }
        }
        return 2;
    }

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        if (super.describe(inputStream, iContentDescription) == 0) {
            return 0;
        }
        inputStream.reset();
        return this.checkCriteria(new InputSource(inputStream));
    }

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        if (super.describe(reader, iContentDescription) == 0) {
            return 0;
        }
        reader.reset();
        return this.checkCriteria(new InputSource(reader));
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        Object object2;
        if (object instanceof String) {
            this.elementsToFind = new QualifiedElement[]{new QualifiedElement((String)object)};
        } else if (object instanceof Hashtable) {
            object2 = null;
            IConfigurationElement iConfigurationElement2 = iConfigurationElement.getChildren("describer")[0];
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement2.getChildren("parameter");
            String string2 = null;
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                string2 = iConfigurationElementArray[n].getAttribute("name");
                if (ELEMENT_TO_FIND.equals(string2)) {
                    if (object2 == null) {
                        object2 = new LinkedList();
                    }
                    object2.add(new QualifiedElement(iConfigurationElementArray[n].getAttribute("value")));
                }
                ++n;
            }
            ArrayList arrayList = new ArrayList();
            if (object2 != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            this.elementsToFind = arrayList.toArray(new QualifiedElement[arrayList.size()]);
        }
        if (this.elementsToFind.length == 0) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.content.XMLRootElementContentDescriber2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object2 = NLS.bind((String)ContentMessages.content_badInitializationData, (Object)clazz.getName());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, (String)object2, null));
        }
    }

    private class QualifiedElement {
        private String namespace;
        private String element;
        private String dtd;

        public QualifiedElement(String string, String string2, String string3) {
            this.namespace = string;
            this.element = string2;
            this.dtd = string3;
        }

        public QualifiedElement(String string) {
            int n;
            int n2 = string.indexOf(123);
            int n3 = string.indexOf(125);
            if (n2 == 0 && n3 >= 1) {
                this.namespace = string.substring(1, n3);
                string = string.substring(n3 + 1);
            }
            if ((n = string.indexOf(47)) > 0) {
                this.dtd = string.substring(n + 1);
                string = string.substring(0, n);
            }
            this.element = "*".equals(string) ? null : string;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getElement() {
            return this.element;
        }

        public String getDTD() {
            return this.dtd;
        }

        public boolean matches(String string, String string2, String string3) {
            boolean bl;
            boolean bl2 = this.namespace != null ? this.namespace.equals(string) : true;
            boolean bl3 = this.element != null ? this.element.equals(string2) : true;
            boolean bl4 = bl = this.dtd != null ? this.dtd.equals(string3) : true;
            return bl2 && bl3 && bl;
        }
    }
}

