/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.PatchCleaner;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UnconfigOperation
extends FeatureOperation
implements IUnconfigFeatureOperation {
    boolean bBatchUnconfigOperation = false;

    public UnconfigOperation(IConfiguredSite iConfiguredSite, IFeature iFeature) {
        super(iConfiguredSite, iFeature);
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException {
        Object object;
        if (!this.bBatchUnconfigOperation && (object = OperationsManager.getValidator().validatePendingUnconfig(this.feature)) != null && object.getCode() == 4) {
            throw new CoreException((IStatus)object);
        }
        object = new PatchCleaner(this.targetSite, this.feature);
        this.targetSite.unconfigure(this.feature);
        ((PatchCleaner)object).dispose();
        try {
            boolean bl = false;
            IFeatureOperation iFeatureOperation = OperationsManager.findPendingOperation(this.feature);
            if (iFeatureOperation instanceof IConfigFeatureOperation) {
                OperationsManager.removePendingOperation(iFeatureOperation);
            } else {
                OperationsManager.addPendingOperation(this);
                bl = true;
            }
            this.markProcessed();
            if (iOperationListener != null) {
                iOperationListener.afterExecute(this, null);
            }
            bl = SiteManager.getLocalSite().save() && bl;
            OperationsManager.fireObjectChanged(this.feature, null);
            return bl;
        }
        catch (CoreException coreException) {
            this.undo();
            UpdateUtils.logException(coreException);
            throw coreException;
        }
    }

    void setBatchUnconfigOperation() {
        this.bBatchUnconfigOperation = true;
    }

    public void undo() throws CoreException {
        this.targetSite.configure(this.feature);
    }
}

