/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.NestedDirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.BasePermissionStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.internal.baseadaptor.BundleInstall;
import org.eclipse.osgi.internal.baseadaptor.BundleUninstall;
import org.eclipse.osgi.internal.baseadaptor.BundleUpdate;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.eclipse.osgi.internal.baseadaptor.StateManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.SynchronousBundleListener;

public class BaseStorage
implements SynchronousBundleListener {
    private static final String RUNTIME_ADAPTOR = "org.eclipse.osgi/eclipseadaptor";
    private static final String OPTION_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin";
    private static final String OPTION_PLATFORM_ADMIN_RESOLVER = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin/resolver";
    private static final String OPTION_MONITOR_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/resolver/timing";
    private static final String OPTION_RESOLVER_READER = "org.eclipse.osgi/eclipseadaptor/resolver/reader/timing";
    private static final String PROP_FRAMEWORK_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_BUNDLE_STORE = "osgi.bundlestore";
    static final String DATA_DIR_NAME = "data";
    static final String LIB_TEMP = "libtemp";
    private static final String PROP_ENABLE_STATE_SAVER = "eclipse.enableStateSaver";
    static final String BUNDLEFILE_NAME = "bundlefile";
    private static final String PROP_CLEAN = "osgi.clean";
    public static final byte BUNDLEDATA_VERSION = 18;
    public static final byte EXTENSION_INITIALIZE = 1;
    public static final byte EXTENSION_INSTALLED = 2;
    public static final byte EXTENSION_UNINSTALLED = 4;
    public static final byte EXTENSION_UPDATED = 8;
    public static final String DELETE_FLAG = ".delete";
    private static final String PERM_DATA_FILE = ".permdata";
    private static final byte PERMDATA_VERSION = 1;
    private BaseAdaptor adaptor;
    private String installPath;
    private StorageManager storageManager;
    private StateManager stateManager;
    private KeyedHashSet storageHooks = new KeyedHashSet(5, false);
    private BundleContext context;
    private SynchronousBundleListener extensionListener;
    private final Method addFwkURLMethod = BaseStorage.findAddURLMethod(this.getFwkClassLoader(), "addURL");
    private final Method addExtURLMethod = BaseStorage.findAddURLMethod(this.getExtClassLoader(), "addURL");
    private String[] configuredExtensions;
    private long timeStamp = 0L;
    private int initialBundleStartLevel = 1;
    private long nextId = 1L;
    private File bundleStoreRoot;
    private BasePermissionStorage permissionStorage;
    private StateSaver stateSaver;
    private boolean invalidState;
    private boolean storageManagerClosed;
    static /* synthetic */ Class class$0;

    BaseStorage() {
    }

    public void initialize(BaseAdaptor baseAdaptor) throws IOException {
        Location location;
        this.adaptor = baseAdaptor;
        BaseStorage.setDebugOptions();
        if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_CLEAN)).booleanValue()) {
            this.cleanOSGiCache();
        }
        if ((location = LocationManager.getInstallLocation()) != null) {
            URL uRL = location.getURL();
            this.installPath = uRL.getPath();
        }
        boolean bl = LocationManager.getConfigurationLocation().isReadOnly();
        this.storageManager = this.initFileManager(LocationManager.getOSGiConfigurationDir(), bl ? "none" : null, bl);
        this.storageManagerClosed = false;
        StorageHook[] storageHookArray = baseAdaptor.getHookRegistry().getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length) {
            this.storageHooks.add(storageHookArray[n]);
            ++n;
        }
    }

    private static Method findAddURLMethod(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return null;
        }
        Class<?> clazz = classLoader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        return BaseStorage.findMethod(clazz, string, classArray);
    }

    private static Method findMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        return BaseStorage.findMethod(clazz.getSuperclass(), string, classArray);
    }

    private static void callAddURLMethod(ClassLoader classLoader, Method method, URL uRL) throws InvocationTargetException {
        try {
            method.invoke((Object)classLoader, uRL);
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable);
        }
    }

    private ClassLoader getFwkClassLoader() {
        return this.getClass().getClassLoader();
    }

    private ClassLoader getExtClassLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader2 = classLoader.getParent();
        while (classLoader2 != null && classLoader2.getParent() != null) {
            classLoader2 = classLoader2.getParent();
        }
        return classLoader2;
    }

    private static void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        StateManager.DEBUG = frameworkDebugOptions != null;
        StateManager.DEBUG_READER = frameworkDebugOptions.getBooleanOption(OPTION_RESOLVER_READER, false);
        StateManager.MONITOR_PLATFORM_ADMIN = frameworkDebugOptions.getBooleanOption(OPTION_MONITOR_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN = frameworkDebugOptions.getBooleanOption(OPTION_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER = frameworkDebugOptions.getBooleanOption(OPTION_PLATFORM_ADMIN_RESOLVER, false);
    }

    protected StorageManager initFileManager(File file, String string, boolean bl) {
        StorageManager storageManager = new StorageManager(file, string, bl);
        try {
            storageManager.open(!bl);
        }
        catch (IOException iOException) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error reading framework metadata: " + iOException.getMessage());
                Debug.printStackTrace(iOException);
            }
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, iOException.getMessage());
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string2, 0, iOException, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
        }
        return storageManager;
    }

    public boolean isReadOnly() {
        return this.storageManager.isReadOnly();
    }

    public void compact() throws IOException {
        if (!this.isReadOnly()) {
            this.compact(this.getBundleStoreRoot());
        }
    }

    private void compact(File file) {
        String[] stringArray;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("compact(" + file.getPath() + ")");
        }
        if ((stringArray = file.list()) == null) {
            return;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2;
            if (!DATA_DIR_NAME.equals(stringArray[n2]) && (file2 = new File(file, stringArray[n2])).isDirectory()) {
                File file3 = new File(file2, DELETE_FLAG);
                if (file3.exists()) {
                    if (!AdaptorUtil.rm(file2) && !file3.exists()) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("Unable to write " + file3.getPath() + ": " + iOException.getMessage());
                            }
                        }
                    }
                } else {
                    this.compact(file2);
                }
            }
            ++n2;
        }
    }

    public long getFreeSpace() throws IOException {
        return -1L;
    }

    public File getDataFile(BaseData baseData, String string) {
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            return null;
        }
        return baseStorageHook.getDataFile(string);
    }

    BaseAdaptor getAdaptor() {
        return this.adaptor;
    }

    public void installNativeCode(BaseData baseData, String[] stringArray) throws BundleException {
        BaseStorageHook baseStorageHook;
        if (stringArray.length > 0 && (baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY)) != null) {
            baseStorageHook.installNativePaths(stringArray);
        }
    }

    public Dictionary loadManifest(BaseData baseData) throws BundleException {
        return this.loadManifest(baseData, false);
    }

    public Dictionary loadManifest(BaseData baseData, boolean bl) throws BundleException {
        Dictionary dictionary = null;
        StorageHook[] storageHookArray = baseData.getStorageHooks();
        int n = 0;
        while (n < storageHookArray.length && dictionary == null) {
            dictionary = storageHookArray[n].getManifest(bl);
            ++n;
        }
        if (dictionary == null) {
            dictionary = AdaptorUtil.loadManifestFrom(baseData);
        }
        if (dictionary == null) {
            throw new BundleException(NLS.bind(AdaptorMsg.MANIFEST_NOT_FOUND_EXCEPTION, "META-INF/MANIFEST.MF", baseData.getLocation()));
        }
        return dictionary;
    }

    public File getExtractFile(BaseData baseData, String string) {
        File file;
        File file2;
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            return null;
        }
        File file3 = baseStorageHook.getGenerationDir();
        if (file3 != null && (file2 = new File(file3, string)).exists()) {
            return file2;
        }
        file2 = baseStorageHook.getParentGenerationDir();
        if (file2 != null && (file = new File(file2, string)).exists()) {
            return file;
        }
        file = baseStorageHook.createGenerationDir();
        if (file != null && file.exists()) {
            return new File(file, string);
        }
        return null;
    }

    public BaseData[] getInstalledBundles() {
        return this.readBundleDatas();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseData[] readBundleDatas() {
        var1_1 = this.findStorageStream(".bundledata");
        if (var1_1 == null) {
            return null;
        }
        try {
            block20: {
                var2_2 = new DataInputStream(new BufferedInputStream(var1_1));
                try {
                    var3_4 = var2_2.readByte();
                    if (var3_4 != 18) {
lbl10:
                        // 3 sources

                        while (true) {
                            var16_5 = null;
                            break block20;
                            break;
                        }
                    }
                    this.timeStamp = var2_2.readLong();
                    this.initialBundleStartLevel = var2_2.readInt();
                    this.nextId = var2_2.readLong();
                    var4_8 = var2_2.readInt();
                    if (var4_8 != (var5_9 = this.adaptor.getHookRegistry().getStorageHooks()).length) ** GOTO lbl10
                    var6_10 = 0;
                    while (true) {
                        if (var6_10 >= var4_8) break;
                        var7_11 = var5_9[var6_10].getKey();
                        var8_12 = var5_9[var6_10].getStorageVersion();
                        if (var7_11.equals(var2_2.readUTF()) && var8_12 == var2_2.readInt()) ** break;
                        ** continue;
                        ++var6_10;
                    }
                    var6_10 = var2_2.readInt();
                    var7_11 = new ArrayList<BaseData>(var6_10);
                    var8_13 = -1L;
                    var10_14 = false;
                    var11_15 = 0;
                    while (true) {
                        block21: {
                            if (var11_15 >= var6_10) {
                                if (var10_14) {
                                    FrameworkProperties.setProperty("eclipse.refreshBundles", "true");
                                }
                                break;
                            }
                            var12_16 = false;
                            var13_17 = null;
                            try {
                                var8_13 = var2_2.readLong();
                                if (var8_13 == 0L) break block21;
                                var13_17 = this.loadBaseData(var8_13, var2_2);
                                var13_17.getBundleFile();
                                var14_18 = var13_17.getStorageHooks();
                                var15_20 = 0;
                                while (true) {
                                    if (var15_20 >= var14_18.length) {
                                        if (Debug.DEBUG_GENERAL) {
                                            Debug.println("BundleData created: " + var13_17);
                                        }
                                        this.processExtension(var13_17, (byte)1);
                                        var7_11.add(var13_17);
                                        break;
                                    }
                                    var14_18[var15_20].validate();
                                    ++var15_20;
                                }
                            }
                            catch (IllegalArgumentException v0) {
                                var10_14 = true;
                                var12_16 = true;
                            }
                            catch (BundleException v1) {
                                var10_14 = true;
                                var12_16 = true;
                            }
                            catch (IOException var14_19) {
                                var10_14 = true;
                                var12_16 = true;
                                if (!Debug.DEBUG_GENERAL) break block21;
                                Debug.println("Error reading framework metadata: " + var14_19.getMessage());
                                Debug.printStackTrace(var14_19);
                            }
                        }
                        if (var12_16 && var13_17 != null) {
                            var14_18 = (StorageHook[])var13_17.getStorageHook(BaseStorageHook.KEY);
                            var14_18.delete(true, 1);
                        }
                        ++var11_15;
                    }
                    var18_21 = var7_11.toArray(new BaseData[var7_11.size()]);
                    var16_6 = null;
                }
                catch (Throwable var17_22) {
                    var16_7 = null;
                    var2_2.close();
                    throw var17_22;
                }
                var2_2.close();
                return var18_21;
            }
            var2_2.close();
            return null;
        }
        catch (IOException var2_3) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error reading framework metadata: " + var2_3.getMessage());
                Debug.printStackTrace(var2_3);
            }
            return null;
        }
    }

    private void saveAllData(boolean bl) {
        if (this.storageManagerClosed) {
            try {
                this.storageManager.open(!LocationManager.getConfigurationLocation().isReadOnly());
                this.storageManagerClosed = false;
            }
            catch (IOException iOException) {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, iOException.getMessage());
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, iOException, null);
                this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            }
        }
        this.saveBundleDatas();
        this.saveStateData(bl);
        this.savePermissionStorage();
        if (bl) {
            this.stateManager.stopDataManager();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BasePermissionStorage readPermissionData() {
        BasePermissionStorage basePermissionStorage = new BasePermissionStorage(this);
        InputStream inputStream = this.findStorageStream(PERM_DATA_FILE);
        if (inputStream == null) {
            return basePermissionStorage;
        }
        try {
            DataInputStream dataInputStream;
            block18: {
                BasePermissionStorage basePermissionStorage2;
                block17: {
                    dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                    try {
                        String[] stringArray;
                        int n;
                        int n2;
                        if (1 != dataInputStream.readByte()) {
                            basePermissionStorage2 = basePermissionStorage;
                            Object var10_6 = null;
                            break block17;
                        }
                        int n3 = dataInputStream.readInt();
                        if (n3 > 0) {
                            String[] stringArray2 = new String[n3];
                            n2 = 0;
                            while (true) {
                                if (n2 >= n3) {
                                    basePermissionStorage.setPermissionData(null, stringArray2);
                                    break;
                                }
                                stringArray2[n2] = dataInputStream.readUTF();
                                ++n2;
                            }
                        }
                        if ((n = dataInputStream.readInt()) > 0) {
                            n2 = 0;
                            block6: while (n2 < n) {
                                stringArray = dataInputStream.readUTF();
                                n3 = dataInputStream.readInt();
                                String[] stringArray3 = new String[n3];
                                int n4 = 0;
                                while (true) {
                                    if (n4 >= n3) {
                                        basePermissionStorage.setPermissionData((String)stringArray, stringArray3);
                                        ++n2;
                                        continue block6;
                                    }
                                    stringArray3[n4] = dataInputStream.readUTF();
                                    ++n4;
                                }
                            }
                        }
                        if ((n2 = dataInputStream.readInt()) > 0) {
                            stringArray = new String[n2];
                            int n5 = 0;
                            while (true) {
                                if (n5 >= n2) {
                                    basePermissionStorage.saveConditionalPermissionInfos(stringArray);
                                    break;
                                }
                                stringArray[n5] = dataInputStream.readUTF();
                                ++n5;
                            }
                        }
                        basePermissionStorage.setDirty(false);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var10_7 = null;
                        dataInputStream.close();
                        throw throwable;
                    }
                }
                dataInputStream.close();
                return basePermissionStorage2;
            }
            Object var10_8 = null;
            dataInputStream.close();
            return basePermissionStorage;
        }
        catch (IOException iOException) {
            this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
        }
        return basePermissionStorage;
    }

    /*
     * Exception decompiling
     */
    private void savePermissionStorage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 333->339)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void saveBundleDatas() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 315->321)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveStateData(boolean bl) {
        File file;
        block13: {
            if (bl && "true".equals(FrameworkProperties.getProperty("osgi.forcedRestart"))) {
                this.stateManager.getSystemState().setTimeStamp(this.stateManager.getSystemState().getTimeStamp() + 1L);
            }
            if (this.stateManager == null) return;
            if (this.isReadOnly()) return;
            if (!this.stateManager.saveNeeded()) {
                return;
            }
            File file2 = null;
            file = null;
            try {
                try {
                    file2 = File.createTempFile(".state", ".new", LocationManager.getOSGiConfigurationDir());
                    file = File.createTempFile(".lazy", ".new", LocationManager.getOSGiConfigurationDir());
                    if (bl) {
                        this.stateManager.shutdown(file2, file);
                    } else {
                        StateManager stateManager = this.stateManager;
                        synchronized (stateManager) {
                            this.stateManager.update(file2, file);
                        }
                    }
                    this.storageManager.lookup(".state", true);
                    this.storageManager.lookup(".lazy", true);
                    this.storageManager.update(new String[]{".state", ".lazy"}, new String[]{file2.getName(), file.getName()});
                }
                catch (IOException iOException) {
                    this.adaptor.getFrameworkLog().log(new FrameworkEvent(2, this.context.getBundle(), iOException));
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (file2 != null && file2.exists()) {
                    file2.delete();
                }
                if (file == null) throw throwable;
                if (!file.exists()) throw throwable;
                file.delete();
                throw throwable;
            }
            {
                Object var5_8 = null;
                if (file2 == null || !file2.exists()) break block13;
                file2.delete();
            }
        }
        if (file == null) return;
        if (!file.exists()) return;
        file.delete();
    }

    public PermissionStorage getPermissionStorage() throws IOException {
        if (this.permissionStorage == null) {
            this.permissionStorage = this.readPermissionData();
        }
        return this.permissionStorage;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int n) {
        this.initialBundleStartLevel = n;
        this.requestSave();
    }

    public void save(BaseData baseData) throws IOException {
        if (baseData.isDirty()) {
            --this.timeStamp;
            this.requestSave();
            baseData.setDirty(false);
        }
    }

    public BundleOperation installBundle(String string, URLConnection uRLConnection) {
        BaseData baseData = this.createBaseData(this.getNextBundleId(), string);
        return new BundleInstall(baseData, uRLConnection, this);
    }

    public BundleOperation updateBundle(BaseData baseData, URLConnection uRLConnection) {
        return new BundleUpdate(baseData, uRLConnection, this);
    }

    public BundleOperation uninstallBundle(BaseData baseData) {
        return new BundleUninstall(baseData, this);
    }

    protected Object getBundleContent(BaseData baseData) throws IOException {
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            throw new IllegalStateException();
        }
        return baseStorageHook.isReference() ? new File(baseStorageHook.getFileName()) : new File(baseStorageHook.getGenerationDir(), baseStorageHook.getFileName());
    }

    public BundleFile createBundleFile(Object object, BaseData baseData) throws IOException {
        boolean bl = false;
        if (object == null) {
            bl = true;
            object = this.getBundleContent(baseData);
        }
        BundleFile bundleFile = null;
        BundleFileFactoryHook[] bundleFileFactoryHookArray = this.adaptor.getHookRegistry().getBundleFileFactoryHooks();
        int n = 0;
        while (n < bundleFileFactoryHookArray.length && bundleFile == null) {
            bundleFile = bundleFileFactoryHookArray[n].createBundleFile(object, baseData, bl);
            ++n;
        }
        if (bundleFile == null && object instanceof File) {
            File file = (File)object;
            bundleFile = file.isDirectory() ? new DirBundleFile(file) : new ZipBundleFile(file, baseData);
        }
        if (bundleFile == null && object instanceof String) {
            bundleFile = new NestedDirBundleFile(baseData.getBundleFile(), (String)object);
        }
        if (bundleFile == null) {
            throw new IOException("Cannot create bundle file for content of type: " + object.getClass().getName());
        }
        BundleFileWrapperFactoryHook[] bundleFileWrapperFactoryHookArray = this.adaptor.getHookRegistry().getBundleFileWrapperFactoryHooks();
        int n2 = 0;
        while (n2 < bundleFileWrapperFactoryHookArray.length) {
            BundleFile bundleFile2 = bundleFileWrapperFactoryHookArray[n2].wrapBundleFile(bundleFile, object, baseData, bl);
            if (bundleFile2 != null) {
                bundleFile = bundleFile2;
            }
            ++n2;
        }
        return bundleFile;
    }

    public synchronized StateManager getStateManager() {
        if (this.stateManager != null) {
            return this.stateManager;
        }
        this.stateManager = this.readStateData();
        this.checkSystemState(this.stateManager.getSystemState());
        return this.stateManager;
    }

    private void checkSystemState(State state) {
        BundleDescription bundleDescription;
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        if (bundleDescriptionArray == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (this.context.getBundle(bundleDescriptionArray[n].getBundleId()) == null) {
                state.removeBundle(bundleDescriptionArray[n]);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            state.resolve(false);
        }
        if ((bundleDescription = state.getBundle(0L)) == null || !bundleDescription.isResolved()) {
            ResolverError[] resolverErrorArray = bundleDescription == null ? new ResolverError[]{} : state.getResolverErrors(bundleDescription);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < resolverErrorArray.length) {
                stringBuffer.append(resolverErrorArray[n2].toString());
                if (n2 < resolverErrorArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            throw new IllegalStateException(NLS.bind(AdaptorMsg.SYSTEMBUNDLE_NOTRESOLVED, ((Object)stringBuffer).toString()));
        }
    }

    private StateManager readStateData() {
        File[] fileArray = this.findStorageFiles(new String[]{".state", ".lazy"});
        File file = fileArray[0];
        File file2 = fileArray[1];
        this.stateManager = new StateManager(file, file2, this.context, this.timeStamp);
        State state = null;
        if (!this.invalidState && (state = this.stateManager.readSystemState()) != null) {
            return this.stateManager;
        }
        state = this.stateManager.createSystemState();
        Bundle[] bundleArray = this.context.getBundles();
        if (bundleArray == null) {
            return this.stateManager;
        }
        StateObjectFactory stateObjectFactory = this.stateManager.getFactory();
        int n = 0;
        while (n < bundleArray.length) {
            AbstractBundle abstractBundle = (AbstractBundle)bundleArray[n];
            try {
                Dictionary dictionary = this.loadManifest((BaseData)abstractBundle.getBundleData(), true);
                BundleDescription bundleDescription = stateObjectFactory.createBundleDescription(state, dictionary, abstractBundle.getLocation(), abstractBundle.getBundleId());
                state.addBundle(bundleDescription);
            }
            catch (BundleException bundleException) {}
            ++n;
        }
        state.resolve();
        this.invalidState = false;
        return this.stateManager;
    }

    private File[] findStorageFiles(String[] stringArray) {
        File[] fileArray;
        block16: {
            block15: {
                fileArray = new File[stringArray.length];
                try {
                    int n = 0;
                    while (n < fileArray.length) {
                        fileArray[n] = this.storageManager.lookup(stringArray[n], false);
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.DEBUG_GENERAL) break block15;
                    Debug.println("Error reading state file " + iOException.getMessage());
                    Debug.printStackTrace(iOException);
                }
            }
            boolean bl = true;
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] == null || !fileArray[n].isFile()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                return fileArray;
            }
            Location location = null;
            Location location2 = LocationManager.getConfigurationLocation();
            if (location2 != null && (location = location2.getParentLocation()) != null) {
                try {
                    File file = new File(location.getURL().getFile(), "org.eclipse.osgi");
                    StorageManager storageManager = this.initFileManager(file, "none", true);
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        fileArray[n2] = storageManager.lookup(stringArray[n2], false);
                        ++n2;
                    }
                    storageManager.close();
                }
                catch (IOException iOException) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("Error reading state file " + iOException.getMessage());
                        Debug.printStackTrace(iOException);
                    }
                    break block16;
                }
            }
            try {
                if (!this.isReadOnly()) {
                    int n3 = 0;
                    while (n3 < fileArray.length) {
                        fileArray[n3] = this.storageManager.lookup(stringArray[n3], true);
                        ++n3;
                    }
                }
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block16;
                Debug.println("Error reading state file " + iOException.getMessage());
                Debug.printStackTrace(iOException);
            }
        }
        return fileArray;
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        this.context = bundleContext;
        if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_ENABLE_STATE_SAVER, "true")).booleanValue()) {
            this.stateSaver = new StateSaver();
        }
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        if (this.stateSaver != null) {
            this.stateSaver.shutdown();
        }
        this.saveAllData(true);
        this.storageManager.close();
        this.storageManagerClosed = true;
        if (this.extensionListener != null) {
            this.context.removeBundleListener(this.extensionListener);
        }
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
        if (this.addFwkURLMethod != null) {
            properties.put("org.osgi.supports.framework.extension", "true");
        }
        properties.put(PROP_BUNDLE_STORE, this.getBundleStoreRoot().getAbsolutePath());
    }

    private InputStream findStorageStream(String string) {
        InputStream inputStream;
        block7: {
            inputStream = null;
            try {
                inputStream = this.storageManager.getInputStream(string);
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG_GENERAL) break block7;
                Debug.println("Error reading framework metadata: " + iOException.getMessage());
                Debug.printStackTrace(iOException);
            }
        }
        if (inputStream == null) {
            Location location = LocationManager.getConfigurationLocation();
            Location location2 = null;
            if (location != null && (location2 = location.getParentLocation()) != null) {
                try {
                    File file = new File(location2.getURL().getFile(), "org.eclipse.osgi");
                    StorageManager storageManager = this.initFileManager(file, "none", true);
                    inputStream = storageManager.getInputStream(string);
                    storageManager.close();
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
        return inputStream;
    }

    protected void saveBaseData(BaseData baseData, DataOutputStream dataOutputStream) throws IOException {
        StorageHook[] storageHookArray = baseData.getStorageHooks();
        dataOutputStream.writeInt(storageHookArray.length);
        int n = 0;
        while (n < storageHookArray.length) {
            dataOutputStream.writeUTF((String)storageHookArray[n].getKey());
            storageHookArray[n].save(dataOutputStream);
            ++n;
        }
    }

    protected BaseData loadBaseData(long l, DataInputStream dataInputStream) throws IOException {
        BaseData baseData = new BaseData(l, this.adaptor);
        int n = dataInputStream.readInt();
        StorageHook[] storageHookArray = new StorageHook[n];
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            StorageHook storageHook = (StorageHook)this.storageHooks.getByKey(string);
            if (storageHook == null) {
                throw new IOException();
            }
            storageHookArray[n2] = storageHook.load(baseData, dataInputStream);
            ++n2;
        }
        baseData.setStorageHooks(storageHookArray);
        return baseData;
    }

    protected BaseData createBaseData(long l, String string) {
        BaseData baseData = new BaseData(l, this.adaptor);
        baseData.setLocation(string);
        return baseData;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    private void cleanOSGiCache() {
        File file = LocationManager.getOSGiConfigurationDir();
        AdaptorUtil.rm(file);
    }

    protected void processExtension(BaseData baseData, byte by) throws BundleException {
        if ((baseData.getType() & 2) != 0) {
            this.validateExtension(baseData);
            this.processFrameworkExtension(baseData, by);
        } else if ((baseData.getType() & 4) != 0) {
            this.validateExtension(baseData);
            this.processBootExtension(baseData, by);
        } else if ((baseData.getType() & 0x10) != 0) {
            this.validateExtension(baseData);
            this.processExtExtension(baseData, by);
        }
    }

    private void validateExtension(BundleData bundleData) throws BundleException {
        Dictionary dictionary = bundleData.getManifest();
        if (dictionary.get("Import-Package") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_IMPORT_ERROR, bundleData.getLocation()));
        }
        if (dictionary.get("Require-Bundle") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_REQUIRE_ERROR, bundleData.getLocation()));
        }
        if (dictionary.get("Bundle-NativeCode") != null) {
            throw new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_NATIVECODE_ERROR, bundleData.getLocation()));
        }
    }

    protected void processFrameworkExtension(BaseData baseData, byte by) throws BundleException {
        if (this.addFwkURLMethod == null) {
            throw new BundleException("Framework extensions are not supported.", new UnsupportedOperationException());
        }
        this.addExtensionContent(baseData, by, this.getFwkClassLoader(), this.addFwkURLMethod);
    }

    protected void processExtExtension(BaseData baseData, byte by) throws BundleException {
        if (this.addExtURLMethod == null) {
            throw new BundleException("Extension classpath extensions are not supported.", new UnsupportedOperationException());
        }
        this.addExtensionContent(baseData, by, this.getExtClassLoader(), this.addExtURLMethod);
    }

    private void addExtensionContent(BaseData baseData, byte by, ClassLoader classLoader, Method method) throws BundleException {
        if ((by & 0xC) != 0) {
            return;
        }
        String[] stringArray = this.getConfiguredExtensions();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(baseData.getSymbolicName())) {
                return;
            }
            ++n;
        }
        if ((by & 2) != 0) {
            if (this.extensionListener == null) {
                this.extensionListener = this;
                this.context.addBundleListener(this.extensionListener);
            }
            return;
        }
        File[] fileArray = this.getExtensionFiles(baseData);
        if (fileArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2] != null) {
                try {
                    BaseStorage.callAddURLMethod(classLoader, method, AdaptorUtil.encodeFileURL(fileArray[n2]));
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), invocationTargetException);
                }
                catch (MalformedURLException malformedURLException) {
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), malformedURLException);
                }
            }
            ++n2;
        }
        try {
            classLoader.loadClass("thisIsNotAClass");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    protected String[] getConfiguredExtensions() {
        if (this.configuredExtensions != null) {
            return this.configuredExtensions;
        }
        String string = FrameworkProperties.getProperty(PROP_FRAMEWORK_EXTENSIONS);
        this.configuredExtensions = string == null || string.trim().length() == 0 ? new String[0] : ManifestElement.getArrayFromList(string);
        return this.configuredExtensions;
    }

    protected void processBootExtension(BundleData bundleData, byte by) throws BundleException {
        throw new BundleException("Boot classpath extensions are not supported.", new UnsupportedOperationException());
    }

    private void initBundleStoreRoot() {
        File file = LocationManager.getOSGiConfigurationDir();
        this.bundleStoreRoot = file != null ? new File(file, "bundles") : new File("bundles");
    }

    public File getBundleStoreRoot() {
        if (this.bundleStoreRoot == null) {
            this.initBundleStoreRoot();
        }
        return this.bundleStoreRoot;
    }

    protected File[] getExtensionFiles(BaseData baseData) {
        File[] fileArray = null;
        try {
            Object object;
            String[] stringArray = baseData.getClassPath();
            if (DevClassPathHelper.inDevelopmentMode()) {
                object = DevClassPathHelper.getDevClassPath(baseData.getSymbolicName());
                String[] stringArray2 = stringArray;
                stringArray = new String[stringArray2.length + ((String[])object).length];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                System.arraycopy(object, 0, stringArray, stringArray2.length, ((Object)object).length);
            }
            object = new ArrayList(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (".".equals(stringArray[n])) {
                    ((ArrayList)object).add(baseData.getBundleFile().getBaseFile());
                } else {
                    File file = baseData.getBundleFile().getFile(stringArray[n], false);
                    if (file != null) {
                        ((ArrayList)object).add(file);
                    }
                }
                ++n;
            }
            return ((ArrayList)object).toArray(new File[((ArrayList)object).size()]);
        }
        catch (BundleException bundleException) {
            this.adaptor.getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), bundleException);
            return fileArray;
        }
    }

    void requestSave() {
        if (this.stateSaver == null) {
            return;
        }
        this.stateSaver.requestSave();
    }

    /*
     * Exception decompiling
     */
    public void updateState(BundleData var1_1, int var2_2) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 234->238)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateNativeCodePaths(BundleDescription bundleDescription, BaseData baseData) {
        NativeCodeSpecification nativeCodeSpecification = bundleDescription.getNativeCodeSpecification();
        if (nativeCodeSpecification == null) {
            return;
        }
        NativeCodeDescription[] nativeCodeDescriptionArray = nativeCodeSpecification.getPossibleSuppliers();
        int n = 0;
        while (n < nativeCodeDescriptionArray.length) {
            BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
            if (baseStorageHook != null) {
                try {
                    baseStorageHook.validateNativePaths(nativeCodeDescriptionArray[n].getNativePaths());
                }
                catch (BundleException bundleException) {
                    this.stateManager.getSystemState().setNativePathsInvalid(nativeCodeDescriptionArray[n], true);
                }
            }
            ++n;
        }
    }

    private void verifyEEandNativeCode(BundleDescription bundleDescription, BundleData bundleData, State state) throws BundleException {
        int n;
        Object[] objectArray;
        Object object;
        if (!Boolean.valueOf(FrameworkProperties.getProperty(Constants.ECLIPSE_EE_INSTALL_VERIFY, ((Object)Boolean.TRUE).toString())).booleanValue() || bundleDescription == null) {
            return;
        }
        String[] stringArray = bundleDescription.getExecutionEnvironments();
        if (stringArray.length > 0 && (object = FrameworkProperties.getProperty("org.osgi.framework.executionenvironment")) != null && !object.equals("")) {
            int n2;
            objectArray = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", (String)object);
            boolean bl = false;
            n = 0;
            while (n < objectArray.length && !bl) {
                n2 = 0;
                while (n2 < stringArray.length & !bl) {
                    if (((ManifestElement)objectArray[n]).getValue().equals(stringArray[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                ++n;
            }
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer(25);
                n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(stringArray[n2]);
                    ++n2;
                }
                throw new BundleException("Cannot match Execution Environment: " + ((Object)stringBuffer).toString());
            }
        }
        if ((object = bundleDescription.getNativeCodeSpecification()) != null) {
            state.setPlatformProperties(new Dictionary[]{FrameworkProperties.getProperties()});
            objectArray = object.getPossibleSuppliers();
            Object object2 = null;
            n = 0;
            while (n < objectArray.length) {
                if (object.isSatisfiedBy((BaseDescription)objectArray[n]) && (object2 == null || object2.compareTo(objectArray[n]) < 0)) {
                    object2 = objectArray[n];
                }
                ++n;
            }
            if (object2 == null) {
                if (!object.isOptional()) {
                    throw new BundleException("Unsatisfied Bundle-NativeCode: " + object.toString());
                }
            } else {
                bundleData.installNativeCode(object2.getNativePaths());
            }
        }
    }

    public long getNextBundleId() {
        return this.nextId++;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() != 32) {
            return;
        }
        BaseData baseData = (BaseData)((AbstractBundle)bundleEvent.getBundle()).getBundleData();
        try {
            if ((baseData.getType() & 2) != 0) {
                this.processFrameworkExtension(baseData, (byte)1);
            } else if ((baseData.getType() & 4) != 0) {
                this.processBootExtension(baseData, (byte)1);
            } else if ((baseData.getType() & 0x10) != 0) {
                this.processExtExtension(baseData, (byte)1);
            }
        }
        catch (BundleException bundleException) {}
    }

    public String copyToTempLibrary(BaseData baseData, String string) throws IOException {
        File file = this.getBundleStoreRoot();
        File file2 = new File(file, LIB_TEMP);
        File file3 = new File(string);
        String string2 = file3.getName();
        File file4 = null;
        File file5 = null;
        Long l = new Long(baseData.getBundleID());
        int n = 0;
        while (n < Integer.MAX_VALUE) {
            file4 = new File(file2, String.valueOf(((Object)l).toString()) + "_" + ((Object)new Integer(n)).toString());
            file5 = new File(file4, string2);
            if (!file4.exists() || !file5.exists()) break;
            ++n;
        }
        if (!file4.exists()) {
            file4.mkdirs();
            file4.deleteOnExit();
            File file6 = new File(file2, DELETE_FLAG);
            if (!file6.exists()) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file6);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        FileInputStream fileInputStream = new FileInputStream(file3);
        AdaptorUtil.readFile(fileInputStream, file5);
        BundleFile.setPermissions(file5);
        file5.deleteOnExit();
        return file5.getAbsolutePath();
    }

    static /* synthetic */ void access$1(BaseStorage baseStorage, boolean bl) {
        baseStorage.saveAllData(bl);
    }

    private class StateSaver
    implements Runnable {
        private long delay_interval = 30000L;
        private long max_total_delay_interval = 1800000L;
        private boolean shutdown = false;
        private long lastSaveTime = 0L;
        private Thread runningThread = null;

        StateSaver() {
            String string = FrameworkProperties.getProperty("eclipse.stateSaveDelayInterval");
            if (string != null) {
                try {
                    long l = Long.parseLong(string);
                    if (l >= 1000L && l <= 1800000L) {
                        this.delay_interval = l;
                        this.max_total_delay_interval = l * 60L;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            var2_2 = var1_1 = BaseStorage.access$0(BaseStorage.this).getState();
            synchronized (var2_2) {
                var3_3 = this.lastSaveTime;
                var5_4 = 0L;
                do lbl-1000:
                // 3 sources

                {
                    block7: {
                        block6: {
                            block8: {
                                if (System.currentTimeMillis() - var3_3 <= this.max_total_delay_interval) break block8;
                                var5_4 = this.lastSaveTime;
                                break block7;
                            }
                            var7_5 = Math.min(this.delay_interval, this.lastSaveTime - var5_4);
                            var5_4 = this.lastSaveTime;
                            try {
                                if (this.shutdown) break block6;
                                var1_1.wait(var7_5);
                            }
                            catch (InterruptedException v0) {
                                var5_4 = this.lastSaveTime;
                                break block7;
                            }
                        }
                        if (!this.shutdown && var5_4 < this.lastSaveTime) ** GOTO lbl-1000
                    }
                    BaseStorage.access$1(BaseStorage.this, false);
                } while (!this.shutdown && var5_4 < this.lastSaveTime);
                this.runningThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            block6: {
                State state = BaseStorage.this.adaptor.getState();
                Thread thread = null;
                State state2 = state;
                synchronized (state2) {
                    this.shutdown = true;
                    thread = this.runningThread;
                    state.notifyAll();
                }
                try {
                    if (thread != null) {
                        thread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!Debug.DEBUG_GENERAL) break block6;
                    Debug.println("Error shutdowning StateSaver: " + interruptedException.getMessage());
                    Debug.printStackTrace(interruptedException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestSave() {
            State state;
            State state2 = state = BaseStorage.this.adaptor.getState();
            synchronized (state2) {
                if (this.shutdown) {
                    return;
                }
                this.lastSaveTime = System.currentTimeMillis();
                if (this.runningThread == null) {
                    this.runningThread = new Thread((Runnable)this, "State Saver");
                    this.runningThread.start();
                }
            }
        }
    }
}

