/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class GenericSpecificationImpl
extends VersionConstraintImpl
implements GenericSpecification {
    private Filter matchingFilter;
    private String type = "generic";
    private int resolution = 0;
    private GenericDescription[] suppliers;

    public String getMatchingFilter() {
        return this.matchingFilter == null ? null : this.matchingFilter.toString();
    }

    void setMatchingFilter(String string) throws InvalidSyntaxException {
        this.matchingFilter = string == null ? null : FrameworkUtil.createFilter(string);
    }

    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        if (!(baseDescription instanceof GenericDescription)) {
            return false;
        }
        GenericDescription genericDescription = (GenericDescription)baseDescription;
        if (this.getName() == null || !this.getName().equals(genericDescription.getName())) {
            return false;
        }
        if (this.getType() == null || !this.getType().equals(genericDescription.getType())) {
            return false;
        }
        return this.matchingFilter == null || this.matchingFilter.match(genericDescription.getAttributes());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eclipse-GenericRequire").append(": ").append(this.getName());
        if (this.getType() != "generic") {
            stringBuffer.append(':').append(this.getType());
        }
        if (this.matchingFilter != null) {
            stringBuffer.append("; ").append(this.getMatchingFilter());
        }
        return ((Object)stringBuffer).toString();
    }

    public String getType() {
        return this.type;
    }

    void setType(String string) {
        this.type = string == null || string.equals("generic") ? "generic" : string;
    }

    public int getResolution() {
        return this.resolution;
    }

    public boolean isResolved() {
        return this.suppliers != null && this.suppliers.length > 0;
    }

    void setResolution(int n) {
        this.resolution = n;
    }

    public BaseDescription getSupplier() {
        return this.suppliers == null || this.suppliers.length == 0 ? null : this.suppliers[0];
    }

    protected void setSupplier(BaseDescription baseDescription) {
        if (baseDescription == null) {
            this.suppliers = null;
            return;
        }
        int n = this.suppliers == null ? 0 : this.suppliers.length;
        GenericDescription[] genericDescriptionArray = new GenericDescription[n + 1];
        if (this.suppliers != null) {
            System.arraycopy(this.suppliers, 0, genericDescriptionArray, 0, n);
        }
        genericDescriptionArray[n] = (GenericDescription)baseDescription;
        this.suppliers = genericDescriptionArray;
    }

    public GenericDescription[] getSuppliers() {
        return this.suppliers;
    }

    void setSupplers(GenericDescription[] genericDescriptionArray) {
        this.suppliers = genericDescriptionArray;
    }
}

