/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.osgi.framework.AdminPermission;

final class AdminPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3906372644575328048L;
    private Hashtable permissions = new Hashtable();

    public void add(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly AdminCollection");
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        AdminPermission adminPermission2 = (AdminPermission)this.permissions.get(adminPermission.getName());
        if (adminPermission2 != null) {
            int n;
            int n2 = adminPermission2.getMask();
            if (n2 != (n = adminPermission.getMask())) {
                this.permissions.put(adminPermission2.getName(), new AdminPermission(adminPermission2.getName(), n2 | n));
            }
        } else {
            this.permissions.put(adminPermission.getName(), adminPermission);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        Iterator iterator = this.permissions.values().iterator();
        while (iterator.hasNext()) {
            if (!((AdminPermission)iterator.next()).implies(adminPermission)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.permissions.values());
    }
}

