/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.profile;

import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.profile.DefaultProfileLogger;
import org.eclipse.osgi.internal.profile.ProfileLogger;

public class Profile {
    public static final boolean PROFILE = true;
    public static boolean STARTUP = false;
    public static boolean BENCHMARK = false;
    public static boolean DEBUG = false;
    private static final String OSGI_PROP = "osgi.profile.";
    private static final String PROP_STARTUP = "osgi.profile.startup";
    private static final String PROP_BENCHMARK = "osgi.profile.benchmark";
    private static final String PROP_DEBUG = "osgi.profile.debug";
    private static final String PROP_IMPL = "osgi.profile.impl";
    private static final String OSGI_OPTION = "org.eclipse.osgi/profile/";
    private static final String OPTION_STARTUP = "org.eclipse.osgi/profile/startup";
    private static final String OPTION_BENCHMARK = "org.eclipse.osgi/profile/benchmark";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/profile/debug";
    private static final String OPTION_IMPL = "org.eclipse.osgi/profile/impl";
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ENTER = 1;
    public static final int FLAG_EXIT = 2;
    public static final String ENTER_DESCRIPTION = "enter";
    public static final String EXIT_DESCRIPTION = "exit";
    private static ProfileLogger profileLogger = null;
    private static String profileLoggerClassName = null;

    static {
        Profile.initProps();
    }

    public static void initProps() {
        String string;
        FrameworkDebugOptions frameworkDebugOptions = null;
        if (FrameworkProperties.getProperty("osgi.debug") != null && (frameworkDebugOptions = FrameworkDebugOptions.getDefault()) != null) {
            STARTUP = frameworkDebugOptions.getBooleanOption(OPTION_STARTUP, false);
            BENCHMARK = frameworkDebugOptions.getBooleanOption(OPTION_BENCHMARK, false);
            DEBUG = frameworkDebugOptions.getBooleanOption(OPTION_DEBUG, false);
            if (profileLogger == null) {
                profileLoggerClassName = frameworkDebugOptions.getOption(OPTION_IMPL);
            }
        }
        if ((string = FrameworkProperties.getProperty(PROP_STARTUP)) != null) {
            STARTUP = Boolean.valueOf(string);
            if (frameworkDebugOptions != null) {
                frameworkDebugOptions.setOption(OPTION_STARTUP, ((Object)new Boolean(STARTUP)).toString());
            }
        }
        if ((string = FrameworkProperties.getProperty(PROP_BENCHMARK)) != null) {
            BENCHMARK = Boolean.valueOf(string);
            if (frameworkDebugOptions != null) {
                frameworkDebugOptions.setOption(OPTION_BENCHMARK, ((Object)new Boolean(BENCHMARK)).toString());
            }
        }
        if ((string = FrameworkProperties.getProperty(PROP_DEBUG)) != null) {
            DEBUG = Boolean.valueOf(string);
            if (frameworkDebugOptions != null) {
                frameworkDebugOptions.setOption(OPTION_DEBUG, ((Object)new Boolean(DEBUG)).toString());
            }
        }
        if (profileLogger == null) {
            string = FrameworkProperties.getProperty(PROP_IMPL);
            if (string != null) {
                profileLoggerClassName = string;
                if (frameworkDebugOptions != null) {
                    frameworkDebugOptions.setOption(OPTION_IMPL, profileLoggerClassName);
                }
            }
        } else {
            profileLogger.initProps();
        }
    }

    public static void logEnter(String string) {
        Profile.logTime(1, string, ENTER_DESCRIPTION, null);
    }

    public static void logEnter(String string, String string2) {
        Profile.logTime(1, string, ENTER_DESCRIPTION, string2);
    }

    public static void logExit(String string) {
        Profile.logTime(2, string, EXIT_DESCRIPTION, null);
    }

    public static void logExit(String string, String string2) {
        Profile.logTime(2, string, EXIT_DESCRIPTION, string2);
    }

    public static void logTime(String string, String string2) {
        Profile.logTime(0, string, string2, null);
    }

    public static void logTime(String string, String string2, String string3) {
        Profile.logTime(0, string, string2, string3);
    }

    public static void logTime(int n, String string, String string2, String string3) {
        if (profileLogger == null) {
            profileLogger = Profile.createProfileLogger();
        }
        profileLogger.logTime(n, string, string2, string3);
    }

    public static void accumLogEnter(String string) {
        if (profileLogger == null) {
            profileLogger = Profile.createProfileLogger();
        }
        profileLogger.accumLogEnter(string);
    }

    public static void accumLogExit(String string) {
        if (profileLogger == null) {
            profileLogger = Profile.createProfileLogger();
        }
        profileLogger.accumLogExit(string);
    }

    public static String getProfileLog() {
        if (profileLogger != null) {
            return profileLogger.getProfileLog();
        }
        return "";
    }

    private static ProfileLogger createProfileLogger() {
        ProfileLogger profileLogger = null;
        if (profileLoggerClassName != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(profileLoggerClassName);
                profileLogger = (ProfileLogger)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (profileLogger == null) {
            profileLogger = new DefaultProfileLogger();
        }
        return profileLogger;
    }
}

