/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PartPlaceholder;

public class LayoutTree
implements ISizeProvider {
    LayoutTreeNode parent;
    LayoutPart part;
    private int cachedMinimumWidthHint = -1;
    private int cachedMinimumWidth = -1;
    private int cachedMinimumHeightHint = -1;
    private int cachedMinimumHeight = -1;
    private int cachedMaximumWidthHint = -1;
    private int cachedMaximumWidth = -1;
    private int cachedMaximumHeightHint = -1;
    private int cachedMaximumHeight = -1;
    private boolean sizeFlagsDirty = true;
    private int widthSizeFlags = 0;
    private int heightSizeFlags = 0;
    public static int minCacheHits;
    public static int minCacheMisses;
    public static int maxCacheHits;
    public static int maxCacheMisses;
    private boolean forceLayout = true;
    private Rectangle currentBounds = new Rectangle(0, 0, 0, 0);

    public LayoutTree(LayoutPart layoutPart) {
        this.part = layoutPart;
    }

    public LayoutPart computeRelation(ArrayList arrayList) {
        return this.part;
    }

    public LayoutPart findPart(Point point) {
        return this.part;
    }

    public void disposeSashes() {
    }

    public LayoutTree find(LayoutPart layoutPart) {
        if (this.part != layoutPart) {
            return null;
        }
        return this;
    }

    public LayoutPart findBottomRight() {
        return this.part;
    }

    public final Rectangle getBounds() {
        return Geometry.copy((Rectangle)this.currentBounds);
    }

    public static int subtract(int n, int n2) {
        Assert.isTrue((n2 >= 0 && n2 < Integer.MAX_VALUE ? 1 : 0) != 0);
        return LayoutTree.add(n, -n2);
    }

    public static int add(int n, int n2) {
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return n + n2;
    }

    public static void assertValidSize(int n) {
        Assert.isTrue((n >= 0 && (n == Integer.MAX_VALUE || n < 0x3FFFFFFF) ? 1 : 0) != 0);
    }

    public final int computePreferredSize(boolean bl, int n, int n2, int n3) {
        LayoutTree.assertValidSize(n);
        LayoutTree.assertValidSize(n2);
        LayoutTree.assertValidSize(n3);
        if (!this.isVisible()) {
            return 0;
        }
        if (n == 0) {
            return 0;
        }
        if (n3 == 0) {
            return Math.min(n, this.computeMinimumSize(bl, n2));
        }
        if (n3 == Integer.MAX_VALUE && n == Integer.MAX_VALUE) {
            return this.computeMaximumSize(bl, n2);
        }
        if (!this.hasSizeFlag(bl, 4)) {
            return n3;
        }
        int n4 = this.doComputePreferredSize(bl, n, n2, n3);
        return n4;
    }

    protected int doGetSizeFlags(boolean bl) {
        return this.part.getSizeFlags(bl);
    }

    protected int doComputePreferredSize(boolean bl, int n, int n2, int n3) {
        int n4 = Math.min(n, this.part.computePreferredSize(bl, n, n2, n3));
        LayoutTree.assertValidSize(n4);
        return n4;
    }

    public final int computeMinimumSize(boolean bl, int n) {
        int n2;
        LayoutTree.assertValidSize(n);
        if (!this.hasSizeFlag(bl, 128)) {
            return 0;
        }
        if (!this.hasSizeFlag(bl, 64)) {
            n = Integer.MAX_VALUE;
        }
        if (bl) {
            int n3;
            if (this.cachedMinimumWidthHint == n) {
                ++minCacheHits;
                return this.cachedMinimumWidth;
            }
            ++minCacheMisses;
            this.cachedMinimumWidth = n3 = this.doComputeMinimumSize(bl, n);
            this.cachedMinimumWidthHint = n;
            return n3;
        }
        if (this.cachedMinimumHeightHint == n) {
            ++minCacheHits;
            return this.cachedMinimumHeight;
        }
        ++minCacheMisses;
        this.cachedMinimumHeight = n2 = this.doComputeMinimumSize(bl, n);
        this.cachedMinimumHeightHint = n;
        return n2;
    }

    public static void printCacheStatistics() {
        System.out.println("minimize cache " + minCacheHits + " / " + (minCacheHits + minCacheMisses) + " hits " + minCacheHits * 100 / (minCacheHits + minCacheMisses) + "%");
        System.out.println("maximize cache " + maxCacheHits + " / " + (maxCacheHits + maxCacheMisses) + " hits" + maxCacheHits * 100 / (maxCacheHits + maxCacheMisses) + "%");
    }

    public int doComputeMinimumSize(boolean bl, int n) {
        int n2 = this.doComputePreferredSize(bl, Integer.MAX_VALUE, n, 0);
        LayoutTree.assertValidSize(n2);
        return n2;
    }

    public final int computeMaximumSize(boolean bl, int n) {
        int n2;
        LayoutTree.assertValidSize(n);
        if (!this.hasSizeFlag(bl, 1024)) {
            return Integer.MAX_VALUE;
        }
        if (!this.hasSizeFlag(bl, 64)) {
            n = Integer.MAX_VALUE;
        }
        if (bl) {
            int n3;
            if (this.cachedMaximumWidthHint == n) {
                ++maxCacheHits;
                return this.cachedMaximumWidth;
            }
            ++maxCacheMisses;
            this.cachedMaximumWidth = n3 = this.doComputeMaximumSize(bl, n);
            this.cachedMaximumWidthHint = n;
            return n3;
        }
        if (this.cachedMaximumHeightHint == n) {
            ++maxCacheHits;
            return this.cachedMaximumHeight;
        }
        ++maxCacheMisses;
        this.cachedMaximumHeight = n2 = this.doComputeMaximumSize(bl, n);
        this.cachedMaximumHeightHint = n;
        return n2;
    }

    protected int doComputeMaximumSize(boolean bl, int n) {
        return this.doComputePreferredSize(bl, Integer.MAX_VALUE, n, Integer.MAX_VALUE);
    }

    public void flushNode() {
        this.cachedMinimumWidthHint = -1;
        this.cachedMinimumWidth = -1;
        this.cachedMinimumHeightHint = -1;
        this.cachedMinimumHeight = -1;
        this.cachedMaximumWidthHint = -1;
        this.cachedMaximumWidth = -1;
        this.cachedMaximumHeightHint = -1;
        this.cachedMaximumHeight = -1;
        this.sizeFlagsDirty = true;
        this.forceLayout = true;
    }

    public void flushChildren() {
        this.flushNode();
    }

    public final void flushCache() {
        this.flushNode();
        if (this.parent != null) {
            this.parent.flushCache();
        }
    }

    public final int getSizeFlags(boolean bl) {
        if (this.sizeFlagsDirty) {
            this.widthSizeFlags = this.doGetSizeFlags(true);
            this.heightSizeFlags = this.doGetSizeFlags(false);
            this.sizeFlagsDirty = false;
        }
        return bl ? this.widthSizeFlags : this.heightSizeFlags;
    }

    public LayoutTreeNode getParent() {
        return this.parent;
    }

    public LayoutTree insert(LayoutPart layoutPart, boolean bl, LayoutPartSash layoutPartSash, LayoutPart layoutPart2) {
        LayoutTree layoutTree = this.find(layoutPart2);
        LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layoutPartSash);
        if (layoutTree == null) {
            layoutTreeNode.setChild(bl, layoutPart);
            layoutTreeNode.setChild(!bl, this);
            return layoutTreeNode;
        }
        LayoutTreeNode layoutTreeNode2 = layoutTree.getParent();
        layoutTreeNode.setChild(bl, layoutPart);
        layoutTreeNode.setChild(!bl, layoutTree);
        if (layoutTreeNode2 == null) {
            return layoutTreeNode;
        }
        layoutTreeNode2.replaceChild(layoutTree, layoutTreeNode);
        return this;
    }

    public boolean isCompressible() {
        return this.part.isCompressible();
    }

    public boolean isVisible() {
        return !(this.part instanceof PartPlaceholder);
    }

    public void recomputeRatio() {
    }

    public LayoutTree remove(LayoutPart layoutPart) {
        LayoutTree layoutTree = this.find(layoutPart);
        if (layoutTree == null) {
            return this;
        }
        LayoutTreeNode layoutTreeNode = layoutTree.getParent();
        if (layoutTreeNode == null) {
            return null;
        }
        if (layoutTreeNode.getParent() == null) {
            return layoutTreeNode.remove(layoutTree);
        }
        layoutTreeNode.remove(layoutTree);
        return this;
    }

    public final void setBounds(Rectangle rectangle) {
        if (!rectangle.equals((Object)this.currentBounds) || this.forceLayout) {
            this.currentBounds = Geometry.copy((Rectangle)rectangle);
            this.doSetBounds(this.currentBounds);
            this.forceLayout = false;
        }
    }

    protected void doSetBounds(Rectangle rectangle) {
        this.part.setBounds(rectangle);
    }

    void setParent(LayoutTreeNode layoutTreeNode) {
        this.parent = layoutTreeNode;
    }

    void setPart(LayoutPart layoutPart) {
        this.part = layoutPart;
        this.flushCache();
    }

    public String toString() {
        return "(" + this.part.toString() + ")";
    }

    public void createControl(Composite composite) {
    }

    public void describeLayout(StringBuffer stringBuffer) {
        this.part.describeLayout(stringBuffer);
    }

    public final boolean hasSizeFlag(boolean bl, int n) {
        return (this.getSizeFlags(bl) & n) != 0;
    }
}

