/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.Verifier;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.security.CertificatePair;
import org.eclipse.update.internal.security.JarVerificationResult;
import org.eclipse.update.internal.security.KeyStores;
import org.eclipse.update.internal.security.KeystoreHandle;

public class JarVerifier
extends Verifier {
    private static final String MANIFEST = "META-INF";
    private JarVerificationResult result;
    private List trustedCertificates;
    private boolean acceptUnsignedFiles;
    private List listOfKeystores;
    private IProgressMonitor monitor;
    private File jarFile;
    private static byte[] buffer = new byte[8192];

    public JarVerifier() {
        this.initialize();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getKeyStores() throws CoreException {
        if (this.listOfKeystores != null) return this.listOfKeystores;
        this.listOfKeystores = new ArrayList(0);
        KeyStores keyStores = new KeyStores();
        InputStream inputStream = null;
        KeyStore keyStore = null;
        KeystoreHandle keystoreHandle = null;
        while (keyStores.hasNext()) {
            try {
                block14: {
                    Object var6_5;
                    keystoreHandle = keyStores.next();
                    inputStream = ConnectionFactory.get(keystoreHandle.getLocation()).getInputStream();
                    try {
                        try {
                            keyStore = KeyStore.getInstance(keystoreHandle.getType());
                            keyStore.load(inputStream, null);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToFindEncryption, (Object[])new String[]{keystoreHandle.getLocation().toExternalForm()}), noSuchAlgorithmException);
                        }
                        catch (CertificateException certificateException) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToLoadCertificate, (Object[])new String[]{keystoreHandle.getLocation().toExternalForm()}), certificateException);
                        }
                        catch (KeyStoreException keyStoreException) {
                            throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToFindProviderForKeystore, (Object[])new String[]{keystoreHandle.getType()}), keyStoreException);
                        }
                    }
                    catch (Throwable throwable) {
                        var6_5 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        var6_5 = null;
                        if (inputStream == null) break block14;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                }
                this.listOfKeystores.add(keyStore);
            }
            catch (IOException iOException) {}
        }
        return this.listOfKeystores;
    }

    private void initialize() {
        this.result = null;
        this.trustedCertificates = null;
        this.acceptUnsignedFiles = false;
        this.listOfKeystores = null;
    }

    private void init(IFeature iFeature, ContentReference contentReference) throws CoreException {
        this.jarFile = null;
        if (contentReference instanceof JarContentReference) {
            JarContentReference jarContentReference = (JarContentReference)contentReference;
            try {
                this.jarFile = jarContentReference.asFile();
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                    UpdateCore.debug("Attempting to read JAR file:" + this.jarFile);
                }
                if (!this.jarFile.exists()) {
                    throw new IOException();
                }
                JarFile jarFile = new JarFile(this.jarFile);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (ZipException zipException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_InvalidJar, (Object[])new String[]{jarContentReference.toString()}), zipException);
            }
            catch (IOException iOException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.JarVerifier_UnableToAccessJar, (Object[])new String[]{jarContentReference.toString()}), iOException);
            }
        }
        this.result = new JarVerificationResult();
        this.result.setVerificationCode(6);
        this.result.setResultException(null);
        this.result.setFeature(iFeature);
        this.result.setContentReference(contentReference);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsInKeystore(Certificate certificate) throws CoreException {
        try {
            KeyStore keyStore;
            List list = this.getKeyStores();
            if (list.isEmpty()) return false;
            Iterator iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((keyStore = (KeyStore)iterator.next()).getCertificateAlias(certificate) == null);
            return true;
        }
        catch (KeyStoreException keyStoreException) {
            throw Utilities.newCoreException(Messages.JarVerifier_KeyStoreNotLoaded, keyStoreException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List readJarFile(JarFile var1_1, String var2_2) throws IOException, InterruptedException {
        var3_3 = new ArrayList<JarEntry>();
        var4_4 = var1_1.entries();
        var5_5 = null;
        var6_6 = null;
        if (this.monitor == null) ** GOTO lbl-1000
        this.monitor.setTaskName(NLS.bind((String)Messages.JarVerifier_Verify, (Object[])new String[]{var2_2 == null ? var1_1.getName() : var2_2}));
        try {
            try lbl-1000:
            // 4 sources

            {
                while (var4_4.hasMoreElements()) {
                    var5_5 = var4_4.nextElement();
                    var3_3.add(var5_5);
                    var6_6 = var1_1.getInputStream(var5_5);
                    while (var6_6.read(JarVerifier.buffer, 0, JarVerifier.buffer.length) != -1) {
                    }
                    if (var6_6 == null) continue;
                    var6_6.close();
                }
            }
            catch (IOException var7_7) {
                this.result.setVerificationCode(6);
                this.result.setResultException(var7_7);
            }
        }
        catch (Throwable var9_8) {
            var8_9 = null;
            try {
                if (var6_6 == null) throw var9_8;
                var6_6.close();
                throw var9_8;
            }
            catch (IOException v0) {}
            throw var9_8;
        }
        {
            var8_10 = null;
        }
        try {}
        catch (IOException v1) {
            return var3_3;
        }
        if (var6_6 == null) return var3_3;
        var6_6.close();
        return var3_3;
    }

    public void setMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    public IVerificationResult verify(IFeature iFeature, ContentReference contentReference, boolean bl, InstallMonitor installMonitor) throws CoreException {
        IVerificationResult iVerificationResult;
        if (contentReference == null) {
            return this.result;
        }
        if (this.getParent() != null && (iVerificationResult = this.getParent().verify(iFeature, contentReference, bl, installMonitor)).getVerificationCode() != 8) {
            return iVerificationResult;
        }
        this.setMonitor(installMonitor);
        this.init(iFeature, contentReference);
        this.result.isFeatureVerification(bl);
        if (this.jarFile != null) {
            this.result = this.verify(this.jarFile.getAbsolutePath(), contentReference.getIdentifier());
        } else {
            this.result.setVerificationCode(8);
        }
        return this.result;
    }

    private JarVerificationResult verify(String string, String string2) {
        try {
            this.verifyIntegrity(string, string2);
            this.result.alreadySeen(this.alreadyValidated());
            if (this.result.getVerificationCode() == 5) {
                this.verifyAuthentication();
            }
            if (this.result.getVerificationCode() == 1) {
                this.acceptUnsignedFiles = true;
            }
        }
        catch (Exception exception) {
            this.result.setVerificationCode(6);
            this.result.setResultException(exception);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
            if (this.monitor.isCanceled()) {
                this.result.setVerificationCode(7);
            }
        }
        return this.result;
    }

    private void verifyAuthentication() throws CoreException {
        CertificatePair[] certificatePairArray = this.result.getRootCertificates();
        boolean bl = false;
        int n = 0;
        while (n < certificatePairArray.length) {
            bl = this.existsInKeystore(certificatePairArray[n].getRoot());
            if (bl) {
                this.result.setVerificationCode(3);
                this.result.setFoundCertificate(certificatePairArray[n]);
                return;
            }
            ++n;
        }
    }

    /*
     * Exception decompiling
     */
    private void verifyIntegrity(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 276->280)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean alreadyValidated() {
        if (this.result.getVerificationCode() == 1) {
            return this.acceptUnsignedFiles;
        }
        if (this.getTrustedCertificates() != null) {
            Iterator iterator = this.getTrustedCertificates().iterator();
            CertificatePair[] certificatePairArray = this.result.getRootCertificates();
            while (iterator.hasNext()) {
                CertificatePair certificatePair = (CertificatePair)iterator.next();
                int n = 0;
                while (n < certificatePairArray.length) {
                    if (certificatePair.equals(certificatePairArray[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            int n = 0;
            while (n < certificatePairArray.length) {
                this.addTrustedCertificate(certificatePairArray[n]);
                ++n;
            }
        }
        return false;
    }

    private void addTrustedCertificate(CertificatePair certificatePair) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        if (certificatePair != null) {
            this.trustedCertificates.add(certificatePair);
        }
    }

    private List getTrustedCertificates() {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        return this.trustedCertificates;
    }

    public void setParent(IVerifier iVerifier) {
        super.setParent(iVerifier);
        this.initialize();
    }
}

