/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import com.ibm.ugl.eswt.OS;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.InternalGCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class Device
implements Drawable {
    public int internal_handle = 0;
    public static int internal_vkstatus = 1;
    Font systemFont;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    protected static Device Internal_CurrentDevice;
    protected static Runnable Internal_DeviceFinder;

    public Device() {
        this.internal_create();
        this.init();
    }

    protected void checkDevice() {
        if (this.internal_handle == 0) {
            SWT.error(45);
        }
    }

    protected void internal_create() {
    }

    protected void destroy() {
        OS.Device_Dispose(this.internal_handle);
        this.internal_handle = 0;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int[] bounds = OS.Device_GetBounds(this.internal_handle);
        return new Rectangle(bounds[0], bounds[1], bounds[2], bounds[3]);
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return OS.Device_GetDepth(this.internal_handle);
    }

    static Device getDevice() {
        if (Internal_DeviceFinder != null) {
            Internal_DeviceFinder.run();
        }
        Device device = Internal_CurrentDevice;
        Internal_CurrentDevice = null;
        return device;
    }

    public Point getDPI() {
        this.checkDevice();
        int[] dpi = OS.Device_GetDPI(this.internal_handle);
        return new Point(dpi[0], dpi[1]);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        FontData[] result = null;
        String[] typefaces = OS.Device_GetTypefaces(this.internal_handle, scalable);
        if (faceName == null) {
            int i;
            Vector<FontData> list = new Vector<FontData>();
            for (i = 0; i < typefaces.length; ++i) {
                String[] variants = OS.Device_GetTypefaceVariants(this.internal_handle, typefaces[i], scalable);
                for (int v = 0; v < variants.length; ++v) {
                    list.addElement(new FontData(variants[v]));
                }
            }
            result = new FontData[list.size()];
            for (i = 0; i < result.length; ++i) {
                result[i] = (FontData)list.elementAt(i);
            }
        } else {
            for (int i = 0; i < typefaces.length; ++i) {
                if (!faceName.equals(typefaces[i])) continue;
                String[] variants = OS.Device_GetTypefaceVariants(this.internal_handle, typefaces[i], scalable);
                result = new FontData[variants.length];
                for (int v = 0; v < variants.length; ++v) {
                    result[v] = new FontData(variants[v]);
                }
                break;
            }
        }
        if (result == null && typefaces.length != 0) {
            String[] variants = OS.Device_GetTypefaceVariants(this.internal_handle, typefaces[0], scalable);
            result = new FontData[variants.length];
            for (int v = 0; v < variants.length; ++v) {
                result[v] = new FontData(variants[v]);
            }
        }
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont == null) {
            this.systemFont = new Font(OS.Device_GetSystemFont(this.internal_handle));
        }
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
    }

    public abstract void internal_dispose_GC(int var1, InternalGCData var2);

    public abstract int internal_new_GC(InternalGCData var1);

    public boolean isDisposed() {
        return this.internal_handle == 0;
    }

    protected void release() {
        this.COLOR_BLACK.dispose();
        this.COLOR_DARK_RED.dispose();
        this.COLOR_DARK_GREEN.dispose();
        this.COLOR_DARK_YELLOW.dispose();
        this.COLOR_DARK_BLUE.dispose();
        this.COLOR_DARK_MAGENTA.dispose();
        this.COLOR_DARK_CYAN.dispose();
        this.COLOR_GRAY.dispose();
        this.COLOR_DARK_GRAY.dispose();
        this.COLOR_RED.dispose();
        this.COLOR_GREEN.dispose();
        this.COLOR_YELLOW.dispose();
        this.COLOR_BLUE.dispose();
        this.COLOR_MAGENTA.dispose();
        this.COLOR_CYAN.dispose();
        this.COLOR_WHITE.dispose();
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

